/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainingBranchesGetter
implements VcsLogListener {
    private static final Logger LOG = Logger.getInstance(ContainingBranchesGetter.class);
    @NotNull
    private final SequentialLimitedLifoExecutor<Task> myTaskExecutor;
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private volatile SLRUMap<Hash, List<String>> myCache;
    @Nullable
    private Runnable myLoadingFinishedListener;
    private int myCurrentBranchesChecksum;

    ContainingBranchesGetter(@NotNull VcsLogDataHolder dataHolder, @NotNull Disposable parentDisposable) {
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/vcs/log/data/ContainingBranchesGetter", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/vcs/log/data/ContainingBranchesGetter", "<init>"));
        }
        this.myCache = ContainingBranchesGetter.createCache();
        this.myDataHolder = dataHolder;
        this.myTaskExecutor = new SequentialLimitedLifoExecutor<Task>(parentDisposable, 10, new ThrowableConsumer<Task, Throwable>(){

            public void consume(final Task task) throws Throwable {
                final List branches = ContainingBranchesGetter.this.getContainingBranches(task.root, task.hash);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        task.cache.put((Object)task.hash, (Object)branches);
                        ContainingBranchesGetter.this.notifyListener();
                    }
                });
            }
        });
    }

    public void onChange(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/data/ContainingBranchesGetter", "onChange"));
        }
        if (refreshHappened) {
            Collection currentBranches = dataPack.getRefs().getBranches();
            int checksum = ((Object)currentBranches).hashCode();
            if (this.myCurrentBranchesChecksum != 0 && this.myCurrentBranchesChecksum != checksum) {
                this.clearCache();
            }
            this.myCurrentBranchesChecksum = checksum;
        }
    }

    private void clearCache() {
        this.myCache = ContainingBranchesGetter.createCache();
        this.myTaskExecutor.clear();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ContainingBranchesGetter.this.notifyListener();
            }
        });
    }

    public void setTaskCompletedListener(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/vcs/log/data/ContainingBranchesGetter", "setTaskCompletedListener"));
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.myLoadingFinishedListener = runnable;
    }

    private void notifyListener() {
        LOG.assertTrue(EventQueue.isDispatchThread());
        if (this.myLoadingFinishedListener != null) {
            this.myLoadingFinishedListener.run();
        }
    }

    @Nullable
    public List<String> requestContainingBranches(@NotNull VirtualFile root, @NotNull Hash hash) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/ContainingBranchesGetter", "requestContainingBranches"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/ContainingBranchesGetter", "requestContainingBranches"));
        }
        List refs = (List)this.myCache.get((Object)hash);
        if (refs == null) {
            this.myTaskExecutor.queue(new Task(root, hash, this.myCache));
        }
        return refs;
    }

    @NotNull
    private static SLRUMap<Hash, List<String>> createCache() {
        SLRUMap sLRUMap = new SLRUMap(1000, 1000);
        if (sLRUMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/ContainingBranchesGetter", "createCache"));
        }
        return sLRUMap;
    }

    @NotNull
    private List<String> getContainingBranches(@NotNull VirtualFile root, @NotNull Hash hash) {
        ArrayList<String> arrayList;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainingBranches"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainingBranches"));
        }
        try {
            ArrayList<String> branches = new ArrayList<String>(this.myDataHolder.getLogProvider(root).getContainingBranches(root, hash));
            Collections.sort(branches);
            arrayList = branches;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainingBranches"));
            }
            return list;
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/ContainingBranchesGetter", "getContainingBranches"));
        }
        return arrayList;
    }

    private static class Task {
        private final VirtualFile root;
        private final Hash hash;
        private final SLRUMap<Hash, List<String>> cache;

        public Task(VirtualFile root, Hash hash, SLRUMap<Hash, List<String>> cache) {
            this.root = root;
            this.hash = hash;
            this.cache = cache;
        }
    }
}

