/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.api.elements;

import com.intellij.vcs.log.graph.api.elements.GraphElement;
import org.jetbrains.annotations.NotNull;

public final class GraphEdge
implements GraphElement {
    private final int myUpNodeIndex;
    private final int myDownNodeIndex;
    @NotNull
    private final Type myType;

    public GraphEdge(int upNodeIndex, int downNodeIndex, @NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/graph/api/elements/GraphEdge", "<init>"));
        }
        this.myUpNodeIndex = upNodeIndex;
        this.myDownNodeIndex = downNodeIndex;
        this.myType = type;
    }

    public int getUpNodeIndex() {
        return this.myUpNodeIndex;
    }

    public int getDownNodeIndex() {
        return this.myDownNodeIndex;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/api/elements/GraphEdge", "getType"));
        }
        return type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphEdge graphEdge = (GraphEdge)o;
        if (this.myDownNodeIndex != graphEdge.myDownNodeIndex) {
            return false;
        }
        if (this.myUpNodeIndex != graphEdge.myUpNodeIndex) {
            return false;
        }
        return this.myType == graphEdge.myType;
    }

    public int hashCode() {
        int result = this.myUpNodeIndex;
        result = 31 * result + this.myDownNodeIndex;
        result = 31 * result + this.myType.hashCode();
        return result;
    }

    public static enum Type {
        USUAL,
        HIDE;

    }
}

