/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.TimedVcsCommitImpl;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsCommitMetadataImpl;
import com.intellij.vcs.log.impl.VcsRefImpl;
import com.intellij.vcs.log.impl.VcsShortCommitDetailsImpl;
import com.intellij.vcs.log.impl.VcsUserImpl;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsLogObjectsFactoryImpl
implements VcsLogObjectsFactory {
    @NotNull
    public Hash createHash(@NotNull String stringHash) {
        if (stringHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringHash", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createHash"));
        }
        Hash hash = HashImpl.build(stringHash);
        if (hash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createHash"));
        }
        return hash;
    }

    @NotNull
    public TimedVcsCommit createTimedCommit(@NotNull Hash hash, @NotNull List<Hash> parents, long timeStamp) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createTimedCommit"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createTimedCommit"));
        }
        TimedVcsCommitImpl timedVcsCommitImpl = new TimedVcsCommitImpl(hash, parents, timeStamp);
        if (timedVcsCommitImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createTimedCommit"));
        }
        return timedVcsCommitImpl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public VcsShortCommitDetails createShortDetails(@NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, @NotNull VirtualFile root, @NotNull String subject, @NotNull String authorName, String authorEmail, @NotNull String committerName, @NotNull String committerEmail, long l) {
        void authorTime;
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createShortDetails"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createShortDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createShortDetails"));
        }
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createShortDetails"));
        }
        if (authorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createShortDetails"));
        }
        if (committerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authorEmail", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createShortDetails"));
        }
        if (committerEmail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "committerName", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createShortDetails"));
        }
        VcsUser author = this.createUser(authorName, authorEmail);
        VcsUser committer = this.createUser(committerName, committerEmail);
        VcsShortCommitDetailsImpl vcsShortCommitDetailsImpl = new VcsShortCommitDetailsImpl(hash, parents, commitTime, root, subject, author, committer, (long)authorTime);
        if (vcsShortCommitDetailsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createShortDetails"));
        }
        return vcsShortCommitDetailsImpl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public VcsCommitMetadata createCommitMetadata(@NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, @NotNull VirtualFile root, @NotNull String subject, @NotNull String authorName, @NotNull String authorEmail, @NotNull String message, @NotNull String committerName, @NotNull String committerEmail, long l) {
        void authorTime;
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (authorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (authorEmail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authorName", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authorEmail", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (committerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        if (committerEmail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "committerName", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        VcsUser author = this.createUser(authorName, authorEmail);
        VcsUser committer = this.createUser(committerName, committerEmail);
        VcsCommitMetadataImpl vcsCommitMetadataImpl = new VcsCommitMetadataImpl(hash, parents, commitTime, root, subject, author, message, committer, (long)authorTime);
        if (vcsCommitMetadataImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createCommitMetadata"));
        }
        return vcsCommitMetadataImpl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public VcsFullCommitDetails createFullDetails(@NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, VirtualFile root, @NotNull String subject, @NotNull String authorName, @NotNull String authorEmail, @NotNull String message, @NotNull String committerName, @NotNull String committerEmail, long authorTime, @NotNull ThrowableComputable<Collection<Change>, ? extends Exception> throwableComputable) {
        void changesGetter;
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (authorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (authorEmail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authorName", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authorEmail", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (committerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (committerEmail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "committerName", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        if (throwableComputable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authorTime", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        VcsUser author = this.createUser(authorName, authorEmail);
        VcsUser committer = this.createUser(committerName, committerEmail);
        VcsChangesLazilyParsedDetails vcsChangesLazilyParsedDetails = new VcsChangesLazilyParsedDetails(hash, parents, commitTime, root, subject, author, message, committer, authorTime, (ThrowableComputable<Collection<Change>, ? extends Exception>)changesGetter);
        if (vcsChangesLazilyParsedDetails == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createFullDetails"));
        }
        return vcsChangesLazilyParsedDetails;
    }

    @NotNull
    public VcsUser createUser(@NotNull String name, @NotNull String email) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createUser"));
        }
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createUser"));
        }
        VcsUserImpl vcsUserImpl = new VcsUserImpl(name, email);
        if (vcsUserImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createUser"));
        }
        return vcsUserImpl;
    }

    @NotNull
    public VcsRef createRef(@NotNull Hash commitHash, @NotNull String name, @NotNull VcsRefType type, @NotNull VirtualFile root) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createRef"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createRef"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createRef"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createRef"));
        }
        VcsRefImpl vcsRefImpl = new VcsRefImpl(commitHash, name, type, root);
        if (vcsRefImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogObjectsFactoryImpl", "createRef"));
        }
        return vcsRefImpl;
    }
}

