/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointPropertiesSubPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class XSuspendPolicyPanel<B extends XBreakpoint<?>>
extends XBreakpointPropertiesSubPanel<B> {
    private JCheckBox mySuspendCheckBox;
    private JRadioButton mySuspendAll;
    private JRadioButton mySuspendThread;
    private JPanel myContentPane;
    private JButton myMakeDefaultButton;
    private ButtonGroup mySuspendPolicyGroup;
    private Delegate myDelegate;

    public XSuspendPolicyPanel() {
        this.$$$setupUI$$$();
    }

    @Override
    public void init(Project project, XBreakpointManager breakpointManager, @NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/ui/XSuspendPolicyPanel", "init"));
        }
        super.init(project, breakpointManager, breakpoint);
        this.mySuspendCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean selected = XSuspendPolicyPanel.this.mySuspendCheckBox.isSelected();
                if (XSuspendPolicyPanel.this.myBreakpoint.getType().isSuspendThreadSupported()) {
                    XSuspendPolicyPanel.this.changeEnableState(selected);
                }
                if (XSuspendPolicyPanel.this.myDelegate != null && !selected) {
                    XSuspendPolicyPanel.this.myDelegate.showMoreOptionsIfNeeded();
                }
            }
        });
        if (!this.myBreakpoint.getType().isSuspendThreadSupported()) {
            return;
        }
        this.mySuspendPolicyGroup = new ButtonGroup();
        this.mySuspendPolicyGroup.add(this.mySuspendAll);
        this.mySuspendPolicyGroup.add(this.mySuspendThread);
        this.updateSuspendPolicyFont();
        ItemListener suspendPolicyChangeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XSuspendPolicyPanel.this.updateMakeDefaultEnableState();
            }
        };
        this.updateMakeDefaultEnableState();
        this.mySuspendAll.addItemListener(suspendPolicyChangeListener);
        this.mySuspendThread.addItemListener(suspendPolicyChangeListener);
        this.myMakeDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SuspendPolicy suspendPolicy = XSuspendPolicyPanel.this.getSelectedSuspendPolicy();
                ((XBreakpointManagerImpl)XSuspendPolicyPanel.this.myBreakpointManager).getBreakpointDefaults(XSuspendPolicyPanel.this.myBreakpointType).setSuspendPolicy(suspendPolicy);
                XSuspendPolicyPanel.this.updateSuspendPolicyFont();
                if (SuspendPolicy.THREAD == suspendPolicy) {
                    XSuspendPolicyPanel.this.mySuspendThread.requestFocus();
                } else {
                    XSuspendPolicyPanel.this.mySuspendAll.requestFocus();
                }
                XSuspendPolicyPanel.this.myMakeDefaultButton.setEnabled(false);
            }
        });
    }

    private void updateMakeDefaultEnableState() {
        this.myMakeDefaultButton.setEnabled(!this.getSelectedSuspendPolicy().equals((Object)((XBreakpointManagerImpl)this.myBreakpointManager).getBreakpointDefaults(this.myBreakpointType).getSuspendPolicy()));
    }

    private void updateSuspendPolicyFont() {
        SuspendPolicy defaultPolicy = ((XBreakpointManagerImpl)this.myBreakpointManager).getBreakpointDefaults(this.myBreakpointType).getSuspendPolicy();
        Font font = this.mySuspendAll.getFont().deriveFont(0);
        Font boldFont = font.deriveFont(1);
        this.mySuspendAll.setFont(SuspendPolicy.ALL.equals((Object)defaultPolicy) ? boldFont : font);
        this.mySuspendThread.setFont(SuspendPolicy.THREAD.equals((Object)defaultPolicy) ? boldFont : font);
    }

    private void changeEnableState(boolean selected) {
        this.mySuspendAll.setEnabled(selected);
        this.mySuspendThread.setEnabled(selected);
        if (selected) {
            this.updateMakeDefaultEnableState();
        } else {
            this.myMakeDefaultButton.setEnabled(false);
        }
    }

    private void changeVisibleState(boolean suspendThreadSupported) {
        this.mySuspendAll.setVisible(suspendThreadSupported);
        this.mySuspendThread.setVisible(suspendThreadSupported);
        this.myMakeDefaultButton.setVisible(suspendThreadSupported);
    }

    @Override
    public boolean lightVariant(boolean showAllOptions) {
        this.myContentPane.setBorder(null);
        return false;
    }

    @Override
    void loadProperties() {
        SuspendPolicy suspendPolicy = this.myBreakpoint.getSuspendPolicy();
        boolean selected = suspendPolicy != SuspendPolicy.NONE;
        boolean suspendThreadSupported = this.myBreakpoint.getType().isSuspendThreadSupported();
        this.changeVisibleState(suspendThreadSupported);
        if (suspendThreadSupported) {
            this.mySuspendPolicyGroup.setSelected(suspendPolicy == SuspendPolicy.THREAD ? this.mySuspendThread.getModel() : this.mySuspendAll.getModel(), true);
            this.changeEnableState(selected);
        }
        this.mySuspendCheckBox.setSelected(selected);
        if (!selected && this.myDelegate != null) {
            this.myDelegate.showMoreOptionsIfNeeded();
        }
    }

    private SuspendPolicy getSelectedSuspendPolicy() {
        if (!this.mySuspendCheckBox.isSelected()) {
            return SuspendPolicy.NONE;
        }
        if (this.myBreakpoint.getType().isSuspendThreadSupported()) {
            return this.mySuspendAll.isSelected() ? SuspendPolicy.ALL : SuspendPolicy.THREAD;
        }
        return SuspendPolicy.ALL;
    }

    @Override
    void saveProperties() {
        this.myBreakpoint.setSuspendPolicy(this.getSelectedSuspendPolicy());
    }

    public Delegate getDelegate() {
        return this.myDelegate;
    }

    public void setDelegate(Delegate delegate) {
        this.myDelegate = delegate;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/XDebuggerBundle").getString("suspend.policy.panel.title"), 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySuspendAll = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("suspend.policy.panel.all"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySuspendThread = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("suspend.policy.panel.thread"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySuspendCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("suspend.policy.panel.suspend"));
        jCheckBox.setSelected(true);
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMakeDefaultButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("suspend.policy.panel.makeDefault"));
        jPanel.add((Component)jButton, new GridConstraints(0, 4, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface Delegate {
        public void showMoreOptionsIfNeeded();
    }
}

