/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.validate;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.actions.validate.StdErrorReporter;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import org.jetbrains.annotations.NotNull;

public class ValidateXmlAction
extends AnAction {
    private static final Key<String> runningValidationKey = Key.create((String)"xml.running.validation.indicator");

    private ValidateXmlActionHandler getHandler(final @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/actions/validate/ValidateXmlAction", "getHandler"));
        }
        ValidateXmlActionHandler handler = new ValidateXmlActionHandler(true);
        handler.setErrorReporter(new StdErrorReporter(handler, file.getProject(), new Runnable(){

            @Override
            public void run() {
                ValidateXmlAction.this.doRunAction(file);
            }
        }));
        return handler;
    }

    public void actionPerformed(AnActionEvent e) {
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        if (psiFile != null) {
            this.doRunAction(psiFile);
        }
    }

    private void doRunAction(final @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/xml/actions/validate/ValidateXmlAction", "doRunAction"));
        }
        CommandProcessor.getInstance().executeCommand(psiFile.getProject(), new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            psiFile.putUserData(runningValidationKey, (Object)"");
                            PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitAllDocuments();
                            ValidateXmlAction.this.getHandler(psiFile).doValidate((XmlFile)psiFile);
                        }
                        finally {
                            psiFile.putUserData(runningValidationKey, null);
                        }
                    }
                };
                ApplicationManager.getApplication().runWriteAction(action);
            }
        }, this.getCommandName(), null);
    }

    private String getCommandName() {
        String text = this.getTemplatePresentation().getText();
        return text != null ? text : "";
    }

    public void update(AnActionEvent event) {
        super.update(event);
        Presentation presentation = event.getPresentation();
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_FILE.getData(event.getDataContext());
        boolean flag = psiElement instanceof XmlFile;
        presentation.setVisible(flag);
        boolean value = psiElement instanceof XmlFile;
        if (value) {
            PsiFile containingFile = psiElement.getContainingFile();
            value = containingFile != null && (containingFile.getFileType() == StdFileTypes.XML || containingFile.getFileType() == StdFileTypes.XHTML) ? containingFile.getUserData(runningValidationKey) == null : false;
        }
        presentation.setEnabled(value);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(value);
        }
    }
}

