/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.cloneable.CallToSuperCloneVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import org.jetbrains.annotations.NotNull;

public class CloneCallsSuperCloneInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("CloneDoesntCallSuperClone" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneCallsSuperCloneInspection", "getID"));
        }
        return "CloneDoesntCallSuperClone";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("clone.doesnt.call.super.clone.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneCallsSuperCloneInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("clone.doesnt.call.super.clone.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneCallsSuperCloneInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NoExplicitCloneCallsVisitor();
    }

    private static class NoExplicitCloneCallsVisitor
    extends BaseInspectionVisitor {
        private NoExplicitCloneCallsVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/cloneable/CloneCallsSuperCloneInspection$NoExplicitCloneCallsVisitor", "visitMethod"));
            }
            if (!CloneUtils.isClone(method)) {
                return;
            }
            if (method.hasModifierProperty("abstract") || method.hasModifierProperty("native")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            if (CloneUtils.onlyThrowsCloneNotSupportedException(method) && (method.hasModifierProperty("final") || containingClass.hasModifierProperty("final"))) {
                return;
            }
            CallToSuperCloneVisitor visitor = new CallToSuperCloneVisitor();
            method.accept((PsiElementVisitor)visitor);
            if (visitor.isCallToSuperCloneFound()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

