/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nullable;

public class BoolUtils {
    private BoolUtils() {
    }

    public static boolean isNegated(PsiExpression exp) {
        PsiPrefixExpression prefixAncestor;
        IElementType tokenType;
        PsiExpression ancestor = exp;
        PsiElement parent = ancestor.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)parent;
            parent = ancestor.getParent();
        }
        return parent instanceof PsiPrefixExpression && (tokenType = (prefixAncestor = (PsiPrefixExpression)parent).getOperationTokenType()).equals(JavaTokenType.EXCL);
    }

    @Nullable
    public static PsiExpression findNegation(PsiExpression expression) {
        PsiPrefixExpression prefixAncestor;
        PsiExpression ancestor = expression;
        PsiElement parent = ancestor.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)parent;
            parent = ancestor.getParent();
        }
        if (parent instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals((prefixAncestor = (PsiPrefixExpression)parent).getOperationTokenType())) {
            return prefixAncestor;
        }
        return null;
    }

    public static boolean isNegation(PsiExpression exp) {
        if (!(exp instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExp = (PsiPrefixExpression)exp;
        IElementType tokenType = prefixExp.getOperationTokenType();
        return tokenType.equals(JavaTokenType.EXCL);
    }

    @Nullable
    public static PsiExpression getNegated(PsiExpression expression) {
        if (!(expression instanceof PsiPrefixExpression)) {
            return null;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (!JavaTokenType.EXCL.equals(tokenType)) {
            return null;
        }
        PsiExpression operand = prefixExpression.getOperand();
        return ParenthesesUtils.stripParentheses(operand);
    }

    public static boolean isBooleanLiteral(PsiExpression expression) {
        if (!(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
        String text = literalExpression.getText();
        return "true".equals(text) || "false".equals(text);
    }

    public static String getNegatedExpressionText(@Nullable PsiExpression condition) {
        if (condition == null) {
            return "";
        }
        if (condition instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition;
            PsiExpression expression = parenthesizedExpression.getExpression();
            return '(' + BoolUtils.getNegatedExpressionText(expression) + ')';
        }
        if (BoolUtils.isNegation(condition)) {
            PsiExpression negated = BoolUtils.getNegated(condition);
            if (negated == null) {
                return "";
            }
            return negated.getText();
        }
        if (ComparisonUtils.isComparison(condition)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            String negatedComparison = ComparisonUtils.getNegatedComparison(binaryExpression.getOperationTokenType());
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return lhs.getText() + negatedComparison;
            }
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        if (ParenthesesUtils.getPrecedence(condition) > 3) {
            return "!(" + condition.getText() + ')';
        }
        return '!' + condition.getText();
    }
}

