/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.BaseProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AsyncGenericProgramRunner<Settings extends RunnerSettings>
extends BaseProgramRunner<Settings> {
    @Override
    protected final void execute(final @NotNull ExecutionEnvironment environment, final @Nullable ProgramRunner.Callback callback, final @NotNull RunProfileState state) throws ExecutionException {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/AsyncGenericProgramRunner", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/runners/AsyncGenericProgramRunner", "execute"));
        }
        this.prepare(environment, state).doWhenDone(new Consumer<RunProfileStarter>(){

            public void consume(final @Nullable RunProfileStarter result) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!environment.getProject().isDisposed()) {
                            AsyncGenericProgramRunner.startRunProfile(environment, state, callback, result);
                        }
                    }
                });
            }
        });
    }

    @NotNull
    protected AsyncResult<RunProfileStarter> prepare(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) throws ExecutionException {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/AsyncGenericProgramRunner", "prepare"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/runners/AsyncGenericProgramRunner", "prepare"));
        }
        AsyncResult<RunProfileStarter> asyncResult = this.prepare(environment.getProject(), environment, state);
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/AsyncGenericProgramRunner", "prepare"));
        }
        return asyncResult;
    }

    @Deprecated
    protected AsyncResult<RunProfileStarter> prepare(@NotNull Project project, @NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/runners/AsyncGenericProgramRunner", "prepare"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/AsyncGenericProgramRunner", "prepare"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/runners/AsyncGenericProgramRunner", "prepare"));
        }
        throw new UnsupportedOperationException();
    }

    private static void startRunProfile(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, final @Nullable ProgramRunner.Callback callback, final @Nullable RunProfileStarter starter) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/AsyncGenericProgramRunner", "startRunProfile"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/runners/AsyncGenericProgramRunner", "startRunProfile"));
        }
        ExecutionManager.getInstance(environment.getProject()).startRunProfile(new RunProfileStarter(){

            @Override
            public RunContentDescriptor execute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/runners/AsyncGenericProgramRunner$2", "execute"));
                }
                if (environment == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/AsyncGenericProgramRunner$2", "execute"));
                }
                return BaseProgramRunner.postProcess(environment, starter == null ? null : starter.execute(state, environment), callback);
            }
        }, state, environment);
    }
}

