/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public abstract class CheckboxAction
extends ToggleAction
implements CustomComponentAction {
    protected CheckboxAction() {
    }

    protected CheckboxAction(String text) {
        super(text);
    }

    protected CheckboxAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @Override
    public JComponent createCustomComponent(Presentation presentation) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setOpaque(false);
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                ActionToolbar actionToolbar = (ActionToolbar)UIUtil.getParentOfType(ActionToolbar.class, (Component)checkBox);
                DataContext dataContext = actionToolbar != null ? actionToolbar.getToolbarDataContext() : DataManager.getInstance().getDataContext(checkBox);
                CheckboxAction.this.actionPerformed(new AnActionEvent(null, dataContext, "unknown", CheckboxAction.this.getTemplatePresentation(), ActionManager.getInstance(), 0));
            }
        });
        return checkBox;
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        Object property = presentation.getClientProperty("customComponent");
        if (property instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)property;
            checkBox.setText(presentation.getText());
            checkBox.setToolTipText(presentation.getDescription());
            checkBox.setMnemonic(presentation.getMnemonic());
            checkBox.setDisplayedMnemonicIndex(presentation.getDisplayedMnemonicIndex());
            checkBox.setSelected(Boolean.TRUE.equals(presentation.getClientProperty("selected")));
            checkBox.setEnabled(presentation.isEnabled());
            checkBox.setVisible(presentation.isVisible());
        }
    }
}

