/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreeComponentsSplitter
extends JPanel
implements Disposable {
    private int myDividerWidth;
    private boolean myVerticalSplit;
    private boolean myHonorMinimumSize = false;
    private final Divider myFirstDivider;
    private final Divider myLastDivider;
    @Nullable
    private JComponent myFirstComponent;
    @Nullable
    private JComponent myInnerComponent;
    @Nullable
    private JComponent myLastComponent;
    private int myFirstSize = 10;
    private int myLastSize = 10;
    private boolean myShowDividerControls;
    private int myDividerZone;

    public ThreeComponentsSplitter() {
        this(false);
    }

    public ThreeComponentsSplitter(boolean vertical) {
        this.myVerticalSplit = vertical;
        this.myShowDividerControls = false;
        this.myFirstDivider = new Divider(true);
        Disposer.register((Disposable)this, (Disposable)this.myFirstDivider);
        this.myLastDivider = new Divider(false);
        Disposer.register((Disposable)this, (Disposable)this.myLastDivider);
        this.myDividerWidth = 7;
        this.setOpaque(false);
        this.add(this.myFirstDivider);
        this.add(this.myLastDivider);
    }

    public void setShowDividerControls(boolean showDividerControls) {
        this.myShowDividerControls = showDividerControls;
        this.setOrientation(this.myVerticalSplit);
    }

    public void setDividerMouseZoneSize(int size) {
        this.myDividerZone = size;
    }

    public boolean isHonorMinimumSize() {
        return this.myHonorMinimumSize;
    }

    public void setHonorComponentsMinimumSize(boolean honorMinimumSize) {
        this.myHonorMinimumSize = honorMinimumSize;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && (this.firstVisible() || this.innerVisible() || this.lastVisible());
    }

    private boolean lastVisible() {
        return !Splitter.isNull((Component)this.myLastComponent) && this.myLastComponent.isVisible();
    }

    private boolean innerVisible() {
        return !Splitter.isNull((Component)this.myInnerComponent) && this.myInnerComponent.isVisible();
    }

    private boolean firstVisible() {
        return !Splitter.isNull((Component)this.myFirstComponent) && this.myFirstComponent.isVisible();
    }

    private int visibleDividersCount() {
        int count = 0;
        if (this.firstDividerVisible()) {
            ++count;
        }
        if (this.lastDividerVisible()) {
            ++count;
        }
        return count;
    }

    private boolean firstDividerVisible() {
        return this.firstVisible() && this.innerVisible() || this.firstVisible() && this.lastVisible() && !this.innerVisible();
    }

    private boolean lastDividerVisible() {
        return this.innerVisible() && this.lastVisible();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isHonorMinimumSize()) {
            Dimension innerSize;
            int dividerWidth = this.getDividerWidth();
            Dimension firstSize = this.myFirstComponent != null ? this.myFirstComponent.getMinimumSize() : new Dimension(0, 0);
            Dimension lastSize = this.myLastComponent != null ? this.myLastComponent.getMinimumSize() : new Dimension(0, 0);
            Dimension dimension = innerSize = this.myInnerComponent != null ? this.myInnerComponent.getMinimumSize() : new Dimension(0, 0);
            if (this.getOrientation()) {
                int width = Math.max(firstSize.width, Math.max(lastSize.width, innerSize.width));
                int height = this.visibleDividersCount() * dividerWidth;
                height += firstSize.height;
                height += lastSize.height;
                return new Dimension(width, height += innerSize.height);
            }
            int heigth = Math.max(firstSize.height, Math.max(lastSize.height, innerSize.height));
            int width = this.visibleDividersCount() * dividerWidth;
            width += firstSize.width;
            width += lastSize.width;
            return new Dimension(width += innerSize.width, heigth);
        }
        return super.getMinimumSize();
    }

    @Override
    public void doLayout() {
        int space;
        int innerComponentSize;
        int lastComponentSize;
        int firstCompontSize;
        int width = this.getWidth();
        int height = this.getHeight();
        Rectangle firstRect = new Rectangle();
        Rectangle firstDividerRect = new Rectangle();
        Rectangle lastDividerRect = new Rectangle();
        Rectangle lastRect = new Rectangle();
        Rectangle innerRect = new Rectangle();
        int componentSize = this.getOrientation() ? height : width;
        int dividerWidth = this.getDividerWidth();
        int dividersCount = this.visibleDividersCount();
        if (componentSize <= dividersCount * dividerWidth) {
            firstCompontSize = 0;
            lastComponentSize = 0;
            innerComponentSize = 0;
            dividerWidth = componentSize;
        } else {
            firstCompontSize = this.getFirstSize();
            int sizeLack = firstCompontSize + (lastComponentSize = this.getLastSize()) - (componentSize - dividersCount * dividerWidth);
            if (sizeLack > 0) {
                firstCompontSize -= sizeLack;
                innerComponentSize = 0;
            } else {
                innerComponentSize = componentSize - dividersCount * dividerWidth - this.getFirstSize() - this.getLastSize();
            }
            if (!this.innerVisible()) {
                lastComponentSize += innerComponentSize;
                innerComponentSize = 0;
                if (!this.lastVisible()) {
                    firstCompontSize = componentSize;
                }
            }
        }
        if (this.getOrientation()) {
            space = firstCompontSize;
            firstRect.setBounds(0, 0, width, firstCompontSize);
            if (this.firstDividerVisible()) {
                firstDividerRect.setBounds(0, space, width, dividerWidth);
                space += dividerWidth;
            }
            innerRect.setBounds(0, space, width, innerComponentSize);
            space += innerComponentSize;
            if (this.lastDividerVisible()) {
                lastDividerRect.setBounds(0, space, width, dividerWidth);
                space += dividerWidth;
            }
            lastRect.setBounds(0, space, width, lastComponentSize);
        } else {
            space = firstCompontSize;
            firstRect.setBounds(0, 0, firstCompontSize, height);
            if (this.firstDividerVisible()) {
                firstDividerRect.setBounds(space, 0, dividerWidth, height);
                space += dividerWidth;
            }
            innerRect.setBounds(space, 0, innerComponentSize, height);
            space += innerComponentSize;
            if (this.lastDividerVisible()) {
                lastDividerRect.setBounds(space, 0, dividerWidth, height);
                space += dividerWidth;
            }
            lastRect.setBounds(space, 0, lastComponentSize, height);
        }
        this.myFirstDivider.setVisible(this.firstDividerVisible());
        this.myFirstDivider.setBounds(firstDividerRect);
        this.myFirstDivider.doLayout();
        this.myLastDivider.setVisible(this.lastDividerVisible());
        this.myLastDivider.setBounds(lastDividerRect);
        this.myLastDivider.doLayout();
        ThreeComponentsSplitter.validateIfNeeded(this.myFirstComponent, firstRect);
        ThreeComponentsSplitter.validateIfNeeded(this.myInnerComponent, innerRect);
        ThreeComponentsSplitter.validateIfNeeded(this.myLastComponent, lastRect);
    }

    private static void validateIfNeeded(JComponent c, Rectangle rect) {
        if (!Splitter.isNull((Component)c)) {
            if (!c.getBounds().equals(rect)) {
                c.setBounds(rect);
                c.revalidate();
            }
        } else {
            Splitter.hideNull((Component)c);
        }
    }

    public int getDividerWidth() {
        return this.myDividerWidth;
    }

    public void setDividerWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Wrong divider width: " + width);
        }
        if (this.myDividerWidth != width) {
            this.myDividerWidth = width;
            this.doLayout();
            this.repaint();
        }
    }

    public boolean getOrientation() {
        return this.myVerticalSplit;
    }

    public void setOrientation(boolean verticalSplit) {
        this.myVerticalSplit = verticalSplit;
        this.myFirstDivider.setOrientation(verticalSplit);
        this.myLastDivider.setOrientation(verticalSplit);
        this.doLayout();
        this.repaint();
    }

    @Nullable
    public JComponent getFirstComponent() {
        return this.myFirstComponent;
    }

    public void setFirstComponent(@Nullable JComponent component) {
        if (this.myFirstComponent != component) {
            if (this.myFirstComponent != null) {
                this.remove(this.myFirstComponent);
            }
            this.myFirstComponent = component;
            if (this.myFirstComponent != null) {
                this.add(this.myFirstComponent);
                this.myFirstComponent.invalidate();
            }
        }
    }

    @Nullable
    public JComponent getLastComponent() {
        return this.myLastComponent;
    }

    public void setLastComponent(@Nullable JComponent component) {
        if (this.myLastComponent != component) {
            if (this.myLastComponent != null) {
                this.remove(this.myLastComponent);
            }
            this.myLastComponent = component;
            if (this.myLastComponent != null) {
                this.add(this.myLastComponent);
                this.myLastComponent.invalidate();
            }
        }
    }

    @Nullable
    public JComponent getInnerComponent() {
        return this.myInnerComponent;
    }

    public void setInnerComponent(@Nullable JComponent component) {
        if (this.myInnerComponent != component) {
            if (this.myInnerComponent != null) {
                this.remove(this.myInnerComponent);
            }
            this.myInnerComponent = component;
            if (this.myInnerComponent != null) {
                this.add(this.myInnerComponent);
                this.myInnerComponent.invalidate();
            }
        }
    }

    public void setFirstSize(int size) {
        this.myFirstSize = size;
        this.doLayout();
        this.repaint();
    }

    public void setLastSize(int size) {
        this.myLastSize = size;
        this.doLayout();
        this.repaint();
    }

    public int getFirstSize() {
        return this.firstVisible() ? this.myFirstSize : 0;
    }

    public int getLastSize() {
        return this.lastVisible() ? this.myLastSize : 0;
    }

    public void dispose() {
        this.myLastComponent = null;
        this.myFirstComponent = null;
        this.myInnerComponent = null;
        this.removeAll();
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    private Cursor getResizeCursor() {
        return this.getOrientation() ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11);
    }

    private class Divider
    extends JPanel
    implements Disposable {
        protected boolean myDragging;
        protected Point myPoint;
        private final boolean myIsFirst;
        private IdeGlassPane myGlassPane;
        private final MouseAdapter myListener;
        private boolean myWasPressedOnMe;

        private MouseEvent getTargetEvent(MouseEvent e) {
            return SwingUtilities.convertMouseEvent(e.getComponent(), e, this);
        }

        public Divider(boolean isFirst) {
            super(new GridBagLayout());
            this.myListener = new MyMouseAdapter();
            this.setFocusable(false);
            this.enableEvents(48L);
            this.myIsFirst = isFirst;
            this.setOrientation(ThreeComponentsSplitter.this.myVerticalSplit);
            new UiNotifyConnector.Once(this, new Activatable.Adapter(){

                @Override
                public void showNotify() {
                    Divider.this.init();
                }
            });
        }

        private boolean isInside(Point p) {
            if (!this.isVisible()) {
                return false;
            }
            if (ThreeComponentsSplitter.this.myVerticalSplit) {
                if (p.x >= 0 && p.x < this.getWidth()) {
                    if (this.getHeight() > 0) {
                        return p.y >= 0 && p.y < this.getHeight();
                    }
                    return p.y >= -ThreeComponentsSplitter.this.myDividerZone / 2 && p.y <= ThreeComponentsSplitter.this.myDividerZone / 2;
                }
            } else if (p.y >= 0 && p.y < this.getHeight()) {
                if (this.getWidth() > 0) {
                    return p.x >= 0 && p.x < this.getWidth();
                }
                return p.x >= -ThreeComponentsSplitter.this.myDividerZone / 2 && p.x <= ThreeComponentsSplitter.this.myDividerZone / 2;
            }
            return false;
        }

        private void init() {
            this.myGlassPane = IdeGlassPaneUtil.find(this);
            this.myGlassPane.addMouseMotionPreprocessor(this.myListener, this);
            this.myGlassPane.addMousePreprocessor(this.myListener, this);
        }

        public void dispose() {
        }

        private void setOrientation(boolean isVerticalSplit) {
            this.removeAll();
            if (!ThreeComponentsSplitter.this.myShowDividerControls) {
                return;
            }
            int xMask = isVerticalSplit ? 1 : 0;
            int yMask = isVerticalSplit ? 0 : 1;
            Icon glueIcon = isVerticalSplit ? AllIcons.General.SplitGlueV : AllIcons.General.SplitCenterH;
            int glueFill = isVerticalSplit ? 3 : 2;
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, isVerticalSplit ? 13 : 11, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitDownlabel = new JLabel(isVerticalSplit ? AllIcons.General.SplitDown : AllIcons.General.SplitRight);
            splitDownlabel.setCursor(Cursor.getPredefinedCursor(12));
            splitDownlabel.setToolTipText(isVerticalSplit ? UIBundle.message((String)"splitter.down.tooltip.text", (Object[])new Object[0]) : UIBundle.message((String)"splitter.right.tooltip.text", (Object[])new Object[0]));
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/ThreeComponentsSplitter$Divider$2", "onClick"));
                    }
                    if (ThreeComponentsSplitter.this.myInnerComponent != null) {
                        int income;
                        int n = income = ThreeComponentsSplitter.this.myVerticalSplit ? ThreeComponentsSplitter.this.myInnerComponent.getHeight() : ThreeComponentsSplitter.this.myInnerComponent.getWidth();
                        if (Divider.this.myIsFirst) {
                            ThreeComponentsSplitter.this.setFirstSize(ThreeComponentsSplitter.this.myFirstSize + income);
                        } else {
                            ThreeComponentsSplitter.this.setLastSize(ThreeComponentsSplitter.this.myLastSize + income);
                        }
                    }
                    return true;
                }
            }.installOn((Component)splitDownlabel);
            this.add((Component)splitDownlabel, new GridBagConstraints(isVerticalSplit ? 1 : 0, isVerticalSplit ? 0 : 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(2 * xMask, 2 * yMask, 1, 1, 0.0, 0.0, 10, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitCenterlabel = new JLabel(isVerticalSplit ? AllIcons.General.SplitCenterV : AllIcons.General.SplitCenterH);
            splitCenterlabel.setCursor(Cursor.getPredefinedCursor(12));
            splitCenterlabel.setToolTipText(UIBundle.message((String)"splitter.center.tooltip.text", (Object[])new Object[0]));
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/ThreeComponentsSplitter$Divider$3", "onClick"));
                    }
                    Divider.this.center();
                    return true;
                }
            }.installOn((Component)splitCenterlabel);
            this.add((Component)splitCenterlabel, new GridBagConstraints(3 * xMask, 3 * yMask, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(4 * xMask, 4 * yMask, 1, 1, 0.0, 0.0, 10, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitUpLabel = new JLabel(isVerticalSplit ? AllIcons.General.SplitUp : AllIcons.General.SplitLeft);
            splitUpLabel.setCursor(Cursor.getPredefinedCursor(12));
            splitUpLabel.setToolTipText(isVerticalSplit ? UIBundle.message((String)"splitter.up.tooltip.text", (Object[])new Object[0]) : UIBundle.message((String)"splitter.left.tooltip.text", (Object[])new Object[0]));
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/ThreeComponentsSplitter$Divider$4", "onClick"));
                    }
                    if (ThreeComponentsSplitter.this.myInnerComponent != null) {
                        int income;
                        int n = income = ThreeComponentsSplitter.this.myVerticalSplit ? ThreeComponentsSplitter.this.myInnerComponent.getHeight() : ThreeComponentsSplitter.this.myInnerComponent.getWidth();
                        if (Divider.this.myIsFirst) {
                            ThreeComponentsSplitter.this.setFirstSize(ThreeComponentsSplitter.this.myFirstSize + income);
                        } else {
                            ThreeComponentsSplitter.this.setLastSize(ThreeComponentsSplitter.this.myLastSize + income);
                        }
                    }
                    return true;
                }
            }.installOn((Component)splitUpLabel);
            this.add((Component)splitUpLabel, new GridBagConstraints(isVerticalSplit ? 5 : 0, isVerticalSplit ? 0 : 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(6 * xMask, 6 * yMask, 1, 1, 0.0, 0.0, isVerticalSplit ? 17 : 15, glueFill, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void center() {
            if (ThreeComponentsSplitter.this.myInnerComponent != null) {
                int total = ThreeComponentsSplitter.this.myFirstSize + (ThreeComponentsSplitter.this.myVerticalSplit ? ThreeComponentsSplitter.this.myInnerComponent.getHeight() : ThreeComponentsSplitter.this.myInnerComponent.getWidth());
                if (this.myIsFirst) {
                    ThreeComponentsSplitter.this.setFirstSize(total / 2);
                } else {
                    ThreeComponentsSplitter.this.setLastSize(total / 2);
                }
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
            if (!this.isShowing()) {
                return;
            }
            if (506 == e.getID() && this.myWasPressedOnMe) {
                this.myDragging = true;
                this.setCursor(ThreeComponentsSplitter.this.getResizeCursor());
                this.myGlassPane.setCursor(ThreeComponentsSplitter.this.getResizeCursor(), this.myListener);
                this.myPoint = SwingUtilities.convertPoint(this, e.getPoint(), ThreeComponentsSplitter.this);
                if (ThreeComponentsSplitter.this.getOrientation()) {
                    if (this.getHeight() > 0 || ThreeComponentsSplitter.this.myDividerZone > 0) {
                        if (this.myIsFirst) {
                            ThreeComponentsSplitter.this.setFirstSize(Math.max(this.getMinSize(ThreeComponentsSplitter.this.myFirstComponent), this.myPoint.y));
                        } else {
                            ThreeComponentsSplitter.this.setLastSize(Math.max(this.getMinSize(ThreeComponentsSplitter.this.myLastComponent), ThreeComponentsSplitter.this.getHeight() - this.myPoint.y - ThreeComponentsSplitter.this.getDividerWidth()));
                        }
                    }
                } else if (this.getWidth() > 0 || ThreeComponentsSplitter.this.myDividerZone > 0) {
                    if (this.myIsFirst) {
                        ThreeComponentsSplitter.this.setFirstSize(Math.max(this.getMinSize(ThreeComponentsSplitter.this.myFirstComponent), this.myPoint.x));
                    } else {
                        ThreeComponentsSplitter.this.setLastSize(Math.max(this.getMinSize(ThreeComponentsSplitter.this.myLastComponent), ThreeComponentsSplitter.this.getWidth() - this.myPoint.x - ThreeComponentsSplitter.this.getDividerWidth()));
                    }
                }
                ThreeComponentsSplitter.this.doLayout();
            } else if (503 == e.getID() && this.myGlassPane != null) {
                if (this.isInside(e.getPoint())) {
                    this.myGlassPane.setCursor(ThreeComponentsSplitter.this.getResizeCursor(), this.myListener);
                    e.consume();
                } else {
                    this.myGlassPane.setCursor(null, this.myListener);
                }
            }
            if (this.myWasPressedOnMe) {
                e.consume();
            }
        }

        private int getMinSize(JComponent component) {
            if (ThreeComponentsSplitter.this.isHonorMinimumSize() && component != null && ThreeComponentsSplitter.this.myFirstComponent != null && ThreeComponentsSplitter.this.myFirstComponent.isVisible() && ThreeComponentsSplitter.this.myLastComponent != null && ThreeComponentsSplitter.this.myLastComponent.isVisible()) {
                if (ThreeComponentsSplitter.this.getOrientation()) {
                    return component.getMinimumSize().height;
                }
                return component.getMinimumSize().width;
            }
            return 0;
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (!this.isShowing()) {
                return;
            }
            switch (e.getID()) {
                case 504: {
                    this.setCursor(ThreeComponentsSplitter.this.getResizeCursor());
                    break;
                }
                case 505: {
                    if (this.myDragging) break;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 501: {
                    if (this.isInside(e.getPoint())) {
                        this.myWasPressedOnMe = true;
                        this.myGlassPane.setCursor(ThreeComponentsSplitter.this.getResizeCursor(), this.myListener);
                        e.consume();
                        break;
                    }
                    this.myWasPressedOnMe = false;
                    break;
                }
                case 502: {
                    if (this.myWasPressedOnMe) {
                        e.consume();
                    }
                    if (this.isInside(e.getPoint())) {
                        this.myGlassPane.setCursor(ThreeComponentsSplitter.this.getResizeCursor(), this.myListener);
                    }
                    this.myWasPressedOnMe = false;
                    this.myDragging = false;
                    this.myPoint = null;
                    break;
                }
                case 500: {
                    if (e.getClickCount() != 2) break;
                    this.center();
                }
            }
        }

        private class MyMouseAdapter
        extends MouseAdapter
        implements Weighted {
            private MyMouseAdapter() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this._processMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this._processMouseEvent(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this._processMouseMotionEvent(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this._processMouseMotionEvent(e);
            }

            @Override
            public double getWeight() {
                return 1.0;
            }

            private void _processMouseMotionEvent(MouseEvent e) {
                MouseEvent event = Divider.this.getTargetEvent(e);
                if (event == null) {
                    Divider.this.myGlassPane.setCursor(null, Divider.this.myListener);
                    return;
                }
                Divider.this.processMouseMotionEvent(event);
                if (event.isConsumed()) {
                    e.consume();
                }
            }

            private void _processMouseEvent(MouseEvent e) {
                MouseEvent event = Divider.this.getTargetEvent(e);
                if (event == null) {
                    Divider.this.myGlassPane.setCursor(null, Divider.this.myListener);
                    return;
                }
                Divider.this.processMouseEvent(event);
                if (event.isConsumed()) {
                    e.consume();
                }
            }
        }
    }
}

