/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Disposer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AsyncValueLoader<T> {
    private final AtomicReference<AsyncResult<T>> ref = new AtomicReference();
    private volatile long modificationCount;
    private volatile long loadedModificationCount;
    private final Runnable doneHandler = new Runnable(){

        @Override
        public void run() {
            AsyncValueLoader.this.loadedModificationCount = AsyncValueLoader.this.modificationCount;
        }
    };

    @NotNull
    public final AsyncResult<T> get() {
        AsyncResult<T> asyncResult = this.get(true);
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncValueLoader", "get"));
        }
        return asyncResult;
    }

    public final void reset() {
        AsyncResult oldValue = this.ref.getAndSet(null);
        if (oldValue != null) {
            this.rejectAndDispose(oldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rejectAndDispose(@NotNull AsyncResult<T> asyncResult) {
        if (asyncResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncResult", "com/intellij/openapi/util/AsyncValueLoader", "rejectAndDispose"));
        }
        try {
            if (!asyncResult.isProcessed()) {
                asyncResult.setRejected();
            }
        }
        finally {
            T result = asyncResult.getResult();
            if (result != null) {
                this.disposeResult(result);
            }
        }
    }

    protected void disposeResult(@NotNull T result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/util/AsyncValueLoader", "disposeResult"));
        }
        if (result instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)result), (boolean)false);
        }
    }

    public final boolean has() {
        AsyncResult<T> result = this.ref.get();
        return result != null && result.isDone() && result.getResult() != null;
    }

    @NotNull
    public final AsyncResult<T> get(boolean checkFreshness) {
        AsyncResult<T> asyncResult = this.ref.get();
        if (asyncResult == null) {
            asyncResult = new AsyncResult();
            if (!this.ref.compareAndSet(null, asyncResult)) {
                AsyncResult<T> asyncResult2 = this.ref.get();
                if (asyncResult2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncValueLoader", "get"));
                }
                return asyncResult2;
            }
        } else {
            if (!asyncResult.isProcessed()) {
                AsyncResult<T> asyncResult3 = asyncResult;
                if (asyncResult3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncValueLoader", "get"));
                }
                return asyncResult3;
            }
            if (asyncResult.isDone()) {
                if (!checkFreshness || this.isUpToDate(asyncResult.getResult())) {
                    AsyncResult<T> asyncResult4 = asyncResult;
                    if (asyncResult4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncValueLoader", "get"));
                    }
                    return asyncResult4;
                }
                if (!this.ref.compareAndSet(asyncResult, asyncResult = new AsyncResult())) {
                    AsyncResult<T> valueFromAnotherThread = this.ref.get();
                    while (valueFromAnotherThread == null) {
                        if (this.ref.compareAndSet(null, asyncResult)) {
                            this.callLoad(asyncResult);
                            AsyncResult<T> asyncResult5 = asyncResult;
                            if (asyncResult5 == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncValueLoader", "get"));
                            }
                            return asyncResult5;
                        }
                        valueFromAnotherThread = this.ref.get();
                    }
                    AsyncResult<T> asyncResult6 = valueFromAnotherThread;
                    if (asyncResult6 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncValueLoader", "get"));
                    }
                    return asyncResult6;
                }
            }
        }
        this.callLoad(asyncResult);
        AsyncResult<T> asyncResult7 = asyncResult;
        if (asyncResult7 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncValueLoader", "get"));
        }
        return asyncResult7;
    }

    protected boolean isCancelOnReject() {
        return false;
    }

    private void callLoad(final @NotNull AsyncResult<T> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/util/AsyncValueLoader", "callLoad"));
        }
        if (this.isCancelOnReject()) {
            result.doWhenRejected(new Runnable(){

                @Override
                public void run() {
                    AsyncValueLoader.this.ref.compareAndSet(result, null);
                }
            });
        }
        result.doWhenDone(this.doneHandler);
        try {
            this.load(result);
        }
        catch (Throwable e) {
            this.ref.compareAndSet(result, null);
            this.rejectAndDispose(result);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    protected abstract void load(@NotNull AsyncResult<T> var1) throws IOException;

    protected boolean isUpToDate(@Nullable T result) {
        return this.loadedModificationCount == this.modificationCount;
    }

    public final void set(@NotNull T result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/util/AsyncValueLoader", "set"));
        }
        AsyncResult<T> oldValue = this.ref.getAndSet(AsyncResult.done(result));
        if (oldValue != null) {
            this.rejectAndDispose(oldValue);
        }
    }

    public final void markDirty() {
        ++this.modificationCount;
    }
}

