/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.ResourceItem;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.FontUtil;
import com.android.tools.idea.editors.strings.MultilineStringEditorDialog;
import com.android.tools.idea.editors.strings.NewStringKeyDialog;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.StringResourceParser;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.editors.strings.table.ColumnUtil;
import com.android.tools.idea.editors.strings.table.ConstantColumn;
import com.android.tools.idea.editors.strings.table.HeaderCellSelectionListener;
import com.android.tools.idea.editors.strings.table.ResizeListener;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringsCellEditor;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.Locale;
import com.google.common.collect.ImmutableSet;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class StringResourceViewPanel {
    private final AndroidFacet myFacet;
    private JPanel myContainer;
    private JBLoadingPanel myLoadingPanel;
    private JBTable myTable;
    private JTextField myKey;
    private TextFieldWithBrowseButton myDefaultValueWithBrowseBtn;
    private final JTextField myDefaultValue;
    private TextFieldWithBrowseButton myTranslationWithBrowseBtn;
    private final JTextField myTranslation;
    private JPanel myToolbarPanel;
    private LocalResourceRepository myResourceRepository;
    private long myModificationCount;
    private StringResourceData myData;
    private final StringResourceTableModel myTableModel;

    public StringResourceViewPanel(AndroidFacet facet, Disposable parentDisposable) {
        this.myFacet = facet;
        this.$$$setupUI$$$();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), parentDisposable, 200);
        this.myLoadingPanel.add((Component)this.myContainer);
        ActionToolbar toolbar = this.createToolbar();
        this.myToolbarPanel.add((Component)toolbar.getComponent(), "Center");
        this.myToolbarPanel.setBorder(IdeBorderFactory.createBorder((int)8));
        this.myDefaultValueWithBrowseBtn.setButtonIcon(AllIcons.Actions.ShowViewer);
        this.myTranslationWithBrowseBtn.setButtonIcon(AllIcons.Actions.ShowViewer);
        ShowMultilineActionListener showMultilineActionListener = new ShowMultilineActionListener();
        this.myDefaultValueWithBrowseBtn.addActionListener((ActionListener)showMultilineActionListener);
        this.myTranslationWithBrowseBtn.addActionListener((ActionListener)showMultilineActionListener);
        this.myDefaultValue = this.myDefaultValueWithBrowseBtn.getTextField();
        this.myTranslation = this.myTranslationWithBrowseBtn.getTextField();
        this.initEditPanel();
        this.initTable();
        this.myTableModel = new StringResourceTableModel(null);
        this.myTable.setModel((TableModel)this.myTableModel);
        this.myLoadingPanel.setLoadingText("Loading string resource data");
        this.myLoadingPanel.startLoading();
        new ParseTask("Loading string resource data").queue();
    }

    public void reloadData() {
        this.myLoadingPanel.setLoadingText("Updating string resource data");
        this.myLoadingPanel.startLoading();
        new ParseTask("Updating string resource data").queue();
    }

    private ActionToolbar createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        final ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        AnAction addKeyAction = new AnAction("Add Key", "", AllIcons.ToolbarDecorator.Add){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(StringResourceViewPanel.this.myData != null);
            }

            public void actionPerformed(AnActionEvent e) {
                NewStringKeyDialog dialog = new NewStringKeyDialog(StringResourceViewPanel.this.myFacet, (Set<String>)ImmutableSet.copyOf(StringResourceViewPanel.this.myData.getKeys()));
                if (dialog.showAndGet()) {
                    StringsWriteUtils.createItem(StringResourceViewPanel.this.myFacet, dialog.getResFolder(), null, dialog.getKey(), dialog.getDefaultValue(), true);
                    StringResourceViewPanel.this.reloadData();
                }
            }
        };
        group.add(addKeyAction);
        AnAction addLocaleAction = new AnAction("Add Locale", "", AndroidIcons.Globe){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(StringResourceViewPanel.this.myData != null);
            }

            public void actionPerformed(AnActionEvent e) {
                List<Locale> currentLocales = StringResourceViewPanel.this.myData.getLocales();
                List<Locale> missingLocales = LocaleMenuAction.getAllLocales();
                missingLocales.removeAll(currentLocales);
                Collections.sort(missingLocales, Locale.LANGUAGE_NAME_COMPARATOR);
                final JBList list = new JBList(missingLocales);
                list.setFixedCellHeight(20);
                list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<Locale>(){

                    protected void customizeCellRenderer(JList list, Locale value, int index, boolean selected, boolean hasFocus) {
                        this.append(LocaleMenuAction.getLocaleLabel(value, false));
                        this.setIcon(value.getFlagImage());
                    }
                });
                new ListSpeedSearch((JList)list){

                    protected String getElementText(Object element) {
                        if (element instanceof Locale) {
                            return LocaleMenuAction.getLocaleLabel((Locale)element, false);
                        }
                        return super.getElementText(element);
                    }
                };
                JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setItemChoosenCallback(new Runnable(){

                    @Override
                    public void run() {
                        String key;
                        Map<String, ResourceItem> defaultValues = StringResourceViewPanel.this.myData.getDefaultValues();
                        ResourceItem defaultValue = defaultValues.get(key = "app_name");
                        if (defaultValue == null) {
                            Map.Entry<String, ResourceItem> firstEntry = defaultValues.entrySet().iterator().next();
                            key = firstEntry.getKey();
                            defaultValue = firstEntry.getValue();
                        }
                        Locale l = (Locale)list.getSelectedValue();
                        StringsWriteUtils.createItem(StringResourceViewPanel.this.myFacet, StringResourceViewPanel.this.myFacet.getPrimaryResourceDir(), l, key, StringResourceData.resourceToString(defaultValue), true);
                        StringResourceViewPanel.this.reloadData();
                    }
                }).createPopup().showUnderneathOf((Component)toolbar.getComponent());
            }
        };
        group.addAction(addLocaleAction);
        return toolbar;
    }

    public boolean dataIsCurrent() {
        return this.myResourceRepository != null && this.myModificationCount >= this.myResourceRepository.getModificationCount();
    }

    private void initEditPanel() {
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JTextComponent component = (JTextComponent)e.getComponent();
                if (component.isEditable()) {
                    StringResourceViewPanel.this.onTextFieldUpdate(component);
                }
            }
        };
        this.myKey.addKeyListener(keyListener);
        this.myDefaultValue.addKeyListener(keyListener);
        this.myTranslation.addKeyListener(keyListener);
    }

    private void onTextFieldUpdate(JTextComponent component) {
        int column;
        StringResourceTableModel model = (StringResourceTableModel)this.myTable.getModel();
        if (this.myTable.getSelectedColumnCount() != 1 || this.myTable.getSelectedRowCount() != 1) {
            return;
        }
        int row = this.myTable.getSelectedRow();
        if (component == this.myKey) {
            column = ConstantColumn.KEY.ordinal();
        } else if (component == this.myDefaultValue) {
            column = ConstantColumn.DEFAULT_VALUE.ordinal();
        } else {
            assert (component == this.myTranslation);
            column = this.myTable.getSelectedColumn();
        }
        String value = component.getText();
        model.setValueAt(value, row, column);
    }

    private void initTable() {
        this.myTable.setCellSelectionEnabled(true);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        HeaderCellSelectionListener headerListener = new HeaderCellSelectionListener((JTable)this.myTable);
        this.myTable.getTableHeader().addMouseListener(headerListener);
        this.myTable.getTableHeader().addMouseMotionListener(headerListener);
        CellSelectionListener selectionListener = new CellSelectionListener();
        this.myTable.getSelectionModel().addListSelectionListener(selectionListener);
        this.myTable.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener);
        this.myTable.setDefaultEditor(String.class, (TableCellEditor)((Object)new StringsCellEditor()));
        this.myTable.getParent().addComponentListener(new ResizeListener((JTable)this.myTable));
        new TableSpeedSearch((JTable)this.myTable);
    }

    @NotNull
    public JPanel getComponent() {
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        if (jBLoadingPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceViewPanel", "getComponent"));
        }
        return jBLoadingPanel;
    }

    @NotNull
    public JBTable getPreferredFocusedComponent() {
        JBTable jBTable = this.myTable;
        if (jBTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceViewPanel", "getPreferredFocusedComponent"));
        }
        return jBTable;
    }

    private void createUIComponents() {
        this.myTable = new JBTable();
    }

    public JTable getTable() {
        return this.myTable;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JTextField jTextField;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContainer = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBTable jBTable = this.myTable;
        jBScrollPane.setViewportView((Component)jBTable);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Key:");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myKey = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Default Value:");
        jPanel3.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Translation:");
        jPanel3.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myDefaultValueWithBrowseBtn = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myTranslationWithBrowseBtn = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myToolbarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContainer;
    }

    private class ShowMultilineActionListener
    implements ActionListener {
        private ShowMultilineActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StringResourceViewPanel.this.myTable.getSelectedRowCount() != 1 || StringResourceViewPanel.this.myTable.getSelectedColumnCount() != 1) {
                return;
            }
            int row = StringResourceViewPanel.this.myTable.getSelectedRow();
            int column = StringResourceViewPanel.this.myTable.getSelectedColumn();
            StringResourceTableModel model = (StringResourceTableModel)StringResourceViewPanel.this.myTable.getModel();
            String key = model.keyOfRow(row);
            String value = (String)model.getValueAt(row, ConstantColumn.DEFAULT_VALUE.ordinal());
            Locale locale = model.localeOfColumn(column);
            String translation = locale == null ? null : (String)model.getValueAt(row, column);
            MultilineStringEditorDialog d = new MultilineStringEditorDialog(StringResourceViewPanel.this.myFacet, key, value, locale, translation);
            if (d.showAndGet()) {
                if (!StringUtil.equals((CharSequence)value, (CharSequence)d.getDefaultValue())) {
                    model.setValueAt(d.getDefaultValue(), row, ConstantColumn.DEFAULT_VALUE.ordinal());
                }
                if (locale != null && !StringUtil.equals((CharSequence)translation, (CharSequence)d.getTranslation())) {
                    model.setValueAt(d.getTranslation(), row, column);
                }
            }
        }
    }

    private class CellSelectionListener
    implements ListSelectionListener {
        private CellSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (StringResourceViewPanel.this.myTable.getSelectedColumnCount() != 1 || StringResourceViewPanel.this.myTable.getSelectedRowCount() != 1) {
                this.setTextAndEditable(StringResourceViewPanel.this.myKey, "", false);
                this.setTextAndEditable(StringResourceViewPanel.this.myDefaultValue, "", false);
                this.setTextAndEditable(StringResourceViewPanel.this.myTranslation, "", false);
                StringResourceViewPanel.this.myDefaultValueWithBrowseBtn.getButton().setEnabled(false);
                StringResourceViewPanel.this.myTranslationWithBrowseBtn.getButton().setEnabled(false);
                return;
            }
            StringResourceTableModel model = (StringResourceTableModel)StringResourceViewPanel.this.myTable.getModel();
            int row = StringResourceViewPanel.this.myTable.getSelectedRow();
            int column = StringResourceViewPanel.this.myTable.getSelectedColumn();
            Locale locale = model.localeOfColumn(column);
            String key = model.keyOfRow(row);
            this.setTextAndEditable(StringResourceViewPanel.this.myKey, key, false);
            String defaultValue = (String)model.getValueAt(row, ConstantColumn.DEFAULT_VALUE.ordinal());
            boolean defaultValueEditable = !StringUtil.containsChar((String)defaultValue, (char)'\n');
            this.setTextAndEditable(StringResourceViewPanel.this.myDefaultValue, defaultValue, defaultValueEditable);
            StringResourceViewPanel.this.myDefaultValueWithBrowseBtn.getButton().setEnabled(true);
            boolean translationEditable = false;
            String translation = "";
            if (locale != null) {
                translation = (String)model.getValueAt(row, column);
                translationEditable = !StringUtil.containsChar((String)translation, (char)'\n');
            }
            this.setTextAndEditable(StringResourceViewPanel.this.myTranslation, translation, translationEditable);
            StringResourceViewPanel.this.myTranslationWithBrowseBtn.getButton().setEnabled(locale != null);
        }

        private void setTextAndEditable(@NotNull JTextComponent component, @NotNull String text, boolean editable) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/strings/StringResourceViewPanel$CellSelectionListener", "setTextAndEditable"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/editors/strings/StringResourceViewPanel$CellSelectionListener", "setTextAndEditable"));
            }
            component.setText(text);
            component.setCaretPosition(0);
            component.setEditable(editable);
            component.getCaret().setVisible(editable && component.hasFocus());
            component.setFont(FontUtil.getFontAbleToDisplay(text, component.getFont()));
        }
    }

    private class ParseTask
    extends Task.Backgroundable {
        private AtomicReference<LocalResourceRepository> myResourceRepositoryRef;
        private AtomicReference<StringResourceData> myResourceDataRef;

        public ParseTask(String description) {
            super(StringResourceViewPanel.this.myFacet.getModule().getProject(), description, false);
            this.myResourceRepositoryRef = new AtomicReference<Object>(null);
            this.myResourceDataRef = new AtomicReference<Object>(null);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/editors/strings/StringResourceViewPanel$ParseTask", "run"));
            }
            indicator.setIndeterminate(true);
            LocalResourceRepository moduleResources = StringResourceViewPanel.this.myFacet.getModuleResources(true);
            this.myResourceRepositoryRef.set(moduleResources);
            this.myResourceDataRef.set(StringResourceParser.parse(StringResourceViewPanel.this.myFacet, moduleResources));
        }

        public void onSuccess() {
            StringResourceViewPanel.this.myLoadingPanel.stopLoading();
            StringResourceViewPanel.this.myData = this.myResourceDataRef.get();
            StringResourceViewPanel.this.myResourceRepository = this.myResourceRepositoryRef.get();
            StringResourceViewPanel.this.myModificationCount = StringResourceViewPanel.this.myResourceRepository.getModificationCount();
            StringResourceViewPanel.this.myTableModel.setData(StringResourceViewPanel.this.myData);
            StringResourceViewPanel.this.myTableModel.fireTableStructureChanged();
            ColumnUtil.setColumns((JTable)StringResourceViewPanel.this.myTable);
        }

        public void onCancel() {
            StringResourceViewPanel.this.myLoadingPanel.stopLoading();
        }
    }
}

