/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.sync;

import com.android.annotations.Nullable;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.service.sync.SyncEntityDataComparisonStrategy;
import com.android.tools.idea.gradle.service.sync.change.ProjectStructureChange;
import com.android.tools.idea.gradle.service.sync.service.Ide2GradleModuleDependencyService;
import com.android.tools.idea.gradle.service.sync.service.Ide2GradleProjectSyncService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ProjectTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class Ide2GradleProjectSyncFacade
implements StartupActivity {
    private static final Logger LOG;
    @NotNull
    private static final Map<Key<?>, Ide2GradleProjectSyncService<?>> ourSyncServices;
    @NotNull
    private static final String DUMMY_VALUE = "___DUMMY___";
    @NotNull
    private final AtomicReference<DataNode<ProjectData>> myLastSeenIdeProject = new AtomicReference();
    @NotNull
    private final SyncEntityDataComparisonStrategy myEqualityStrategy = new SyncEntityDataComparisonStrategy();

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "runActivity"));
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Following services are used for ide -> gradle changes propagation: " + ourSyncServices);
                }
                Ide2GradleProjectSyncFacade.this.myLastSeenIdeProject.set(Ide2GradleProjectSyncFacade.buildIdeProjectState(project));
                project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

                    public void rootsChanged(ModuleRootEvent event) {
                        GradleSyncState syncState = GradleSyncState.getInstance(project);
                        if (!syncState.isSyncInProgress() && !syncState.isGradleBasedIdeProjectModificationInProgress()) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Ide2GradleProjectSyncFacade.this.propagateIdeChangesIfPossible(project);
                                }
                            });
                        }
                    }
                });
            }
        };
        if (project.isInitialized()) {
            task.run();
        } else {
            StartupManager.getInstance((Project)project).registerPostStartupActivity(task);
        }
    }

    @VisibleForTesting
    public void testCheckChanges(@NotNull Project ideProject) {
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "testCheckChanges"));
        }
        if (this.myLastSeenIdeProject.get() == null) {
            this.myLastSeenIdeProject.set(Ide2GradleProjectSyncFacade.buildIdeProjectState(ideProject));
        } else {
            this.propagateIdeChangesIfPossible(ideProject);
        }
    }

    private void propagateIdeChangesIfPossible(final @NotNull Project ideProject) {
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "propagateIdeChangesIfPossible"));
        }
        DataNode<ProjectData> previousIdeProjectState = this.myLastSeenIdeProject.get();
        if (previousIdeProjectState == null) {
            assert (false);
            return;
        }
        DataNode<ProjectData> currentIdeProjectState = Ide2GradleProjectSyncFacade.buildIdeProjectState(ideProject);
        this.myLastSeenIdeProject.set(currentIdeProjectState);
        final ArrayList changes = Lists.newArrayList();
        this.fillSyncInput(Collections.singletonList(previousIdeProjectState), Collections.singletonList(currentIdeProjectState), ideProject, changes);
        if (changes.isEmpty()) {
            return;
        }
        GradleSyncState.getInstance(ideProject).runSyncTransparentAction(new Runnable(){

            @Override
            public void run() {
                for (ProjectStructureChange change : changes) {
                    Ide2GradleProjectSyncService service = (Ide2GradleProjectSyncService)ourSyncServices.get(change.getKey());
                    if (service == null) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug(String.format("Skipping change '%s' as no service is registered for it's key (%s)", change, change.getKey()));
                        continue;
                    }
                    boolean ok = service.flush(change, ideProject);
                    if (ok || !LOG.isDebugEnabled()) continue;
                    LOG.debug(String.format("Can't flush IDE project structure change '%s' via sync service %s", change, service));
                }
            }
        });
    }

    @NotNull
    private static DataNode<ProjectData> buildIdeProjectState(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "buildIdeProjectState"));
        }
        ProjectData projectData = new ProjectData(ProjectSystemId.IDE, project.getName(), DUMMY_VALUE, DUMMY_VALUE);
        DataNode result = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            String linkedProjectPath;
            if (!GradleConstants.SYSTEM_ID.getId().equals(module.getOptionValue("external.system.id")) || Strings.isNullOrEmpty((String)(linkedProjectPath = module.getOptionValue("external.linked.project.path")))) continue;
            Ide2GradleProjectSyncFacade.buildModuleState(module, linkedProjectPath, (DataNode<ProjectData>)result);
        }
        DataNode dataNode = result;
        if (dataNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "buildIdeProjectState"));
        }
        return dataNode;
    }

    private static void buildModuleState(@NotNull Module module, @NotNull String linkedExternalProjectPath, @NotNull DataNode<ProjectData> parent) {
        OrderEntry[] entries;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "buildModuleState"));
        }
        if (linkedExternalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedExternalProjectPath", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "buildModuleState"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "buildModuleState"));
        }
        DataNode result = new DataNode(ProjectKeys.MODULE, (Object)Ide2GradleProjectSyncFacade.buildModuleData(module, linkedExternalProjectPath), parent);
        for (OrderEntry entry : entries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            String externalSystemId;
            ModuleOrderEntry moduleOrderEntry;
            Module dependencyModule;
            if (!(entry instanceof ModuleOrderEntry) || (dependencyModule = (moduleOrderEntry = (ModuleOrderEntry)entry).getModule()) == null || (externalSystemId = dependencyModule.getOptionValue("external.system.id")) != null && !GradleConstants.SYSTEM_ID.getId().equals(externalSystemId)) continue;
            Ide2GradleProjectSyncFacade.buildModuleDependencyState(moduleOrderEntry, (DataNode<ModuleData>)result);
        }
        parent.addChild(result);
    }

    @NotNull
    private static ModuleData buildModuleData(@NotNull Module module, @Nullable String linkedExternalProjectPath) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "buildModuleData"));
        }
        String linkedExternalProjectPathToUse = linkedExternalProjectPath;
        if (linkedExternalProjectPathToUse == null) {
            linkedExternalProjectPathToUse = module.getOptionValue("external.linked.project.path");
        }
        if (linkedExternalProjectPathToUse == null) {
            linkedExternalProjectPathToUse = DUMMY_VALUE;
        }
        ModuleData moduleData = new ModuleData(DUMMY_VALUE, ProjectSystemId.IDE, DUMMY_VALUE, module.getName(), DUMMY_VALUE, linkedExternalProjectPathToUse);
        if (moduleData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "buildModuleData"));
        }
        return moduleData;
    }

    private static void buildModuleDependencyState(@NotNull ModuleOrderEntry dependency, @NotNull DataNode<ModuleData> parent) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "buildModuleDependencyState"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "buildModuleDependencyState"));
        }
        Module dependencyModule = dependency.getModule();
        if (dependencyModule == null) {
            assert (false);
            return;
        }
        ModuleDependencyData data = new ModuleDependencyData(Ide2GradleProjectSyncFacade.buildModuleData(dependency.getOwnerModule(), null), Ide2GradleProjectSyncFacade.buildModuleData(dependencyModule, null));
        DataNode node = new DataNode(ProjectKeys.MODULE_DEPENDENCY, (Object)data, parent);
        parent.addChild(node);
    }

    private void fillSyncInput(@NotNull Iterable<DataNode<?>> previousStateNodes, @NotNull Iterable<DataNode<?>> currentStateNodes, @NotNull Project project, @NotNull Collection<ProjectStructureChange> changes) {
        if (previousStateNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousStateNodes", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "fillSyncInput"));
        }
        if (currentStateNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentStateNodes", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "fillSyncInput"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "fillSyncInput"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "fillSyncInput"));
        }
        ArrayList previousStateNodesToUse = Lists.newArrayList(previousStateNodes);
        ArrayList currentStateNodesToUse = Lists.newArrayList(currentStateNodes);
        for (DataNode<?> previousStateNode : previousStateNodes) {
            DataNode<?> matchingCurrentStateNode = this.find(previousStateNode, currentStateNodesToUse, project);
            Ide2GradleProjectSyncFacade.registerChangeIfAppropriate(previousStateNode, matchingCurrentStateNode, project, changes);
            if (matchingCurrentStateNode != null) {
                currentStateNodesToUse.remove(matchingCurrentStateNode);
                this.fillSyncInput(previousStateNode.getChildren(), matchingCurrentStateNode.getChildren(), project, changes);
            }
            previousStateNodesToUse.remove(previousStateNode);
        }
        for (DataNode notMatchedCurrentStateNode : currentStateNodesToUse) {
            Ide2GradleProjectSyncFacade.registerChangeIfAppropriate(null, notMatchedCurrentStateNode, project, changes);
        }
    }

    private static void registerChangeIfAppropriate(@Nullable DataNode previousStateNode, @Nullable DataNode currentStateNode, @NotNull Project project, @NotNull Collection<ProjectStructureChange> changes) {
        block8: {
            block7: {
                ProjectStructureChange<?> change;
                Ide2GradleProjectSyncService<?> service;
                Key key;
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "registerChangeIfAppropriate"));
                }
                if (changes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "registerChangeIfAppropriate"));
                }
                if (previousStateNode == null && currentStateNode == null) {
                    throw new IllegalArgumentException("Can't register project structure change. Reason: both given 'previous' and 'current' state nodes are undefined. Changes registered so far: " + changes);
                }
                Key key2 = key = previousStateNode == null ? null : previousStateNode.getKey();
                if (key == null) {
                    key = currentStateNode.getKey();
                }
                if ((service = ourSyncServices.get(key)) != null && (change = service.build(previousStateNode, currentStateNode, project)) != null) {
                    changes.add(change);
                }
                if (currentStateNode != null) break block7;
                for (DataNode childNode : previousStateNode.getChildren()) {
                    Ide2GradleProjectSyncFacade.registerChangeIfAppropriate(childNode, null, project, changes);
                }
                break block8;
            }
            if (previousStateNode != null) break block8;
            for (DataNode childNode : currentStateNode.getChildren()) {
                Ide2GradleProjectSyncFacade.registerChangeIfAppropriate(null, childNode, project, changes);
            }
        }
    }

    @Nullable
    private DataNode<?> find(@NotNull DataNode<?> node, @NotNull Iterable<DataNode<?>> candidateNodes, @NotNull Project project) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "find"));
        }
        if (candidateNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateNodes", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "find"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/sync/Ide2GradleProjectSyncFacade", "find"));
        }
        for (DataNode<?> candidateNode : candidateNodes) {
            if (!node.getKey().equals((Object)candidateNode.getKey()) || !this.myEqualityStrategy.isSameNode(candidateNode, node, project)) continue;
            return candidateNode;
        }
        return null;
    }

    static {
        Ide2GradleProjectSyncService[] services;
        LOG = Logger.getInstance(Ide2GradleProjectSyncFacade.class);
        ourSyncServices = Maps.newHashMap();
        for (Ide2GradleProjectSyncService service : services = new Ide2GradleProjectSyncService[]{new Ide2GradleModuleDependencyService()}) {
            ourSyncServices.put(service.getKey(), service);
        }
    }
}

