/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.RenderSecurityManager;
import com.android.ide.common.rendering.SessionParamsFlags;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.gradle.structure.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.DomPullParser;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.rendering.LayoutFilePullParser;
import com.android.tools.idea.rendering.LayoutPsiPullParser;
import com.android.tools.idea.rendering.LayoutPullParserFactory;
import com.android.tools.idea.rendering.LayoutlibCallback;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.LogWrapper;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.rendering.multi.RenderPreviewMode;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.android.utils.HtmlBuilder;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.uipreview.RenderingException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.xmlpull.v1.XmlPullParserException;

public class RenderService
implements IImageFactory {
    @NotNull
    private final Module myModule;
    @NotNull
    private final XmlFile myPsiFile;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final LayoutlibCallback myLayoutlibCallback;
    private final AndroidVersion myMinSdkVersion;
    private final AndroidVersion myTargetSdkVersion;
    @NotNull
    private final LayoutLibrary myLayoutLib;
    @NotNull
    private final HardwareConfigHelper myHardwareConfigHelper;
    @Nullable
    private IncludeReference myIncludedWithin;
    @NotNull
    private SessionParams.RenderingMode myRenderingMode;
    @Nullable
    private Integer myOverrideBgColor;
    private boolean myShowDecorations;
    @NotNull
    private final Configuration myConfiguration;
    private long myTimeout;
    @Nullable
    private Set<XmlTag> myExpandNodes;
    @Nullable
    private RenderContext myRenderContext;
    @NotNull
    private final Locale myLocale;
    private final Object myCredential;
    private ResourceFolderType myFolderType;
    private static boolean ourWarnAboutObsoleteLayoutLibVersions = true;
    private static final Object RENDERING_LOCK = new Object();

    @Nullable
    public static RenderService create(@NotNull AndroidFacet facet, final @NotNull Module module, @NotNull PsiFile psiFile, @NotNull Configuration configuration, @NotNull RenderLogger logger, @Nullable RenderContext renderContext) {
        LayoutLibrary layoutLib;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/RenderService", "create"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/RenderService", "create"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/android/tools/idea/rendering/RenderService", "create"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/rendering/RenderService", "create"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/RenderService", "create"));
        }
        final Project project = module.getProject();
        AndroidPlatform platform = RenderService.getPlatform(module);
        if (platform == null) {
            if (!AndroidMavenUtil.isMavenizedModule(module)) {
                RenderProblem.Html message = RenderProblem.create(HighlightSeverity.ERROR);
                logger.addMessage(message);
                message.getHtmlBuilder().addLink("No Android SDK found. Please ", "configure", " an Android SDK.", logger.getLinkManager().createRunnableLink(new Runnable(){

                    @Override
                    public void run() {
                        ProjectSettingsService service = ProjectSettingsService.getInstance((Project)project);
                        if (Projects.isGradleProject(project) && service instanceof AndroidProjectSettingsService) {
                            ((AndroidProjectSettingsService)service).openSdkSettings();
                            return;
                        }
                        AndroidSdkUtils.openModuleDependenciesConfigurable(module);
                    }
                }));
            } else {
                String message = AndroidBundle.message("android.maven.cannot.parse.android.sdk.error", module.getName());
                logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message));
            }
            return null;
        }
        IAndroidTarget target = configuration.getTarget();
        if (target == null) {
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "No render target was chosen"));
            return null;
        }
        RenderService.warnIfObsoleteLayoutLib(module, logger, renderContext, target);
        try {
            layoutLib = platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
            if (layoutLib == null) {
                String message = AndroidBundle.message("android.layout.preview.cannot.load.library.error", new Object[0]);
                logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message));
                return null;
            }
        }
        catch (RenderingException e) {
            String message = e.getPresentableMessage();
            message = message != null ? message : AndroidBundle.message("android.layout.preview.default.error.message", new Object[0]);
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message, module.getProject(), logger.getLinkManager(), e));
            return null;
        }
        catch (IOException e) {
            String message = e.getMessage();
            logger.error(null, "I/O error: " + (message != null ? ": " + message : ""), e);
            return null;
        }
        if ("PreferenceScreen".equals(RenderService.getRootTagName(psiFile)) && !layoutLib.supports(14)) {
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "This version of the rendering library does not support rendering Preferences. Update it using the SDK Manager"));
            return null;
        }
        Device device = configuration.getDevice();
        if (device == null) {
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "No device selected"));
            return null;
        }
        RenderService service = new RenderService(facet, module, psiFile, configuration, logger, layoutLib, device);
        if (renderContext != null) {
            service.setRenderContext(renderContext);
        }
        return service;
    }

    protected static void warnIfObsoleteLayoutLib(final Module module, RenderLogger logger, final RenderContext renderContext, IAndroidTarget target) {
        int revision;
        if (!ourWarnAboutObsoleteLayoutLibVersions) {
            return;
        }
        final AndroidVersion version = target.getVersion();
        switch (version.getFeatureLevel()) {
            case 21: {
                if (version.isPreview()) {
                    revision = 4;
                    break;
                }
                revision = 1;
                break;
            }
            case 20: {
                revision = 2;
                break;
            }
            case 19: {
                revision = 4;
                break;
            }
            case 18: {
                revision = 3;
                break;
            }
            case 17: {
                revision = 3;
                break;
            }
            case 16: {
                revision = 5;
                break;
            }
            case 15: {
                revision = 5;
                break;
            }
            case 14: {
                revision = 4;
                break;
            }
            case 13: {
                revision = 1;
                break;
            }
            case 12: {
                revision = 3;
                break;
            }
            case 11: {
                revision = 2;
                break;
            }
            case 10: {
                revision = 2;
                break;
            }
            case 8: {
                revision = 3;
                break;
            }
            default: {
                revision = -1;
            }
        }
        if (revision >= 0 && target.getRevision() < revision) {
            RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
            problem.tag("obsoleteLayoutlib");
            HtmlBuilder builder = problem.getHtmlBuilder();
            builder.add("Using an obsolete version of the " + target.getVersionName() + " layout library which contains many known bugs: ");
            builder.addLink("Install Update", logger.getLinkManager().createRunnableLink(new Runnable(){

                @Override
                public void run() {
                    ourWarnAboutObsoleteLayoutLibVersions = false;
                    ArrayList requested = Lists.newArrayList();
                    requested.add(PkgDesc.Builder.newPlatform((AndroidVersion)version, (MajorRevision)new MajorRevision(revision), (FullRevision)FullRevision.NOT_SPECIFIED).create());
                    SdkQuickfixWizard wizard = new SdkQuickfixWizard(module.getProject(), null, requested);
                    wizard.init();
                    if (wizard.showAndGet() && renderContext != null) {
                        Configuration configuration = renderContext.getConfiguration();
                        if (configuration != null) {
                            configuration.getConfigurationManager().setTarget(null);
                        }
                        renderContext.requestRender();
                        Messages.showInfoMessage((Project)module.getProject(), (String)"Note: Due to a bug you may need to restart the IDE for the new layout library to fully take effect", (String)"Restart Recommended");
                    }
                }
            }));
            builder.addLink(", ", "Ignore For Now", null, logger.getLinkManager().createRunnableLink(new Runnable(){

                @Override
                public void run() {
                    ourWarnAboutObsoleteLayoutLibVersions = false;
                    if (renderContext != null) {
                        renderContext.requestRender();
                    }
                }
            }));
            logger.addMessage(problem);
        }
    }

    private RenderService(@NotNull AndroidFacet facet, @NotNull Module module, @NotNull PsiFile psiFile, @NotNull Configuration configuration, @NotNull RenderLogger logger, @NotNull LayoutLibrary layoutLib, @NotNull Device device) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/RenderService", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/RenderService", "<init>"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/android/tools/idea/rendering/RenderService", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/rendering/RenderService", "<init>"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/RenderService", "<init>"));
        }
        if (layoutLib == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutLib", "com/android/tools/idea/rendering/RenderService", "<init>"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/rendering/RenderService", "<init>"));
        }
        this.myRenderingMode = SessionParams.RenderingMode.NORMAL;
        this.myShowDecorations = true;
        this.myCredential = new Object();
        this.myModule = module;
        this.myLogger = logger;
        this.myLogger.setCredential(this.myCredential);
        if (!(psiFile instanceof XmlFile)) {
            throw new IllegalArgumentException("Can only render XML files: " + psiFile.getClass().getName());
        }
        this.myPsiFile = (XmlFile)psiFile;
        this.myConfiguration = configuration;
        this.myHardwareConfigHelper = new HardwareConfigHelper(device);
        this.myHardwareConfigHelper.setOrientation(configuration.getFullConfig().getScreenOrientationQualifier().getValue());
        this.myLayoutLib = layoutLib;
        AppResourceRepository appResources = AppResourceRepository.getAppResources(facet, true);
        this.myLayoutlibCallback = new LayoutlibCallback(this.myLayoutLib, appResources, this.myModule, facet, this.myLogger, this.myCredential, this);
        this.myLayoutlibCallback.loadAndParseRClass();
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        this.myMinSdkVersion = moduleInfo.getMinSdkVersion();
        this.myTargetSdkVersion = moduleInfo.getTargetSdkVersion();
        this.myLocale = configuration.getLocale();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                RenderService.this.myFolderType = ResourceHelper.getFolderType((PsiFile)RenderService.this.myPsiFile);
            }
        });
    }

    @Nullable
    public AndroidPlatform getPlatform() {
        return RenderService.getPlatform(this.myModule);
    }

    @Nullable
    private static AndroidPlatform getPlatform(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/RenderService", "getPlatform"));
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null || !(sdk.getSdkType() instanceof AndroidSdkType)) {
            return null;
        }
        AndroidSdkAdditionalData data = (AndroidSdkAdditionalData)sdk.getSdkAdditionalData();
        if (data == null) {
            return null;
        }
        return data.getAndroidPlatform();
    }

    @Nullable
    public ResourceResolver getResourceResolver() {
        return this.myConfiguration.getResourceResolver();
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService", "getConfiguration"));
        }
        return configuration;
    }

    @Nullable
    public ResourceFolderType getFolderType() {
        return this.myFolderType;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService", "getModule"));
        }
        return module;
    }

    @NotNull
    public RenderLogger getLogger() {
        RenderLogger renderLogger = this.myLogger;
        if (renderLogger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService", "getLogger"));
        }
        return renderLogger;
    }

    @Nullable
    public Set<XmlTag> getExpandNodes() {
        return this.myExpandNodes;
    }

    @NotNull
    public HardwareConfigHelper getHardwareConfigHelper() {
        HardwareConfigHelper hardwareConfigHelper = this.myHardwareConfigHelper;
        if (hardwareConfigHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService", "getHardwareConfigHelper"));
        }
        return hardwareConfigHelper;
    }

    public boolean getShowDecorations() {
        return this.myShowDecorations;
    }

    public void dispose() {
        this.myLayoutlibCallback.setLogger(null);
        this.myLayoutlibCallback.setResourceResolver(null);
    }

    public RenderService setOverrideRenderSize(int overrideRenderWidth, int overrideRenderHeight) {
        this.myHardwareConfigHelper.setOverrideRenderSize(overrideRenderWidth, overrideRenderHeight);
        return this;
    }

    public RenderService setMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
        this.myHardwareConfigHelper.setMaxRenderSize(maxRenderWidth, maxRenderHeight);
        return this;
    }

    public RenderService setRenderingMode(@NotNull SessionParams.RenderingMode renderingMode) {
        if (renderingMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderingMode", "com/android/tools/idea/rendering/RenderService", "setRenderingMode"));
        }
        this.myRenderingMode = renderingMode;
        return this;
    }

    @NotNull
    public SessionParams.RenderingMode getRenderingMode() {
        SessionParams.RenderingMode renderingMode = this.myRenderingMode;
        if (renderingMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService", "getRenderingMode"));
        }
        return renderingMode;
    }

    public RenderService setTimeout(long timeout) {
        this.myTimeout = timeout;
        return this;
    }

    @NotNull
    public RenderService setOverrideBgColor(@Nullable Integer overrideBgColor) {
        this.myOverrideBgColor = overrideBgColor;
        RenderService renderService = this;
        if (renderService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService", "setOverrideBgColor"));
        }
        return renderService;
    }

    public RenderService setDecorations(boolean showDecorations) {
        this.myShowDecorations = showDecorations;
        return this;
    }

    @Nullable
    public RenderContext getRenderContext() {
        return this.myRenderContext;
    }

    @Nullable
    public RenderService setRenderContext(@Nullable RenderContext renderContext) {
        this.myRenderContext = renderContext;
        return this;
    }

    @NotNull
    public RenderService setNodesToExpand(@Nullable Set<XmlTag> nodesToExpand) {
        this.myExpandNodes = nodesToExpand;
        RenderService renderService = this;
        if (renderService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService", "setNodesToExpand"));
        }
        return renderService;
    }

    @NotNull
    public RenderService setIncludedWithin(@Nullable IncludeReference includedWithin) {
        this.myIncludedWithin = includedWithin;
        RenderService renderService = this;
        if (renderService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService", "setIncludedWithin"));
        }
        return renderService;
    }

    @NotNull
    public IncludeReference getIncludedWithin() {
        IncludeReference includeReference = this.myIncludedWithin != null ? this.myIncludedWithin : IncludeReference.NONE;
        if (includeReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService", "getIncludedWithin"));
        }
        return includeReference;
    }

    @Nullable
    private RenderResult createRenderSession() {
        IAndroidTarget target;
        ResourceResolver resolver = this.getResourceResolver();
        if (resolver == null) {
            return null;
        }
        ILayoutPullParser modelParser = LayoutPullParserFactory.create(this);
        if (modelParser == null) {
            return null;
        }
        this.myLayoutlibCallback.reset();
        ILayoutPullParser includingParser = this.getIncludingLayoutParser(resolver, modelParser);
        if (includingParser != null) {
            modelParser = includingParser;
        }
        int simulatedPlatform = (target = this.myConfiguration.getTarget()) instanceof CompatibilityRenderTarget ? target.getVersion().getApiLevel() : 0;
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        final SessionParams params = new SessionParams(modelParser, this.myRenderingMode, (Object)this.myModule, hardwareConfig, (RenderResources)resolver, (IProjectCallback)this.myLayoutlibCallback, this.myMinSdkVersion.getApiLevel(), this.myTargetSdkVersion.getApiLevel(), (LayoutLog)this.myLogger, simulatedPlatform);
        params.setFlag(SessionParamsFlags.FLAG_KEY_ROOT_TAG, (Object)RenderService.getRootTagName((PsiFile)this.myPsiFile));
        params.setExtendedViewInfoMode(true);
        ManifestInfo manifestInfo = ManifestInfo.get(this.myModule);
        LayoutDirectionQualifier qualifier = this.myConfiguration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier != null && qualifier.getValue() == LayoutDirection.RTL) {
            params.setRtlSupport(true);
            params.setLocale("ur");
        } else {
            params.setLocale(this.myLocale.toLocaleId());
            try {
                params.setRtlSupport(manifestInfo.isRtlSupported());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Device device = this.myConfiguration.getDevice();
        if (!this.myShowDecorations || HardwareConfigHelper.isWear((Device)device)) {
            params.setForceNoDecor();
        } else {
            try {
                params.setAppLabel(manifestInfo.getApplicationLabel());
                params.setAppIcon(manifestInfo.getApplicationIcon());
                String activity = this.myConfiguration.getActivity();
                if (activity != null) {
                    params.setActivityName(activity);
                    ManifestInfo.ActivityAttributes attributes = manifestInfo.getActivityAttributes(activity);
                    if (attributes != null) {
                        if (attributes.getLabel() != null) {
                            params.setAppLabel(attributes.getLabel());
                        }
                        if (attributes.getIcon() != null) {
                            params.setAppIcon(attributes.getIcon());
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.myOverrideBgColor != null) {
            params.setOverrideBgColor(this.myOverrideBgColor.intValue());
        } else if (this.requiresTransparency()) {
            params.setOverrideBgColor(0);
        }
        params.setImageFactory((IImageFactory)this);
        if (this.myTimeout > 0L) {
            params.setTimeout(this.myTimeout);
        }
        try {
            this.myLayoutlibCallback.setLogger(this.myLogger);
            this.myLayoutlibCallback.setResourceResolver(resolver);
            RenderResult result = (RenderResult)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RenderResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public RenderResult compute() {
                    RenderSecurityManager securityManager = RenderService.this.createSecurityManager();
                    securityManager.setActive(true, RenderService.this.myCredential);
                    int retries = 0;
                    RenderSession session = null;
                    while (retries < 10) {
                        session = RenderService.this.myLayoutLib.createSession(params);
                        Result result = session.getResult();
                        if (result.getStatus() != Result.Status.ERROR_TIMEOUT) {
                            if (result.isSuccess() || !"The main Looper has already been prepared.".equals(result.getErrorMessage())) break;
                            ++retries;
                            continue;
                        }
                        ++retries;
                    }
                    RenderResult renderResult = new RenderResult(RenderService.this, session, (PsiFile)RenderService.this.myPsiFile, RenderService.this.myLogger);
                    RenderResult renderResult2 = renderResult;
                    if (renderResult2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService$5", "compute"));
                    }
                    return renderResult2;
                    finally {
                        securityManager.dispose(RenderService.this.myCredential);
                    }
                }
            });
            this.addDiagnostics(result.getSession());
            result.setIncludedWithin(this.myIncludedWithin);
            return result;
        }
        catch (RuntimeException t) {
            this.myLogger.error(null, t.getLocalizedMessage(), t, null);
            throw t;
        }
    }

    @Nullable
    private ILayoutPullParser getIncludingLayoutParser(ResourceResolver resolver, ILayoutPullParser modelParser) {
        if (this.myIncludedWithin == null) {
            String layout = IncludeReference.getIncludingLayout(this.myPsiFile);
            IncludeReference includeReference = this.myIncludedWithin = layout != null ? IncludeReference.get(this.myModule, this.myPsiFile, (RenderResources)resolver) : IncludeReference.NONE;
        }
        if (this.myIncludedWithin != IncludeReference.NONE) {
            assert (Comparing.equal((Object)this.myIncludedWithin.getToFile(), (Object)this.myPsiFile.getVirtualFile()));
            VirtualFile layoutVirtualFile = this.myIncludedWithin.getFromFile();
            try {
                String queryLayoutName = ResourceHelper.getResourceName((PsiFile)this.myPsiFile);
                this.myLayoutlibCallback.setLayoutParser(queryLayoutName, modelParser);
                Object topParser = null;
                PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(this.myModule.getProject(), layoutVirtualFile);
                if (psiFile instanceof XmlFile) {
                    LayoutPsiPullParser parser = LayoutPsiPullParser.create((XmlFile)psiFile, this.myLogger);
                    parser.setProvideViewCookies(false);
                    topParser = parser;
                }
                if (topParser == null) {
                    topParser = LayoutFilePullParser.create((IProjectCallback)this.myLayoutlibCallback, this.myIncludedWithin.getFromPath());
                }
                return topParser;
            }
            catch (IOException e) {
                this.myLogger.error(null, String.format("Could not read layout file %1$s", this.myIncludedWithin.getFromPath()), e);
            }
            catch (XmlPullParserException e) {
                this.myLogger.error(null, String.format("XML parsing error: %1$s", e.getMessage()), e.getDetail() != null ? e.getDetail() : e);
            }
        }
        return null;
    }

    private RenderSecurityManager createSecurityManager() {
        String projectPath = null;
        String sdkPath = null;
        RenderSecurityManager securityManager = new RenderSecurityManager(sdkPath, projectPath);
        securityManager.setLogger((ILogger)new LogWrapper(RenderLogger.LOG));
        securityManager.setAppTempDir(PathManager.getTempPath());
        return securityManager;
    }

    public static boolean canRender(@Nullable PsiFile file) {
        return file != null && LayoutPullParserFactory.isSupported(file);
    }

    @Nullable
    public static String getRootTagName(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/RenderService", "getRootTagName"));
        }
        if (ResourceHelper.getFolderType(file) == ResourceFolderType.XML && file instanceof XmlFile) {
            XmlTag rootTag = AndroidPsiUtils.getRootTagSafely((XmlFile)file);
            return rootTag == null ? null : rootTag.getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public RenderResult render() {
        Object object = RENDERING_LOCK;
        synchronized (object) {
            RenderResult renderResult;
            try {
                renderResult = this.createRenderSession();
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = e.toString();
                }
                this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message, this.myModule.getProject(), this.myLogger.getLinkManager(), e));
                renderResult = new RenderResult(this, null, (PsiFile)this.myPsiFile, this.myLogger);
            }
            return renderResult;
        }
    }

    private void addDiagnostics(@Nullable RenderSession session) {
        ILayoutPullParser layoutEmbeddedParser;
        if (session == null) {
            return;
        }
        Result r = session.getResult();
        if (!this.myLogger.hasProblems() && !r.isSuccess()) {
            if (r.getException() != null || r.getErrorMessage() != null) {
                this.myLogger.error(null, r.getErrorMessage(), r.getException(), null);
            } else if (r.getStatus() == Result.Status.ERROR_TIMEOUT) {
                this.myLogger.error(null, "Rendering timed out.", null);
            } else {
                this.myLogger.error(null, "Unknown render problem: " + r.getStatus(), null);
            }
        } else if (this.myIncludedWithin != null && this.myIncludedWithin != IncludeReference.NONE && (layoutEmbeddedParser = this.myLayoutlibCallback.getLayoutEmbeddedParser()) != null) {
            this.myLogger.error(null, String.format("The surrounding layout (%1$s) did not actually include this layout. Remove tools:showIn=... from the root tag.", this.myIncludedWithin.getFromResourceUrl()), null);
        }
    }

    @Nullable
    public BufferedImage renderDrawable(ResourceValue drawableResourceValue) {
        Object data;
        if (drawableResourceValue == null) {
            return null;
        }
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        DrawableParams params = new DrawableParams(drawableResourceValue, (Object)this.myModule, hardwareConfig, (RenderResources)this.getResourceResolver(), (IProjectCallback)this.myLayoutlibCallback, this.myMinSdkVersion.getApiLevel(), this.myTargetSdkVersion.getApiLevel(), (LayoutLog)this.myLogger);
        params.setForceNoDecor();
        Result result = this.myLayoutLib.renderDrawable(params);
        if (result != null && result.isSuccess() && (data = result.getData()) instanceof BufferedImage) {
            return (BufferedImage)data;
        }
        return null;
    }

    @NotNull
    public LayoutLibrary getLayoutLib() {
        LayoutLibrary layoutLibrary = this.myLayoutLib;
        if (layoutLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService", "getLayoutLib"));
        }
        return layoutLibrary;
    }

    @NotNull
    public LayoutlibCallback getLayoutlibCallback() {
        LayoutlibCallback layoutlibCallback = this.myLayoutlibCallback;
        if (layoutlibCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService", "getLayoutlibCallback"));
        }
        return layoutlibCallback;
    }

    @NotNull
    public XmlFile getPsiFile() {
        XmlFile xmlFile = this.myPsiFile;
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService", "getPsiFile"));
        }
        return xmlFile;
    }

    public boolean supportsCapability(int capability) {
        return this.myLayoutLib.supports(capability);
    }

    public static boolean supportsCapability(@NotNull Module module, @NotNull IAndroidTarget target, int capability) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/RenderService", "supportsCapability"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/rendering/RenderService", "supportsCapability"));
        }
        Project project = module.getProject();
        AndroidPlatform platform = RenderService.getPlatform(module);
        if (platform != null) {
            try {
                LayoutLibrary library = platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
                if (library != null) {
                    return library.supports(capability);
                }
            }
            catch (RenderingException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    public static LayoutLibrary getLayoutLibrary(@Nullable Module module, @Nullable IAndroidTarget target) {
        if (module == null || target == null) {
            return null;
        }
        Project project = module.getProject();
        AndroidPlatform platform = RenderService.getPlatform(module);
        if (platform != null) {
            try {
                return platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
            }
            catch (RenderingException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isNonRectangular() {
        return this.getFolderType() == ResourceFolderType.DRAWABLE;
    }

    public boolean requiresTransparency() {
        return this.isNonRectangular();
    }

    public BufferedImage getImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    public void useDesignMode(final @Nullable PsiFile file) {
        if (file == null) {
            return;
        }
        String tagName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                XmlTag root;
                if (file instanceof XmlFile && (root = ((XmlFile)file).getRootTag()) != null) {
                    return root.getName();
                }
                return null;
            }
        });
        if (tagName != null) {
            RenderPreviewMode currentMode = RenderPreviewMode.getCurrent();
            if (currentMode != RenderPreviewMode.NONE) {
                return;
            }
            if ("ScrollView".equals(tagName)) {
                this.setRenderingMode(SessionParams.RenderingMode.V_SCROLL);
                this.setDecorations(false);
            } else if ("HorizontalScrollView".equals(tagName)) {
                this.setRenderingMode(SessionParams.RenderingMode.H_SCROLL);
                this.setDecorations(false);
            }
        }
    }

    @Nullable
    public List<ViewInfo> measure(Element parent) {
        Result result;
        DomPullParser modelParser = new DomPullParser(parent);
        RenderSession session = this.measure((ILayoutPullParser)modelParser);
        if (session != null && (result = session.getResult()) != null && result.isSuccess()) {
            assert (session.getRootViews().size() == 1);
            return session.getRootViews();
        }
        return null;
    }

    @Nullable
    public Map<XmlTag, ViewInfo> measureChildren(XmlTag parent, AttributeFilter filter) {
        LayoutPsiPullParser modelParser = LayoutPsiPullParser.create(filter, parent, this.myLogger);
        HashMap map = Maps.newHashMap();
        RenderSession session = this.measure((ILayoutPullParser)modelParser);
        if (session != null) {
            Result result = session.getResult();
            if (result != null && result.isSuccess()) {
                assert (session.getRootViews().size() == 1);
                ViewInfo root = (ViewInfo)session.getRootViews().get(0);
                List children = root.getChildren();
                for (ViewInfo info : children) {
                    Object cookie = info.getCookie();
                    if (!(cookie instanceof XmlTag)) continue;
                    map.put((XmlTag)cookie, info);
                }
            }
            return map;
        }
        return null;
    }

    @Nullable
    public ViewInfo measureChild(XmlTag tag, AttributeFilter filter) {
        Map<XmlTag, ViewInfo> map;
        XmlTag parent = tag.getParentTag();
        if (parent != null && (map = this.measureChildren(parent, filter)) != null) {
            for (Map.Entry<XmlTag, ViewInfo> entry : map.entrySet()) {
                if (entry.getKey() != tag) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @Nullable
    private RenderSession measure(ILayoutPullParser parser) {
        ResourceResolver resolver = this.getResourceResolver();
        if (resolver == null) {
            return null;
        }
        this.myLayoutlibCallback.reset();
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        final SessionParams params = new SessionParams(parser, SessionParams.RenderingMode.FULL_EXPAND, (Object)this.myModule, hardwareConfig, (RenderResources)resolver, (IProjectCallback)this.myLayoutlibCallback, this.myMinSdkVersion.getApiLevel(), this.myTargetSdkVersion.getApiLevel(), (LayoutLog)this.myLogger);
        params.setLayoutOnly();
        params.setForceNoDecor();
        params.setExtendedViewInfoMode(true);
        params.setLocale(this.myLocale.toLocaleId());
        ManifestInfo manifestInfo = ManifestInfo.get(this.myModule);
        try {
            params.setRtlSupport(manifestInfo.isRtlSupported());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.myLayoutlibCallback.setLogger(this.myLogger);
            this.myLayoutlibCallback.setResourceResolver(resolver);
            return (RenderSession)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RenderSession>(){

                @Nullable
                public RenderSession compute() {
                    int retries = 0;
                    while (retries < 10) {
                        RenderSession session = RenderService.this.myLayoutLib.createSession(params);
                        Result result = session.getResult();
                        if (result.getStatus() != Result.Status.ERROR_TIMEOUT) {
                            if (!result.isSuccess() && "The main Looper has already been prepared.".equals(result.getErrorMessage())) {
                                ++retries;
                                continue;
                            }
                            return session;
                        }
                        ++retries;
                    }
                    return null;
                }
            });
        }
        catch (RuntimeException t) {
            this.myLogger.error(null, t.getLocalizedMessage(), t, null);
            throw t;
        }
    }

    public static interface AttributeFilter {
        @Nullable
        public String getAttribute(@NotNull XmlTag var1, @Nullable String var2, @NotNull String var3);
    }
}

