/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.SdkConstants;
import com.android.sdklib.repository.FullRevision;
import com.google.common.io.Closeables;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VersionCheck {
    private static final Logger LOG = Logger.getInstance(VersionCheck.class);
    public static final FullRevision MIN_TOOLS_REV = new FullRevision(23, 0, 5, 0);
    private static final Pattern mySourcePropPattern = Pattern.compile("^Pkg.Revision=(.*)$");

    private VersionCheck() {
    }

    public static boolean isCompatibleVersion(@NotNull File sdkDir) {
        if (sdkDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkDir", "com/android/tools/idea/sdk/VersionCheck", "isCompatibleVersion"));
        }
        if (!sdkDir.isDirectory()) {
            return false;
        }
        return VersionCheck.isCompatibleVersion(sdkDir.getAbsolutePath());
    }

    public static boolean isCompatibleVersion(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return false;
        }
        return VersionCheck.checkVersion(sdkPath).isCompatibleVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public static VersionCheckResult checkVersion(@NotNull String sdkPath) {
        FullRevision toolsRevision;
        block15: {
            String line;
            if (sdkPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "com/android/tools/idea/sdk/VersionCheck", "checkVersion"));
            }
            File toolsDir = new File(sdkPath, SdkConstants.OS_SDK_TOOLS_FOLDER);
            toolsRevision = new FullRevision(Integer.MAX_VALUE);
            BufferedReader reader = null;
            File sourceProperties = new File(toolsDir, "source.properties");
            reader = new BufferedReader(new FileReader(sourceProperties));
            while ((line = reader.readLine()) != null) {
                Matcher m = mySourcePropPattern.matcher(line);
                if (!m.matches()) continue;
                try {
                    toolsRevision = FullRevision.parseRevision((String)m.group(1));
                }
                catch (NumberFormatException ignore) {}
                break;
            }
            try {
                Closeables.close((Closeable)reader, (boolean)true);
            }
            catch (IOException e) {}
            break block15;
            catch (IOException e) {
                try {
                    String msg = String.format("Failed to read file: '%1$s' for Android SDK at '%2$s'", "source.properties", sdkPath);
                    LOG.info(msg, (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        Closeables.close(reader, (boolean)true);
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    Closeables.close((Closeable)reader, (boolean)true);
                }
                catch (IOException e3) {}
            }
        }
        VersionCheckResult versionCheckResult = new VersionCheckResult(toolsRevision);
        if (versionCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/VersionCheck", "checkVersion"));
        }
        return versionCheckResult;
    }

    public static class VersionCheckResult {
        @NotNull
        private final FullRevision myRevision;
        private final boolean myCompatibleVersion;

        VersionCheckResult(@NotNull FullRevision revision) {
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/android/tools/idea/sdk/VersionCheck$VersionCheckResult", "<init>"));
            }
            this.myRevision = revision;
            this.myCompatibleVersion = VersionCheckResult.isCompatible(revision);
        }

        private static boolean isCompatible(@NotNull FullRevision revision) {
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/android/tools/idea/sdk/VersionCheck$VersionCheckResult", "isCompatible"));
            }
            if (revision.getMajor() == Integer.MAX_VALUE) {
                return false;
            }
            return revision.compareTo(MIN_TOOLS_REV, FullRevision.PreviewComparison.IGNORE) >= 0;
        }

        @NotNull
        public FullRevision getRevision() {
            FullRevision fullRevision = this.myRevision;
            if (fullRevision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/VersionCheck$VersionCheckResult", "getRevision"));
            }
            return fullRevision;
        }

        public boolean isCompatibleVersion() {
            return this.myCompatibleVersion;
        }
    }
}

