/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.sdklib.internal.repository.packages.License;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.tools.idea.sdk.wizard.AndroidSdkLicenseTemporaryData;
import com.android.tools.idea.wizard.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.treeStructure.Tree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class LicenseAgreementStep
extends DynamicWizardStepWithHeaderAndDescription {
    private JTextPane myLicenseTextField;
    private Tree myChangeTree;
    private JRadioButton myDeclineRadioButton;
    private JRadioButton myAcceptRadioButton;
    private DefaultTreeModel myTreeModel;
    private Map<String, Boolean> myAcceptances;
    private String myCurrentLicense;

    public LicenseAgreementStep(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/sdk/wizard/LicenseAgreementStep", "<init>"));
        }
        super("License Agreement", "Read and agree to the licenses for the components which will be installed", null, disposable);
        this.myTreeModel = new DefaultTreeModel(null);
        this.myAcceptances = Maps.newHashMap();
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setHonorComponentsMinimumSize(true);
        this.myChangeTree = new Tree();
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myChangeTree));
        this.myLicenseTextField = new JTextPane();
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myLicenseTextField));
        this.myDeclineRadioButton = new JBRadioButton("Decline");
        this.myAcceptRadioButton = new JBRadioButton("Accept");
        ButtonGroup optionsGroup = new ButtonGroup();
        optionsGroup.add(this.myDeclineRadioButton);
        optionsGroup.add(this.myAcceptRadioButton);
        JPanel optionsPanel = new JPanel(new FlowLayout(4));
        optionsPanel.add(this.myDeclineRadioButton);
        optionsPanel.add(this.myAcceptRadioButton);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)splitter, "Center");
        mainPanel.add((Component)optionsPanel, "South");
        this.setBodyComponent(mainPanel);
    }

    @Override
    public void init() {
        super.init();
        this.myChangeTree.setModel((TreeModel)this.myTreeModel);
        this.myChangeTree.setShowsRootHandles(false);
        this.myLicenseTextField.setEditable(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.myDeclineRadioButton);
        group.add(this.myAcceptRadioButton);
        this.myDeclineRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseAgreementStep.this.myAcceptances.put(LicenseAgreementStep.this.myCurrentLicense, Boolean.FALSE);
                LicenseAgreementStep.this.invokeUpdate(null);
            }
        });
        this.myAcceptRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseAgreementStep.this.myAcceptances.put(LicenseAgreementStep.this.myCurrentLicense, Boolean.TRUE);
                LicenseAgreementStep.this.invokeUpdate(null);
            }
        });
        this.myChangeTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode selected = (DefaultMutableTreeNode)LicenseAgreementStep.this.myChangeTree.getLastSelectedPathComponent();
                if (selected != null && selected.isRoot()) {
                    return;
                }
                if (selected != null && !selected.isLeaf()) {
                    License license = (License)selected.getUserObject();
                    LicenseAgreementStep.this.myLicenseTextField.setText(license.getLicense());
                    LicenseAgreementStep.this.myCurrentLicense = license.getLicenseRef();
                } else if (selected != null && !selected.isRoot()) {
                    Change change = (Change)selected.getUserObject();
                    LicenseAgreementStep.this.myLicenseTextField.setText(change.license.getLicense());
                    LicenseAgreementStep.this.myCurrentLicense = change.license.getLicenseRef();
                }
                if (((Boolean)LicenseAgreementStep.this.myAcceptances.get(LicenseAgreementStep.this.myCurrentLicense)).booleanValue()) {
                    LicenseAgreementStep.this.myAcceptRadioButton.setSelected(true);
                } else {
                    LicenseAgreementStep.this.myDeclineRadioButton.setSelected(true);
                }
                LicenseAgreementStep.this.myLicenseTextField.setCaretPosition(0);
            }
        });
        this.myChangeTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/sdk/wizard/LicenseAgreementStep$4", "customizeCellRenderer"));
                }
                if (row == 0) {
                    this.append("Licenses", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (!leaf) {
                    License license = (License)node.getUserObject();
                    this.append(license.getLicenseRef(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else {
                    Change change = (Change)node.getUserObject();
                    if (change == null) {
                        return;
                    }
                    this.append(change.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.setIcon(change.getIcon());
                }
            }
        });
        this.setChanges(this.createChangesList());
    }

    @Override
    public boolean isStepVisible() {
        return this.myState.listSize(WizardConstants.INSTALL_REQUESTS_KEY) > 0;
    }

    @Override
    public boolean validate() {
        for (String s : this.myAcceptances.keySet()) {
            if (this.myAcceptances.get(s).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("License Agreement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/LicenseAgreementStep", "getStepName"));
        }
        return "License Agreement";
    }

    private void expandTree() {
        for (int i = 0; i < this.myChangeTree.getRowCount(); ++i) {
            this.myChangeTree.expandRow(i);
        }
    }

    private List<Change> createChangesList() {
        ArrayList toReturn = Lists.newArrayList();
        List requestedPackageNames = this.myState.get(WizardConstants.INSTALL_REQUESTS_KEY);
        if (requestedPackageNames != null) {
            for (Object o : requestedPackageNames) {
                IPkgDesc desc = (IPkgDesc)o;
                if (desc.getAndroidVersion() != null && desc.getAndroidVersion().isPreview()) {
                    toReturn.add(new Change(ChangeType.INSTALL, (IPkgDesc)o, AndroidSdkLicenseTemporaryData.HARDCODED_ANDROID_PREVIEW_SDK_LICENSE));
                    continue;
                }
                toReturn.add(new Change(ChangeType.INSTALL, (IPkgDesc)o, AndroidSdkLicenseTemporaryData.HARDCODED_ANDROID_SDK_LICENSE));
            }
        }
        return toReturn;
    }

    public void setChanges(List<Change> changes) {
        HashMap licenseNodeMap = Maps.newHashMap();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultMutableTreeNode firstChild = null;
        for (Change change : changes) {
            if (!licenseNodeMap.containsKey(change.license.getLicenseRef())) {
                DefaultMutableTreeNode n = new DefaultMutableTreeNode(change.license);
                if (firstChild == null) {
                    firstChild = n;
                }
                String licenceRef = change.license.getLicenseRef();
                licenseNodeMap.put(licenceRef, n);
                this.myAcceptances.put(licenceRef, Boolean.FALSE);
                root.add(n);
            }
            ((DefaultMutableTreeNode)licenseNodeMap.get(change.license.getLicenseRef())).add(new DefaultMutableTreeNode(change));
        }
        this.myTreeModel = new DefaultTreeModel(root);
        this.myChangeTree.setModel((TreeModel)this.myTreeModel);
        this.expandTree();
        if (firstChild != null) {
            this.myChangeTree.setSelectionPath(new TreePath(firstChild.getPath()));
        }
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        this.setChanges(this.createChangesList());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myChangeTree;
    }

    protected static class Change {
        public ChangeType type;
        public IPkgDesc packageDescription;
        public License license;

        public Change(@NotNull ChangeType type, @NotNull IPkgDesc packageDescription, @NotNull License license) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/sdk/wizard/LicenseAgreementStep$Change", "<init>"));
            }
            if (packageDescription == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDescription", "com/android/tools/idea/sdk/wizard/LicenseAgreementStep$Change", "<init>"));
            }
            if (license == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "license", "com/android/tools/idea/sdk/wizard/LicenseAgreementStep$Change", "<init>"));
            }
            this.type = type;
            this.packageDescription = packageDescription;
            this.license = license;
        }

        public String toString() {
            if (this.packageDescription.getListDescription() != null) {
                return this.packageDescription.getListDescription();
            }
            return "INCORRECT PACKAGE DESCRIPTION";
        }

        public Icon getIcon() {
            switch (this.type) {
                case INSTALL: {
                    return AllIcons.Actions.Download;
                }
                case UPDATE: {
                    return AllIcons.Actions.Refresh;
                }
                case REMOVE: {
                    return AllIcons.Actions.Cancel;
                }
            }
            return null;
        }
    }

    protected static enum ChangeType {
        INSTALL,
        UPDATE,
        REMOVE;

    }
}

