/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.welcome.FirstRunWelcomeStep;
import com.android.tools.idea.welcome.InstallComponentsPath;
import com.android.tools.idea.welcome.InstallerData;
import com.android.tools.idea.welcome.LongRunningOperationPath;
import com.android.tools.idea.welcome.ProgressStep;
import com.android.tools.idea.welcome.SetupJdkPath;
import com.android.tools.idea.welcome.WizardException;
import com.android.tools.idea.wizard.AndroidStudioWizardPath;
import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.DynamicWizardHost;
import com.android.tools.idea.wizard.SingleStepPath;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class FirstRunWizard
extends DynamicWizard {
    public static final String WIZARD_TITLE = "Android Studio Setup";
    private final AtomicInteger myFinishClicks = new AtomicInteger(0);
    private final SetupJdkPath myJdkPath = new SetupJdkPath();
    private InstallComponentsPath myComponentsPath;

    public FirstRunWizard(DynamicWizardHost host) {
        super(null, null, WIZARD_TITLE, host);
        this.setTitle(WIZARD_TITLE);
    }

    @Override
    public void init() {
        SetupProgressStep progressStep = new SetupProgressStep();
        this.myComponentsPath = new InstallComponentsPath(progressStep);
        this.addPath(new SingleStepPath(new FirstRunWelcomeStep()));
        this.addPath(this.myJdkPath);
        this.addPath(this.myComponentsPath);
        this.addPath(new SingleStepPath(new LicenseAgreementStep(this.getDisposable()){

            @Override
            public boolean isStepVisible() {
                return super.isStepVisible() && !InstallerData.get(this.myState).exists();
            }
        }));
        this.addPath(new SingleStepPath(progressStep));
        super.init();
    }

    @Override
    public void doFinishAction() {
        if (this.myFinishClicks.incrementAndGet() == 1) {
            this.doNextAction();
        } else {
            assert (this.myFinishClicks.get() <= 2);
            super.doFinishAction();
        }
    }

    private void doLongRunningOperation(@NotNull ProgressStep progressStep) throws WizardException {
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/FirstRunWizard", "doLongRunningOperation"));
        }
        for (AndroidStudioWizardPath path : this.myPaths) {
            if (progressStep.isCanceled()) break;
            if (!(path instanceof LongRunningOperationPath)) continue;
            ((LongRunningOperationPath)((Object)path)).runLongOperation();
        }
    }

    @Override
    public void performFinishingActions() {
    }

    @Override
    protected String getWizardActionDescription() {
        return WIZARD_TITLE;
    }

    private class SetupProgressStep
    extends ProgressStep {
        public SetupProgressStep() {
            super(FirstRunWizard.this.getDisposable());
        }

        @Override
        protected void execute() {
            FirstRunWizard.this.myHost.runSensitiveOperation(this.getProgressIndicator(), true, new Runnable(){

                @Override
                public void run() {
                    try {
                        FirstRunWizard.this.doLongRunningOperation(SetupProgressStep.this);
                    }
                    catch (WizardException e) {
                        Logger.getInstance(this.getClass()).error((Throwable)e);
                        SetupProgressStep.this.showConsole();
                        SetupProgressStep.this.print(e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                }
            });
        }

        @Override
        public boolean canGoPrevious() {
            return false;
        }

        @Override
        public boolean isStepVisible() {
            return FirstRunWizard.this.myFinishClicks.get() == 1 || !FirstRunWizard.this.myJdkPath.showsStep() && !FirstRunWizard.this.myComponentsPath.showsStep();
        }
    }
}

