/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.updater.SdkUpdaterNoWindow;
import com.android.sdklib.repository.NoPreviewRevision;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.sdk.SdkMerger;
import com.android.tools.idea.welcome.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.AndroidSdk;
import com.android.tools.idea.welcome.DownloadOperation;
import com.android.tools.idea.welcome.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.Haxm;
import com.android.tools.idea.welcome.InstallContext;
import com.android.tools.idea.welcome.InstallableComponent;
import com.android.tools.idea.welcome.InstallationTypeWizardStep;
import com.android.tools.idea.welcome.InstallerData;
import com.android.tools.idea.welcome.LinuxHaxmInfoStep;
import com.android.tools.idea.welcome.LongRunningOperationPath;
import com.android.tools.idea.welcome.ProgressStep;
import com.android.tools.idea.welcome.SdkComponentsStep;
import com.android.tools.idea.welcome.SdkManagerProgressIndicatorIntegration;
import com.android.tools.idea.welcome.UnzipOperation;
import com.android.tools.idea.welcome.WizardException;
import com.android.tools.idea.wizard.DynamicWizardPath;
import com.android.tools.idea.wizard.DynamicWizardStep;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallComponentsPath
extends DynamicWizardPath
implements LongRunningOperationPath {
    public static final ScopedStateStore.Key<Boolean> KEY_CUSTOM_INSTALL = ScopedStateStore.createKey("custom.install", ScopedStateStore.Scope.PATH, Boolean.class);
    private static final InstallableComponent[] COMPONENTS = InstallComponentsPath.createComponents();
    private static final ScopedStateStore.Key<String> KEY_SDK_INSTALL_LOCATION = ScopedStateStore.createKey("download.sdk.location", ScopedStateStore.Scope.PATH, String.class);
    private final ProgressStep myProgressStep;
    private InstallationTypeWizardStep myInstallationTypeWizardStep;
    private SdkComponentsStep mySdkComponentsStep;

    public InstallComponentsPath(@NotNull ProgressStep progressStep) {
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/InstallComponentsPath", "<init>"));
        }
        this.myProgressStep = progressStep;
    }

    private static InstallableComponent[] createComponents() {
        AndroidSdk androidSdk = new AndroidSdk();
        if (Haxm.canRun()) {
            return new InstallableComponent[]{androidSdk, new Haxm(KEY_CUSTOM_INSTALL)};
        }
        return new InstallableComponent[]{androidSdk};
    }

    private static File createTempDir() throws WizardException {
        File tempDirectory;
        try {
            tempDirectory = FileUtil.createTempDirectory((String)"AndroidStudio", (String)"FirstRun", (boolean)true);
        }
        catch (IOException e) {
            throw new WizardException("Unable to create temporary folder: " + e.getMessage(), e);
        }
        return tempDirectory;
    }

    private static boolean hasPlatformsDir(@Nullable File[] files) {
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!InstallComponentsPath.isPlatformsDir(file)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPlatformsDir(File file) {
        return file.isDirectory() && file.getName().equalsIgnoreCase("platforms");
    }

    @NotNull
    private static File getSdkRoot(@NotNull File expandedLocation) {
        if (expandedLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expandedLocation", "com/android/tools/idea/welcome/InstallComponentsPath", "getSdkRoot"));
        }
        File[] files = expandedLocation.listFiles();
        if (InstallComponentsPath.hasPlatformsDir(files)) {
            File file = expandedLocation;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallComponentsPath", "getSdkRoot"));
            }
            return file;
        }
        if (files != null) {
            for (File file : files) {
                if (!InstallComponentsPath.hasPlatformsDir(file.listFiles())) continue;
                File file2 = file;
                if (file2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallComponentsPath", "getSdkRoot"));
                }
                return file2;
            }
        }
        File file = expandedLocation;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallComponentsPath", "getSdkRoot"));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static boolean downloadAndUnzipSdkSeed(@NotNull InstallContext context, @NotNull File destination, double progressShare) throws WizardException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/InstallComponentsPath", "downloadAndUnzipSdkSeed"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/welcome/InstallComponentsPath", "downloadAndUnzipSdkSeed"));
        }
        double DOWNLOAD_OPERATION_PROGRESS_SHARE = progressShare * 0.8;
        double UNZIP_OPERATION_PROGRESS_SHARE = progressShare - DOWNLOAD_OPERATION_PROGRESS_SHARE;
        File file = (File)new DownloadOperation(context, FirstRunWizardDefaults.getSdkDownloadUrl(), DOWNLOAD_OPERATION_PROGRESS_SHARE).execute();
        try {
            boolean bl = InstallComponentsPath.unzip(context, file, destination, UNZIP_OPERATION_PROGRESS_SHARE);
            return bl;
        }
        finally {
            if (file != null && file.isFile() && file.getAbsolutePath().startsWith(context.getTempDirectory().getAbsolutePath())) {
                FileUtil.delete((File)file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unzip(@NotNull InstallContext context, @Nullable File archive, @NotNull File destination, double progressShare) throws WizardException {
        block9: {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/InstallComponentsPath", "unzip"));
            }
            if (destination == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/welcome/InstallComponentsPath", "unzip"));
            }
            if (archive == null) {
                return false;
            }
            try {
                FileUtil.ensureExists((File)destination.getParentFile());
                File unpacked = (File)new UnzipOperation(context, archive, progressShare).execute();
                if (unpacked == null) break block9;
                try {
                    FileUtil.rename((File)InstallComponentsPath.getSdkRoot(unpacked), (File)destination);
                }
                finally {
                    if (unpacked.isDirectory()) {
                        FileUtil.delete((File)unpacked);
                    }
                }
                return true;
            }
            catch (IOException e) {
                throw new WizardException("Unable to prepare Android SDK", e);
            }
        }
        return false;
    }

    @Nullable
    @Contract(value="false, _, _ -> null;true, _, _ -> !null")
    public static PkgDesc.Builder createExtra(boolean shouldInstallFlag, String vendor, String path) {
        if (!shouldInstallFlag) {
            return null;
        }
        return PkgDesc.Builder.newExtra((IdDisplay)new IdDisplay(vendor, ""), (String)path, (String)"", null, (NoPreviewRevision)new NoPreviewRevision(0));
    }

    private static File mergeRepoIntoDestination(InstallContext context, @NotNull File repo, @NotNull File destination, double progressRatio) throws WizardException {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "com/android/tools/idea/welcome/InstallComponentsPath", "mergeRepoIntoDestination"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/welcome/InstallComponentsPath", "mergeRepoIntoDestination"));
        }
        try {
            return context.run(new MergeOperation(destination, repo, context), progressRatio);
        }
        catch (IOException e) {
            throw new WizardException(e.getMessage(), e);
        }
    }

    private static boolean existsAndIsVisible(DynamicWizardStep step) {
        return step != null && step.isStepVisible();
    }

    @VisibleForTesting
    static void setupSdkComponents(@NotNull InstallContext installContext, @NotNull File sdk, @NotNull Collection<? extends InstallableComponent> selectedComponents, double progressRatio) throws WizardException {
        if (installContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installContext", "com/android/tools/idea/welcome/InstallComponentsPath", "setupSdkComponents"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/welcome/InstallComponentsPath", "setupSdkComponents"));
        }
        if (selectedComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedComponents", "com/android/tools/idea/welcome/InstallComponentsPath", "setupSdkComponents"));
        }
        HashSet packages = Sets.newHashSet();
        for (InstallableComponent installableComponent : selectedComponents) {
            for (PkgDesc.Builder pkg : installableComponent.getRequiredSdkPackages()) {
                if (pkg == null) continue;
                packages.add(pkg.create().getInstallId());
            }
        }
        installContext.run(new InstallComponentsOperation(installContext, sdk, packages), progressRatio);
        for (InstallableComponent installableComponent : selectedComponents) {
            installableComponent.configure(installContext, sdk);
        }
    }

    private static void setSdkInPreferences(final File sdk) {
        final Application application = ApplicationManager.getApplication();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                application.runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        DefaultSdks.setDefaultAndroidHome(sdk, null);
                        AndroidFirstRunPersistentData.getInstance().markSdkUpToDate();
                    }
                });
            }
        }, application.getAnyModalityState());
    }

    @Override
    protected void init() {
        InstallerData data = InstallerData.get(this.myState);
        String location = null;
        if (!data.exists()) {
            this.myInstallationTypeWizardStep = new InstallationTypeWizardStep(KEY_CUSTOM_INSTALL);
            location = data.getAndroidDest();
            this.addStep(this.myInstallationTypeWizardStep);
        }
        if (StringUtil.isEmptyOrSpaces(location)) {
            location = FirstRunWizardDefaults.getDefaultSdkLocation();
        }
        this.myState.put(KEY_SDK_INSTALL_LOCATION, location);
        this.mySdkComponentsStep = new SdkComponentsStep(COMPONENTS, KEY_CUSTOM_INSTALL, KEY_SDK_INSTALL_LOCATION);
        this.addStep(this.mySdkComponentsStep);
        for (InstallableComponent component : COMPONENTS) {
            component.init(this.myState, this.myProgressStep);
            for (DynamicWizardStep step : component.createSteps()) {
                this.addStep(step);
            }
        }
        if (SystemInfo.isLinux && !data.exists()) {
            this.addStep(new LinuxHaxmInfoStep());
        }
    }

    @Override
    @NotNull
    public String getPathName() {
        if ("Setup Android Studio Components" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallComponentsPath", "getPathName"));
        }
        return "Setup Android Studio Components";
    }

    @Override
    public void runLongOperation() throws WizardException {
        double INIT_SDK_OPERATION_PROGRESS_SHARE = 0.3;
        double INSTALL_COMPONENTS_OPERATION_PROGRESS_SHARE = 0.7;
        InstallContext installContext = new InstallContext(InstallComponentsPath.createTempDir(), this.myProgressStep);
        File sdk = this.initializeSdk(installContext, 0.3);
        if (sdk != null) {
            InstallComponentsPath.setSdkInPreferences(sdk);
            InstallComponentsPath.setupSdkComponents(installContext, sdk, this.getSelectedComponents(), 0.7);
        }
    }

    private List<InstallableComponent> getSelectedComponents() throws WizardException {
        boolean customInstall = this.myState.getNotNull(KEY_CUSTOM_INSTALL, true);
        ArrayList selectedOperations = Lists.newArrayListWithCapacity((int)COMPONENTS.length);
        for (InstallableComponent component : COMPONENTS) {
            if (customInstall && !this.myState.getNotNull(component.getKey(), true).booleanValue()) continue;
            selectedOperations.add(component);
        }
        return selectedOperations;
    }

    @Nullable
    private File initializeSdk(InstallContext installContext, double progressRatio) throws WizardException {
        SdkManager manager;
        String destinationPath = this.myState.get(KEY_SDK_INSTALL_LOCATION);
        assert (destinationPath != null);
        File destination = new File(destinationPath);
        if (destination.isFile()) {
            throw new WizardException(String.format("Path %s does not point to a directory", destination));
        }
        if (destination.isDirectory() && (manager = SdkManager.createManager((String)destination.getAbsolutePath(), (ILogger)new NullLogger())) != null) {
            installContext.advance(progressRatio);
            return destination;
        }
        File handoffSource = this.getHandoffAndroidSdkSource();
        if (handoffSource == null) {
            return InstallComponentsPath.downloadAndUnzipSdkSeed(installContext, destination, progressRatio) ? destination : null;
        }
        return InstallComponentsPath.mergeRepoIntoDestination(installContext, handoffSource, destination, progressRatio);
    }

    @Nullable
    private File getHandoffAndroidSdkSource() {
        InstallerData data = InstallerData.get(this.myState);
        String androidSrc = data.getAndroidSrc();
        if (!StringUtil.isEmpty((String)androidSrc)) {
            File srcFolder = new File(androidSrc);
            File[] files = srcFolder.listFiles();
            if (srcFolder.isDirectory() && files != null && files.length > 0) {
                return srcFolder;
            }
        }
        return null;
    }

    @Override
    public boolean performFinishingActions() {
        return true;
    }

    @Override
    public boolean isPathVisible() {
        return true;
    }

    public boolean showsStep() {
        return this.isPathVisible() && (InstallComponentsPath.existsAndIsVisible(this.myInstallationTypeWizardStep) || InstallComponentsPath.existsAndIsVisible(this.mySdkComponentsStep));
    }

    private static class InstallComponentsOperation
    implements ThrowableComputable<Void, WizardException> {
        private final InstallContext myContext;
        private final File mySdkLocation;
        private final Set<String> myComponents;

        public InstallComponentsOperation(InstallContext context, File sdkLocation, Set<String> components) {
            this.myContext = context;
            this.mySdkLocation = sdkLocation;
            this.myComponents = components;
        }

        public Void compute() throws WizardException {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            SdkManagerProgressIndicatorIntegration log = new SdkManagerProgressIndicatorIntegration(indicator, this.myContext, this.myComponents.size());
            SdkManager manager = SdkManager.createManager((String)this.mySdkLocation.getAbsolutePath(), (ILogger)log);
            if (manager != null) {
                SdkUpdaterNoWindow updater = new SdkUpdaterNoWindow(manager.getLocation(), manager, (ILogger)log, false, true, null, null);
                updater.updateAll(Lists.newArrayList(this.myComponents), true, false, null);
                return null;
            }
            throw new WizardException("Corrupted SDK installation");
        }
    }

    private static class MergeOperation
    implements ThrowableComputable<File, IOException> {
        private final File myDestination;
        private final File myRepo;
        private final InstallContext myContext;

        public MergeOperation(File destination, File repo, InstallContext context) {
            this.myDestination = destination;
            this.myRepo = repo;
            this.myContext = context;
        }

        public File compute() throws IOException {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            indicator.setText("Installing Android SDK");
            indicator.setIndeterminate(true);
            FileUtil.ensureExists((File)this.myDestination);
            if (!FileUtil.filesEqual((File)this.myDestination.getCanonicalFile(), (File)this.myRepo.getCanonicalFile())) {
                SdkMerger.mergeSdks(this.myRepo, this.myDestination, indicator);
            }
            this.myContext.print(String.format("Android SDK was installed to %s", this.myDestination), ConsoleViewContentType.SYSTEM_OUTPUT);
            return this.myDestination;
        }
    }
}

