/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.wizard.ComboBoxItem;
import com.android.tools.idea.wizard.FormFactorUtils;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FormFactorApiComboBox
extends JComboBox {
    private static final Logger LOG = Logger.getInstance(FormFactorApiComboBox.class);
    private static final Set<AndroidVersion> ourInstalledVersions = Sets.newHashSet();
    private static final List<AndroidTargetComboBoxItem> ourTargets = Lists.newArrayList();
    private static IAndroidTarget ourHighestInstalledApiTarget;
    @NotNull
    private FormFactorUtils.FormFactor myFormFactor;
    private IPkgDesc myInstallRequest;
    private ScopedStateStore.Key<String> myBuildApiKey;
    private ScopedStateStore.Key<Integer> myBuildApiLevelKey;
    private ScopedStateStore.Key<Integer> myTargetApiLevelKey;
    private ScopedStateStore.Key<String> myTargetApiStringKey;
    private ScopedStateStore.Key<AndroidTargetComboBoxItem> myTargetComboBoxKey;
    private ScopedStateStore.Key<Boolean> myInclusionKey;
    static final ScopedDataBinder.ComponentBinding<AndroidTargetComboBoxItem, JComboBox> TARGET_COMBO_BINDING;

    public FormFactorApiComboBox(@NotNull FormFactorUtils.FormFactor formFactor, int minSdkLevel) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorApiComboBox", "<init>"));
        }
        this.init(formFactor, minSdkLevel);
    }

    public FormFactorApiComboBox() {
    }

    public void init(@NotNull FormFactorUtils.FormFactor formFactor, int minSdkLevel) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorApiComboBox", "init"));
        }
        this.myFormFactor = formFactor;
        FormFactorApiComboBox.loadTargets();
        FormFactorApiComboBox.loadInstalledVersions();
        this.myBuildApiKey = FormFactorUtils.getBuildApiKey(formFactor);
        this.myBuildApiLevelKey = FormFactorUtils.getBuildApiLevelKey(formFactor);
        this.myTargetApiLevelKey = FormFactorUtils.getTargetApiLevelKey(formFactor);
        this.myTargetApiStringKey = FormFactorUtils.getTargetApiStringKey(formFactor);
        this.myTargetComboBoxKey = FormFactorUtils.getTargetComboBoxKey(formFactor);
        this.myInclusionKey = FormFactorUtils.getInclusionKey(formFactor);
        this.populateComboBox(formFactor, minSdkLevel);
        this.loadSavedApi();
    }

    public void register(@NotNull ScopedDataBinder binder) {
        if (binder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binder", "com/android/tools/idea/wizard/FormFactorApiComboBox", "register"));
        }
        assert (this.myFormFactor != null) : "register() called on FormFactorApiComboBox before init()";
        binder.register(FormFactorUtils.getTargetComboBoxKey(this.myFormFactor), this, TARGET_COMBO_BINDING);
    }

    public void loadSavedApi() {
        String savedApiLevel = PropertiesComponent.getInstance().getValue(FormFactorUtils.getPropertiesComponentMinSdkKey(this.myFormFactor), Integer.toString(this.myFormFactor.defaultApi));
        this.setSelectedItem(savedApiLevel);
        if (this.getSelectedIndex() < 0 && this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void deriveValues(@NotNull ScopedStateStore stateStore, @NotNull Set<ScopedStateStore.Key> modified) {
        if (stateStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateStore", "com/android/tools/idea/wizard/FormFactorApiComboBox", "deriveValues"));
        }
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "com/android/tools/idea/wizard/FormFactorApiComboBox", "deriveValues"));
        }
        if (modified.contains(this.myTargetComboBoxKey) || modified.contains(this.myInclusionKey)) {
            AndroidSdkData sdkData;
            AndroidTargetComboBoxItem targetItem = stateStore.get(this.myTargetComboBoxKey);
            if (targetItem == null) {
                return;
            }
            stateStore.put(FormFactorUtils.getMinApiKey(this.myFormFactor), targetItem.id.toString());
            stateStore.put(FormFactorUtils.getMinApiLevelKey(this.myFormFactor), targetItem.apiLevel);
            IAndroidTarget target = targetItem.target;
            if (target != null && (target.getVersion().isPreview() || !target.isPlatform())) {
                this.populateApiLevels(targetItem.apiLevel, target, stateStore);
            } else {
                int targetApiLevel = ourHighestInstalledApiTarget != null ? ourHighestInstalledApiTarget.getVersion().getFeatureLevel() : 0;
                this.populateApiLevels(targetApiLevel, ourHighestInstalledApiTarget, stateStore);
            }
            if (this.myInstallRequest != null) {
                stateStore.listRemove(WizardConstants.INSTALL_REQUESTS_KEY, this.myInstallRequest);
            }
            if (target == null) {
                AndroidVersion androidVersion = new AndroidVersion(targetItem.apiLevel, null);
                if (ourHighestInstalledApiTarget == null || androidVersion.getApiLevel() > ourHighestInstalledApiTarget.getVersion().getApiLevel() && !ourInstalledVersions.contains(androidVersion) && stateStore.get(this.myInclusionKey).booleanValue()) {
                    IPkgDesc platformDescription = PkgDesc.Builder.newPlatform((AndroidVersion)androidVersion, (MajorRevision)new MajorRevision(1), (FullRevision)FullRevision.NOT_SPECIFIED).create();
                    stateStore.listPush(WizardConstants.INSTALL_REQUESTS_KEY, platformDescription);
                    this.myInstallRequest = platformDescription;
                    this.populateApiLevels(androidVersion.getApiLevel(), ourHighestInstalledApiTarget, stateStore);
                }
            }
            PropertiesComponent.getInstance().setValue(FormFactorUtils.getPropertiesComponentMinSdkKey(this.myFormFactor), targetItem.id.toString());
            String javaVersion = null;
            if (target != null && target.getVersion().getFeatureLevel() >= 21 && (sdkData = AndroidSdkUtils.tryToChooseAndroidSdk()) != null) {
                JavaSdkVersion version;
                JavaSdk jdk = JavaSdk.getInstance();
                Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)jdk);
                if (sdk != null && (version = jdk.getVersion(sdk)) != null && version.isAtLeast(JavaSdkVersion.JDK_1_7)) {
                    javaVersion = JavaSdkVersion.JDK_1_7.getDescription();
                }
            }
            stateStore.put(FormFactorUtils.getLanguageLevelKey(this.myFormFactor), javaVersion);
        }
    }

    public void setSelectedItem(String item) {
        ScopedDataBinder.setSelectedItem(this, item);
    }

    private void populateComboBox(@NotNull FormFactorUtils.FormFactor formFactor, int minSdk) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorApiComboBox", "populateComboBox"));
        }
        for (AndroidTargetComboBoxItem target : Iterables.filter(ourTargets, FormFactorUtils.getMinSdkComboBoxFilter(formFactor, minSdk))) {
            if (target.apiLevel < minSdk && (target.target == null || !target.target.getVersion().isPreview())) continue;
            this.addItem(target);
        }
    }

    private static void loadTargets() {
        ourTargets.clear();
        IAndroidTarget[] targets = FormFactorApiComboBox.getCompilationTargets();
        if (AndroidSdkUtils.isAndroidSdkAvailable()) {
            String[] knownVersions = TemplateUtils.getKnownVersions();
            for (int i = 0; i < knownVersions.length; ++i) {
                AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(knownVersions[i], i + 1);
                ourTargets.add(targetInfo);
            }
        }
        for (IAndroidTarget target : targets) {
            if (!target.getVersion().isPreview() && (target.getOptionalLibraries() == null || target.getOptionalLibraries().length <= 0)) continue;
            AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(target);
            ourTargets.add(targetInfo);
        }
    }

    public static void loadInstalledVersions() {
        IAndroidTarget[] targets = FormFactorApiComboBox.getCompilationTargets();
        IAndroidTarget highestInstalledTarget = null;
        ourInstalledVersions.clear();
        for (IAndroidTarget target : targets) {
            if (highestInstalledTarget == null || target.getVersion().getFeatureLevel() > highestInstalledTarget.getVersion().getFeatureLevel() && !target.getVersion().isPreview()) {
                highestInstalledTarget = target;
            }
            if (!target.getVersion().isPreview() && (target.getOptionalLibraries() == null || target.getOptionalLibraries().length <= 0)) continue;
            AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(target);
            ourInstalledVersions.add(targetInfo.target.getVersion());
        }
        ourHighestInstalledApiTarget = highestInstalledTarget;
    }

    @NotNull
    private static IAndroidTarget[] getCompilationTargets() {
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (sdkData == null) {
            IAndroidTarget[] iAndroidTargetArray = new IAndroidTarget[]{};
            if (iAndroidTargetArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/FormFactorApiComboBox", "getCompilationTargets"));
            }
            return iAndroidTargetArray;
        }
        IAndroidTarget[] iAndroidTargetArray = FormFactorApiComboBox.getCompilationTargets(sdkData);
        if (iAndroidTargetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/FormFactorApiComboBox", "getCompilationTargets"));
        }
        return iAndroidTargetArray;
    }

    @NotNull
    public static IAndroidTarget[] getCompilationTargets(@NotNull AndroidSdkData sdkData) {
        if (sdkData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkData", "com/android/tools/idea/wizard/FormFactorApiComboBox", "getCompilationTargets"));
        }
        IAndroidTarget[] targets = sdkData.getTargets();
        ArrayList<IAndroidTarget> list = new ArrayList<IAndroidTarget>();
        for (IAndroidTarget target : targets) {
            if (!target.isPlatform() && (target.getOptionalLibraries() == null || target.getOptionalLibraries().length == 0)) continue;
            list.add(target);
        }
        IAndroidTarget[] iAndroidTargetArray = list.toArray(new IAndroidTarget[list.size()]);
        if (iAndroidTargetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/FormFactorApiComboBox", "getCompilationTargets"));
        }
        return iAndroidTargetArray;
    }

    public void populateApiLevels(int apiLevel, @Nullable IAndroidTarget apiTarget, @NotNull ScopedStateStore state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/wizard/FormFactorApiComboBox", "populateApiLevels"));
        }
        if (apiLevel >= 1) {
            if (apiTarget == null) {
                state.put(this.myBuildApiKey, Integer.toString(apiLevel));
            } else if (apiTarget.getOptionalLibraries() != null) {
                state.put(this.myBuildApiKey, AndroidTargetHash.getTargetHashString((IAndroidTarget)apiTarget));
            } else {
                state.put(this.myBuildApiKey, TemplateMetadata.getBuildApiString(apiTarget.getVersion()));
            }
            state.put(this.myBuildApiLevelKey, apiLevel);
            if (apiLevel >= 21 || apiTarget != null && apiTarget.getVersion().isPreview()) {
                state.put(this.myTargetApiLevelKey, apiLevel);
                if (apiTarget != null) {
                    state.put(this.myTargetApiStringKey, apiTarget.getVersion().getApiString());
                } else {
                    state.put(this.myTargetApiStringKey, Integer.toString(apiLevel));
                }
            } else if (ourHighestInstalledApiTarget != null) {
                state.put(this.myTargetApiLevelKey, ourHighestInstalledApiTarget.getVersion().getApiLevel());
                state.put(this.myTargetApiStringKey, ourHighestInstalledApiTarget.getVersion().getApiString());
            }
            if (apiTarget != null && apiLevel > apiTarget.getVersion().getApiLevel()) {
                state.put(this.myBuildApiKey, Integer.toString(apiLevel));
                state.put(this.myTargetApiStringKey, Integer.toString(apiLevel));
            }
        }
    }

    static {
        TARGET_COMBO_BINDING = new ScopedDataBinder.ComponentBinding<AndroidTargetComboBoxItem, JComboBox>(){

            @Override
            public void setValue(@Nullable AndroidTargetComboBoxItem newValue, @NotNull JComboBox component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/FormFactorApiComboBox$1", "setValue"));
                }
                component.setSelectedItem(newValue);
            }

            @Override
            @Nullable
            public AndroidTargetComboBoxItem getValue(@NotNull JComboBox component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/FormFactorApiComboBox$1", "getValue"));
                }
                return (AndroidTargetComboBoxItem)component.getItemAt(component.getSelectedIndex());
            }

            @Override
            public void addActionListener(@NotNull ActionListener listener, @NotNull JComboBox component) {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/wizard/FormFactorApiComboBox$1", "addActionListener"));
                }
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/FormFactorApiComboBox$1", "addActionListener"));
                }
                component.addActionListener(listener);
            }
        };
    }

    public static class AndroidTargetComboBoxItem
    extends ComboBoxItem {
        public int apiLevel;
        public IAndroidTarget target;

        public AndroidTargetComboBoxItem(@NotNull String label, int apiLevel) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/wizard/FormFactorApiComboBox$AndroidTargetComboBoxItem", "<init>"));
            }
            super(Integer.toString(apiLevel), label, 1, 1);
            this.apiLevel = -1;
            this.target = null;
            this.apiLevel = apiLevel;
        }

        public AndroidTargetComboBoxItem(@NotNull IAndroidTarget target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/wizard/FormFactorApiComboBox$AndroidTargetComboBoxItem", "<init>"));
            }
            super(AndroidTargetComboBoxItem.getId(target), AndroidTargetComboBoxItem.getLabel(target), 1, 1);
            this.apiLevel = -1;
            this.target = null;
            this.target = target;
            this.apiLevel = target.getVersion().getFeatureLevel();
        }

        @NotNull
        private static String getLabel(@NotNull IAndroidTarget target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/wizard/FormFactorApiComboBox$AndroidTargetComboBoxItem", "getLabel"));
            }
            if (target.isPlatform() && target.getVersion().getApiLevel() <= 21) {
                if (target.getVersion().isPreview()) {
                    String string = "API " + Integer.toString(target.getVersion().getApiLevel()) + "+: " + target.getName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/FormFactorApiComboBox$AndroidTargetComboBoxItem", "getLabel"));
                    }
                    return string;
                }
                String name = SdkVersionInfo.getAndroidName((int)target.getVersion().getApiLevel());
                if (name == null) {
                    String string = "API " + Integer.toString(target.getVersion().getApiLevel());
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/FormFactorApiComboBox$AndroidTargetComboBoxItem", "getLabel"));
                    }
                    return string;
                }
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/FormFactorApiComboBox$AndroidTargetComboBoxItem", "getLabel"));
                }
                return string;
            }
            String string = AndroidSdkUtils.getTargetLabel(target);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/FormFactorApiComboBox$AndroidTargetComboBoxItem", "getLabel"));
            }
            return string;
        }

        @NotNull
        private static String getId(@NotNull IAndroidTarget target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/wizard/FormFactorApiComboBox$AndroidTargetComboBoxItem", "getId"));
            }
            String string = target.getVersion().getApiString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/FormFactorApiComboBox$AndroidTargetComboBoxItem", "getId"));
            }
            return string;
        }

        @Override
        public String toString() {
            return this.label;
        }
    }
}

