/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.ResourceNameValidator;
import com.intellij.CommonBundle;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.DeviceConfiguratorPanel;
import org.jetbrains.android.uipreview.InvalidOptionValueException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceFileDialog
extends DialogWrapper {
    private JTextField myFileNameField;
    private TemplateKindCombo myResourceTypeCombo;
    private JPanel myPanel;
    private JLabel myUpDownHint;
    private JLabel myResTypeLabel;
    private JPanel myDeviceConfiguratorWrapper;
    private JBLabel myErrorLabel;
    private JTextField myDirectoryNameTextField;
    private JPanel myRootElementFieldWrapper;
    private JBLabel myRootElementLabel;
    private JLabel myFileNameLabel;
    private ModulesComboBox myModuleCombo;
    private JBLabel myModuleLabel;
    private TextFieldWithAutoCompletion<String> myRootElementField;
    private InputValidator myValidator;
    private final Map<String, CreateTypedResourceFileAction> myResType2ActionMap;
    private final DeviceConfiguratorPanel myDeviceConfiguratorPanel;
    private final AndroidFacet myFacet;
    private final ResourceType myPredefinedResourceType;

    public CreateResourceFileDialog(@NotNull AndroidFacet facet, Collection<CreateTypedResourceFileAction> actions, @Nullable ResourceType predefinedResourceType, @Nullable String predefinedFileName, @Nullable String predefinedRootElement, @Nullable FolderConfiguration predefinedConfig, boolean chooseFileName, @NotNull Module module, boolean chooseModule) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/actions/CreateResourceFileDialog", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/actions/CreateResourceFileDialog", "<init>"));
        }
        super(facet.getModule().getProject());
        this.$$$setupUI$$$();
        this.myResType2ActionMap = new HashMap();
        this.myFacet = facet;
        this.myPredefinedResourceType = predefinedResourceType;
        this.myResTypeLabel.setLabelFor((Component)this.myResourceTypeCombo);
        this.myResourceTypeCombo.registerUpDownHint((JComponent)this.myFileNameField);
        this.myUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        CreateTypedResourceFileAction[] actionArray = actions.toArray(new CreateTypedResourceFileAction[actions.size()]);
        Arrays.sort(actionArray, new Comparator<CreateTypedResourceFileAction>(){

            @Override
            public int compare(CreateTypedResourceFileAction a1, CreateTypedResourceFileAction a2) {
                return a1.toString().compareTo(a2.toString());
            }
        });
        String selectedTemplate = null;
        for (CreateTypedResourceFileAction action : actionArray) {
            String resType = action.getResourceType();
            assert (!this.myResType2ActionMap.containsKey(resType));
            this.myResType2ActionMap.put(resType, action);
            this.myResourceTypeCombo.addItem(action.toString(), null, resType);
            if (predefinedResourceType == null || !predefinedResourceType.getName().equals(resType)) continue;
            selectedTemplate = resType;
        }
        this.myDeviceConfiguratorPanel = new DeviceConfiguratorPanel(){

            @Override
            public void applyEditors() {
                try {
                    ResourceFolderType resFolderType;
                    String resTypeStr;
                    this.doApplyEditors();
                    FolderConfiguration config = CreateResourceFileDialog.this.myDeviceConfiguratorPanel.getConfiguration();
                    CreateTypedResourceFileAction selectedAction = CreateResourceFileDialog.this.getSelectedAction();
                    CreateResourceFileDialog.this.myErrorLabel.setText("");
                    CreateResourceFileDialog.this.myDirectoryNameTextField.setText("");
                    if (selectedAction != null && (resTypeStr = selectedAction.getResourceType()) != null && (resFolderType = ResourceFolderType.getTypeByName((String)resTypeStr)) != null) {
                        CreateResourceFileDialog.this.myDirectoryNameTextField.setText(config.getFolderName(resFolderType));
                    }
                }
                catch (InvalidOptionValueException e) {
                    CreateResourceFileDialog.this.myErrorLabel.setText("<html><body><font color=\"red\">" + e.getMessage() + "</font></body></html>");
                    CreateResourceFileDialog.this.myDirectoryNameTextField.setText("");
                }
                CreateResourceFileDialog.this.updateOkAction();
            }
        };
        if (predefinedConfig != null) {
            this.myDeviceConfiguratorPanel.init(predefinedConfig);
        }
        this.myResourceTypeCombo.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateResourceFileDialog.this.myDeviceConfiguratorPanel.applyEditors();
                CreateResourceFileDialog.this.updateRootElementTextField();
            }
        });
        if (predefinedResourceType != null && selectedTemplate != null) {
            boolean v = predefinedResourceType == ResourceType.LAYOUT;
            this.myRootElementLabel.setVisible(v);
            this.myRootElementFieldWrapper.setVisible(v);
            this.myResTypeLabel.setVisible(false);
            this.myResourceTypeCombo.setVisible(false);
            this.myUpDownHint.setVisible(false);
            this.myResourceTypeCombo.setSelectedName(selectedTemplate);
        }
        if (chooseFileName) {
            predefinedFileName = ResourceHelper.prependResourcePrefix(module, predefinedFileName);
        }
        boolean validateImmediately = false;
        if (predefinedFileName != null && this.getNameError(predefinedFileName) != null) {
            chooseFileName = true;
            validateImmediately = true;
        }
        if (predefinedFileName != null) {
            if (!chooseFileName) {
                this.myFileNameField.setVisible(false);
                this.myFileNameLabel.setVisible(false);
            }
            this.myFileNameField.setText(predefinedFileName);
        }
        HashSet modulesSet = new HashSet();
        modulesSet.add(module);
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(module, true)) {
            modulesSet.add(depFacet.getModule());
        }
        this.myModuleCombo.setModules((Collection)modulesSet);
        if (!chooseModule || modulesSet.size() == 1) {
            this.myModuleLabel.setVisible(false);
            this.myModuleCombo.setVisible(false);
        }
        this.myModuleCombo.setSelectedModule(module);
        this.myDeviceConfiguratorPanel.updateAll();
        this.myDeviceConfiguratorWrapper.add((Component)this.myDeviceConfiguratorPanel, "Center");
        this.updateOkAction();
        this.updateRootElementTextField();
        if (predefinedRootElement != null) {
            this.myRootElementLabel.setVisible(false);
            this.myRootElementFieldWrapper.setVisible(false);
            this.myRootElementField.setText(predefinedRootElement);
        }
        this.init();
        this.setTitle(AndroidBundle.message("new.resource.dialog.title", new Object[0]));
        this.myFileNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                CreateResourceFileDialog.this.validateName();
            }
        });
        this.myResourceTypeCombo.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateResourceFileDialog.this.validateName();
            }
        });
        if (validateImmediately) {
            this.validateName();
        }
    }

    private void updateOkAction() {
        boolean enabled = this.myDirectoryNameTextField.getText().length() > 0;
        enabled = enabled && this.getNameError(this.myFileNameField.getText()) == null;
        this.setOKActionEnabled(enabled);
    }

    @Nullable
    private String getNameError(@NotNull String fileName) {
        ResourceFolderType type;
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/android/actions/CreateResourceFileDialog", "getNameError"));
        }
        String typeName = this.myResourceTypeCombo.getSelectedName();
        if (typeName != null && (type = ResourceFolderType.getFolderType((String)typeName)) != null) {
            ResourceNameValidator validator = ResourceNameValidator.create(true, type);
            return validator.getErrorText(fileName);
        }
        return null;
    }

    private void validateName() {
        this.setErrorText(this.getNameError(this.myFileNameField.getText()));
        this.updateOkAction();
    }

    private void updateRootElementTextField() {
        CreateTypedResourceFileAction action = this.getSelectedAction();
        if (action != null) {
            List<String> allowedTagNames = action.getSortedAllowedTagNames(this.myFacet);
            this.myRootElementField = new TextFieldWithAutoCompletion(this.myFacet.getModule().getProject(), (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletion.StringsCompletionProvider(allowedTagNames, null), true, null);
            this.myRootElementField.setEnabled(allowedTagNames.size() > 1);
            this.myRootElementField.setText(!action.isChooseTagName() && this.myPredefinedResourceType != ResourceType.LAYOUT ? action.getDefaultRootTag() : "");
            this.myRootElementFieldWrapper.removeAll();
            this.myRootElementFieldWrapper.add((Component)this.myRootElementField, "Center");
            this.myRootElementLabel.setLabelFor(this.myRootElementField);
        }
    }

    @NotNull
    public String getFileName() {
        String string = this.myFileNameField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileDialog", "getFileName"));
        }
        return string;
    }

    @Nullable
    protected InputValidator createValidator(@NotNull String subdirName) {
        if (subdirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subdirName", "org/jetbrains/android/actions/CreateResourceFileDialog", "createValidator"));
        }
        return null;
    }

    protected void doOKAction() {
        String fileName = this.myFileNameField.getText().trim();
        CreateTypedResourceFileAction action = this.getSelectedAction();
        assert (action != null);
        if (fileName.length() == 0) {
            Messages.showErrorDialog((Component)this.myPanel, (String)AndroidBundle.message("file.name.not.specified.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        if (!action.isChooseTagName() && this.getRootElement().length() == 0) {
            Messages.showErrorDialog((Component)this.myPanel, (String)AndroidBundle.message("root.element.not.specified.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        String subdirName = this.getSubdirName();
        if (subdirName.length() == 0) {
            Messages.showErrorDialog((Component)this.myPanel, (String)AndroidBundle.message("directory.not.specified.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        String errorMessage = this.getNameError(fileName);
        if (errorMessage != null) {
            Messages.showErrorDialog((Component)this.myPanel, (String)errorMessage, (String)CommonBundle.getErrorTitle());
            return;
        }
        this.myValidator = this.createValidator(subdirName);
        if (this.myValidator == null || this.myValidator.checkInput(fileName) && this.myValidator.canClose(fileName)) {
            super.doOKAction();
        }
    }

    protected String getDimensionServiceKey() {
        return "AndroidCreateResourceFileDialog";
    }

    @NotNull
    public Module getSelectedModule() {
        Module module = this.myModuleCombo.getSelectedModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileDialog", "getSelectedModule"));
        }
        return module;
    }

    @NotNull
    public String getSubdirName() {
        String string = this.myDirectoryNameTextField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileDialog", "getSubdirName"));
        }
        return string;
    }

    @NotNull
    protected String getRootElement() {
        String string = this.myRootElementField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileDialog", "getRootElement"));
        }
        return string;
    }

    public InputValidator getValidator() {
        return this.myValidator;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        String name = this.myFileNameField.getText();
        if (name.length() == 0 || name.equals(ResourceHelper.prependResourcePrefix(this.getSelectedModule(), null)) || this.getNameError(name) != null) {
            return this.myFileNameField;
        }
        if (this.myResourceTypeCombo.isVisible()) {
            return this.myResourceTypeCombo;
        }
        if (this.myModuleCombo.isVisible()) {
            return this.myModuleCombo;
        }
        if (this.myRootElementFieldWrapper.isVisible()) {
            return this.myRootElementField;
        }
        return this.myDirectoryNameTextField;
    }

    public CreateTypedResourceFileAction getSelectedAction() {
        return this.myResType2ActionMap.get(this.myResourceTypeCombo.getSelectedName());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ModulesComboBox modulesComboBox;
        JBLabel jBLabel;
        JPanel jPanel;
        JBLabel jBLabel2;
        JTextField jTextField;
        JBLabel jBLabel3;
        JPanel jPanel2;
        TemplateKindCombo templateKindCombo;
        JLabel jLabel;
        JLabel jLabel2;
        JTextField jTextField2;
        JLabel jLabel3;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(7, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setPreferredSize(new Dimension(800, 400));
        this.myFileNameLabel = jLabel3 = new JLabel();
        jLabel3.setText("File name:");
        jLabel3.setDisplayedMnemonic('F');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myFileNameField = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myResTypeLabel = jLabel2 = new JLabel();
        jLabel2.setText("Resource type:");
        jLabel2.setDisplayedMnemonic('R');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUpDownHint = jLabel = new JLabel();
        jLabel.setToolTipText("Pressing Up or Down arrows while in editor changes the kind");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myResourceTypeCombo = templateKindCombo = new TemplateKindCombo();
        jPanel3.add((Component)templateKindCombo, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDeviceConfiguratorWrapper = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myErrorLabel = jBLabel3 = new JBLabel();
        jPanel3.add((Component)jBLabel3, new GridConstraints(6, 0, 1, 3, 0, 3, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Directory name:");
        jBLabel4.setDisplayedMnemonic('Y');
        jBLabel4.setDisplayedMnemonicIndex(8);
        jPanel3.add((Component)jBLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoryNameTextField = jTextField = new JTextField();
        jTextField.setEditable(true);
        ((Component)jTextField).setEnabled(true);
        jPanel3.add((Component)jTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myRootElementLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Root element:");
        jBLabel2.setDisplayedMnemonic('E');
        jBLabel2.setDisplayedMnemonicIndex(5);
        jPanel3.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRootElementFieldWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myModuleLabel = jBLabel = new JBLabel();
        jBLabel.setText("Module:");
        jBLabel.setDisplayedMnemonic('M');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleCombo = modulesComboBox = new ModulesComboBox();
        jPanel3.add((Component)modulesComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel3.setLabelFor(jTextField2);
        jBLabel4.setLabelFor(jTextField);
        jBLabel.setLabelFor((Component)modulesComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

