/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesUtil {
    public static final Pattern LOCALE_PATTERN = Pattern.compile("(_[a-zA-Z]{2,8}(_[a-zA-Z]{2}|[0-9]{3})?(_[\\w\\-]+)?)\\.[^_]+$");
    public static final Set<Character> BASE_NAME_BORDER_CHAR = ContainerUtil.newHashSet((Object[])new Character[]{Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('.')});

    @Deprecated
    public static boolean isPropertyComplete(Project project, ResourceBundle resourceBundle, String propertyName) {
        return PropertiesUtil.isPropertyComplete(resourceBundle, propertyName);
    }

    public static boolean isPropertyComplete(ResourceBundle resourceBundle, String propertyName) {
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            if (propertiesFile.findPropertyByKey(propertyName) != null) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static String getDefaultBaseName(Collection<PropertiesFile> files) {
        String commonPrefix = null;
        for (PropertiesFile file : files) {
            String baseName = file.getVirtualFile().getNameWithoutExtension();
            if (commonPrefix == null) {
                commonPrefix = baseName;
                continue;
            }
            if (!(commonPrefix = StringUtil.commonPrefix((String)commonPrefix, (String)baseName)).isEmpty()) continue;
            break;
        }
        assert (commonPrefix != null);
        if (!commonPrefix.isEmpty() && BASE_NAME_BORDER_CHAR.contains(Character.valueOf(commonPrefix.charAt(commonPrefix.length() - 1)))) {
            commonPrefix = commonPrefix.substring(0, commonPrefix.length() - 1);
        }
        String string = commonPrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "getDefaultBaseName"));
        }
        return string;
    }

    @NotNull
    public static String getDefaultBaseName(@NotNull VirtualFile file) {
        MatchResult matchResult;
        String[] splitted;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/properties/PropertiesUtil", "getDefaultBaseName"));
        }
        String name = file.getName();
        Matcher matcher = LOCALE_PATTERN.matcher(name);
        String baseNameWithExtension = matcher.find() ? ((splitted = (matchResult = matcher.toMatchResult()).group(1).split("_")).length > 1 ? name.substring(0, matchResult.start(1)) + name.substring(matchResult.end(1)) : name) : name;
        String string = FileUtil.getNameWithoutExtension((String)baseNameWithExtension);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "getDefaultBaseName"));
        }
        return string;
    }

    @Nullable
    public static PropertiesFile getParent(PropertiesFile file, List<PropertiesFile> candidates) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String name = virtualFile.getNameWithoutExtension();
        String[] parts = name.split("_");
        if (parts.length == 1) {
            return null;
        }
        List<String> partsList = Arrays.asList(parts);
        for (int i = parts.length - 1; i >= 1; --i) {
            String parentName = StringUtil.join(partsList.subList(0, i), (String)"_") + "." + virtualFile.getExtension();
            for (PropertiesFile candidate : candidates) {
                if (!parentName.equals(candidate.getName())) continue;
                return candidate;
            }
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static List<IProperty> findAllProperties(Project project, @NotNull ResourceBundle resourceBundle, String key) {
        if (resourceBundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundle", "com/intellij/lang/properties/PropertiesUtil", "findAllProperties"));
        }
        SmartList result = new SmartList();
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            result.addAll(propertiesFile.findPropertiesByKey(key));
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "findAllProperties"));
        }
        return smartList;
    }

    public static List<IProperty> findAllProperties(@NotNull ResourceBundle resourceBundle, String key) {
        if (resourceBundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundle", "com/intellij/lang/properties/PropertiesUtil", "findAllProperties"));
        }
        SmartList result = new SmartList();
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            result.addAll(propertiesFile.findPropertiesByKey(key));
        }
        return result;
    }

    public static boolean isUnescapedBackSlashAtTheEnd(String text) {
        boolean result = false;
        for (int i = text.length() - 1; i >= 0 && text.charAt(i) == '\\'; --i) {
            result = !result;
        }
        return result;
    }

    @Nullable
    public static String getPackageQualifiedName(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/lang/properties/PropertiesUtil", "getPackageQualifiedName"));
        }
        return ProjectRootManager.getInstance((Project)directory.getProject()).getFileIndex().getPackageNameByDirectory(directory.getVirtualFile());
    }
}

