/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.server.MavenServerIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.MavenServerSettings;

public interface MavenServerIndexer
extends Remote {
    public static final String SEARCH_TERM_COORDINATES = "u";
    public static final String SEARCH_TERM_CLASS_NAMES = "c";

    public int createIndex(@NotNull String var1, @NotNull String var2, @Nullable File var3, @Nullable String var4, @NotNull File var5) throws RemoteException, MavenServerIndexerException;

    public void releaseIndex(int var1) throws RemoteException, MavenServerIndexerException;

    public int getIndexCount() throws RemoteException;

    public void updateIndex(int var1, MavenServerSettings var2, MavenServerProgressIndicator var3) throws RemoteException, MavenServerIndexerException, MavenServerProcessCanceledException;

    public void processArtifacts(int var1, MavenServerIndicesProcessor var2) throws RemoteException, MavenServerIndexerException;

    public MavenId addArtifact(int var1, File var2) throws RemoteException, MavenServerIndexerException;

    public Set<MavenArtifactInfo> search(int var1, Query var2, int var3) throws RemoteException, MavenServerIndexerException;

    public Collection<MavenArchetype> getArchetypes() throws RemoteException;

    public void release() throws RemoteException;
}

