/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateStringLiteral;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.refactoring.util.occurrences.BaseOccurrenceManager;
import com.intellij.refactoring.util.occurrences.OccurrenceFilter;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateStringLiteralInspection
extends BaseLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.DuplicateStringLiteralInspection");
    public int MIN_STRING_LENGTH = 5;
    public boolean IGNORE_PROPERTY_KEYS = false;
    @NonNls
    private static final String BR = "<br>";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitExpression((PsiExpression)expression);
            }

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                DuplicateStringLiteralInspection.this.checkStringLiteralExpression(expression, holder, isOnTheFly);
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.duplicates.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.INTERNATIONALIZATION_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("DuplicateStringLiteralInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection", "getShortName"));
        }
        return "DuplicateStringLiteralInspection";
    }

    private void checkStringLiteralExpression(final @NotNull PsiLiteralExpression originalExpression, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (originalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalExpression", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection", "checkStringLiteralExpression"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection", "checkStringLiteralExpression"));
        }
        Object value = originalExpression.getValue();
        if (!(value instanceof String)) {
            return;
        }
        Project project = holder.getProject();
        if (!this.shouldCheck(project, originalExpression)) {
            return;
        }
        String stringToFind = (String)value;
        if (stringToFind.length() == 0) {
            return;
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)originalExpression.getProject());
        PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance((Project)holder.getFile().getProject());
        List words = StringUtil.getWordsIn((String)stringToFind);
        if (words.isEmpty()) {
            return;
        }
        Collections.sort(words, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        Set resultFiles = null;
        for (String word : words) {
            if (word.length() < this.MIN_STRING_LENGTH) continue;
            progress.checkCanceled();
            THashSet files = new THashSet();
            searchHelper.processAllFilesWithWordInLiterals(word, scope, (Processor)new CommonProcessors.CollectProcessor((Collection)files));
            if (resultFiles == null) {
                resultFiles = files;
            } else {
                resultFiles.retainAll((Collection<?>)files);
            }
            if (!resultFiles.isEmpty()) continue;
            return;
        }
        if (resultFiles == null || resultFiles.isEmpty()) {
            return;
        }
        ArrayList<PsiExpression> foundExpr = new ArrayList<PsiExpression>();
        for (PsiFile file : resultFiles) {
            progress.checkCanceled();
            FileViewProvider viewProvider = file.getViewProvider();
            if (viewProvider.getPsi((Language)JavaLanguage.INSTANCE) == null) continue;
            CharSequence text = viewProvider.getContents();
            char[] textArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)text);
            StringSearcher searcher = new StringSearcher(stringToFind, true, true);
            int offset = LowLevelSearchUtil.searchWord((CharSequence)text, (char[])textArray, (int)0, (int)text.length(), (StringSearcher)searcher, (ProgressIndicator)progress);
            while (offset >= 0) {
                PsiLiteralExpression expression;
                progress.checkCanceled();
                PsiElement element = file.findElementAt(offset);
                if (element != null && element.getParent() instanceof PsiLiteralExpression && (expression = (PsiLiteralExpression)element.getParent()) != originalExpression && Comparing.equal((Object)stringToFind, (Object)expression.getValue()) && this.shouldCheck(project, expression)) {
                    foundExpr.add((PsiExpression)expression);
                }
                offset = LowLevelSearchUtil.searchWord((CharSequence)text, (char[])textArray, (int)(offset + searcher.getPattern().length()), (int)text.length(), (StringSearcher)searcher, (ProgressIndicator)progress);
            }
        }
        if (foundExpr.isEmpty()) {
            return;
        }
        THashSet classes = new THashSet();
        for (PsiExpression aClass : foundExpr) {
            progress.checkCanceled();
            while ((aClass = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class)) != null && ((PsiClass)aClass).getQualifiedName() == null) {
            }
            if (aClass == null) continue;
            classes.add((PsiClass)aClass);
        }
        if (classes.isEmpty()) {
            return;
        }
        List<PsiClass> tenClassesMost = Arrays.asList(classes.toArray(new PsiClass[classes.size()]));
        if (tenClassesMost.size() > 10) {
            tenClassesMost = tenClassesMost.subList(0, 10);
        }
        String classList = isOnTheFly ? StringUtil.join(tenClassesMost, (Function)new Function<PsiClass, String>(){

            public String fun(PsiClass aClass) {
                boolean thisFile = aClass.getContainingFile() == originalExpression.getContainingFile();
                return "&nbsp;&nbsp;&nbsp;'<b>" + aClass.getQualifiedName() + "</b>'" + (thisFile ? " " + InspectionsBundle.message((String)"inspection.duplicates.message.in.this.file", (Object[])new Object[0]) : "");
            }
        }, (String)", <br>") : StringUtil.join(tenClassesMost, (Function)new Function<PsiClass, String>(){

            public String fun(PsiClass aClass) {
                return "'" + aClass.getQualifiedName() + "'";
            }
        }, (String)", ");
        if (classes.size() > tenClassesMost.size()) {
            classList = classList + BR + InspectionsBundle.message((String)"inspection.duplicates.message.more", (Object[])new Object[]{classes.size() - 10});
        }
        String msg = InspectionsBundle.message((String)"inspection.duplicates.message", (Object[])new Object[]{classList});
        SmartList fixes = new SmartList();
        if (isOnTheFly) {
            LocalQuickFix introduceConstFix = DuplicateStringLiteralInspection.createIntroduceConstFix(foundExpr, originalExpression);
            fixes.add(introduceConstFix);
        }
        DuplicateStringLiteralInspection.createReplaceFixes(foundExpr, originalExpression, (Collection<LocalQuickFix>)fixes);
        LocalQuickFix[] array = fixes.toArray(new LocalQuickFix[fixes.size()]);
        holder.registerProblem((PsiElement)originalExpression, msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, array);
    }

    private boolean shouldCheck(@NotNull Project project, @NotNull PsiLiteralExpression expression) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection", "shouldCheck"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection", "shouldCheck"));
        }
        if (this.IGNORE_PROPERTY_KEYS && JavaI18nUtil.mustBePropertyKey(project, expression, (Map<String, Object>)new THashMap())) {
            return false;
        }
        return !SuppressManager.isSuppressedInspectionName((PsiLiteralExpression)expression);
    }

    private static void createReplaceFixes(List<PsiExpression> foundExpr, PsiLiteralExpression originalExpression, Collection<LocalQuickFix> fixes) {
        THashSet constants = new THashSet();
        Iterator<PsiExpression> iterator = foundExpr.iterator();
        while (iterator.hasNext()) {
            PsiField field;
            PsiExpression expression1 = iterator.next();
            PsiElement parent = expression1.getParent();
            if (!(parent instanceof PsiField) || (field = (PsiField)parent).getInitializer() != expression1 || !field.hasModifierProperty("static")) continue;
            constants.add(field);
            iterator.remove();
        }
        for (PsiField constant : constants) {
            boolean isAccessible;
            PsiClass containingClass = constant.getContainingClass();
            if (containingClass == null || !(isAccessible = JavaPsiFacade.getInstance((Project)constant.getProject()).getResolveHelper().isAccessible((PsiMember)constant, (PsiElement)originalExpression, containingClass)) && containingClass.getQualifiedName() == null) continue;
            ReplaceFix replaceQuickFix = new ReplaceFix(constant, originalExpression);
            fixes.add((LocalQuickFix)replaceQuickFix);
        }
    }

    private static LocalQuickFix createIntroduceConstFix(List<PsiExpression> foundExpr, PsiLiteralExpression originalExpression) {
        PsiExpression[] expressions = foundExpr.toArray(new PsiExpression[foundExpr.size() + 1]);
        expressions[foundExpr.size()] = originalExpression;
        return new IntroduceLiteralConstantFix(expressions);
    }

    @Nullable
    private static PsiReferenceExpression createReferenceTo(PsiField constant, PsiLiteralExpression context) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)constant.getProject()).getElementFactory();
        PsiReferenceExpression reference = (PsiReferenceExpression)factory.createExpressionFromText(constant.getName(), (PsiElement)context);
        if (reference.isReferenceTo((PsiElement)constant)) {
            return reference;
        }
        reference = (PsiReferenceExpression)factory.createExpressionFromText("XXX." + constant.getName(), null);
        PsiReferenceExpression classQualifier = (PsiReferenceExpression)reference.getQualifierExpression();
        PsiClass containingClass = constant.getContainingClass();
        if (containingClass.getQualifiedName() == null) {
            return null;
        }
        classQualifier.bindToElement((PsiElement)containingClass);
        if (reference.isReferenceTo((PsiElement)constant)) {
            return reference;
        }
        return null;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    public JComponent createOptionsPanel() {
        final OptionsPanel optionsPanel = new OptionsPanel();
        optionsPanel.myIgnorePropertyKeyExpressions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DuplicateStringLiteralInspection.this.IGNORE_PROPERTY_KEYS = optionsPanel.myIgnorePropertyKeyExpressions.isSelected();
            }
        });
        optionsPanel.myMinStringLengthField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                try {
                    DuplicateStringLiteralInspection.this.MIN_STRING_LENGTH = Integer.parseInt(optionsPanel.myMinStringLengthField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        optionsPanel.myIgnorePropertyKeyExpressions.setSelected(this.IGNORE_PROPERTY_KEYS);
        optionsPanel.myMinStringLengthField.setText(Integer.toString(this.MIN_STRING_LENGTH));
        return optionsPanel.myPanel;
    }

    private static class ReplaceFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final String myText;
        private final SmartPsiElementPointer<PsiField> myConst;

        public ReplaceFix(PsiField constant, PsiLiteralExpression originalExpression) {
            super((PsiElement)originalExpression);
            this.myText = InspectionsBundle.message((String)"inspection.duplicates.replace.quickfix", (Object[])new Object[]{PsiFormatUtil.formatVariable((PsiVariable)constant, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY)});
            this.myConst = SmartPointerManager.getInstance((Project)constant.getProject()).createSmartPsiElementPointer((PsiElement)constant);
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$ReplaceFix", "getText"));
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$ReplaceFix", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$ReplaceFix", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$ReplaceFix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$ReplaceFix", "invoke"));
            }
            PsiLiteralExpression myOriginalExpression = (PsiLiteralExpression)startElement;
            PsiField myConstant = (PsiField)this.myConst.getElement();
            if (myConstant == null) {
                return;
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(myOriginalExpression.getContainingFile())) {
                return;
            }
            try {
                PsiReferenceExpression reference = DuplicateStringLiteralInspection.createReferenceTo(myConstant, myOriginalExpression);
                if (reference != null) {
                    myOriginalExpression.replace((PsiElement)reference);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.duplicates.replace.family.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$ReplaceFix", "getFamilyName"));
            }
            return string;
        }
    }

    private static class IntroduceLiteralConstantFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer[] myExpressions;

        public IntroduceLiteralConstantFix(PsiExpression[] expressions) {
            this.myExpressions = new SmartPsiElementPointer[expressions.length];
            for (int i = 0; i < expressions.length; ++i) {
                PsiExpression expression = expressions[i];
                this.myExpressions[i] = SmartPointerManager.getInstance((Project)expression.getProject()).createSmartPsiElementPointer((PsiElement)expression);
            }
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"introduce.constant.across.the.project", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$IntroduceLiteralConstantFix", "getName"));
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$IntroduceLiteralConstantFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$IntroduceLiteralConstantFix", "applyFix"));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (project.isDisposed()) {
                        return;
                    }
                    ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
                    for (SmartPsiElementPointer ptr : IntroduceLiteralConstantFix.this.myExpressions) {
                        PsiElement element = ptr.getElement();
                        if (element == null) continue;
                        expressions.add((PsiExpression)element);
                    }
                    final PsiExpression[] expressionArray = expressions.toArray(new PsiExpression[expressions.size()]);
                    IntroduceConstantHandler handler = new IntroduceConstantHandler(){

                        protected OccurrenceManager createOccurrenceManager(PsiExpression selectedExpr, PsiClass parentClass) {
                            OccurrenceFilter filter = new OccurrenceFilter(){

                                public boolean isOK(PsiExpression occurrence) {
                                    return true;
                                }
                            };
                            return new BaseOccurrenceManager(filter){

                                protected PsiExpression[] defaultOccurrences() {
                                    return expressionArray;
                                }

                                protected PsiExpression[] findOccurrences() {
                                    return expressionArray;
                                }
                            };
                        }
                    };
                    handler.invoke(project, expressionArray);
                }
            });
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$IntroduceLiteralConstantFix", "getFamilyName"));
            }
            return string;
        }
    }

    public static class OptionsPanel {
        private JTextField myMinStringLengthField;
        private JPanel myPanel;
        private JCheckBox myIgnorePropertyKeyExpressions;

        public OptionsPanel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JTextField jTextField;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myMinStringLengthField = jTextField = new JTextField();
            jTextField.setColumns(3);
            jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(40, -1), null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.duplicates.option"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myIgnorePropertyKeyExpressions = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.duplicates.option.report.propertykey.expressions"));
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 6, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            jLabel.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

