/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.SdkConstants;
import com.android.sdklib.internal.repository.ITaskMonitor;
import java.io.File;
import java.io.IOException;

public class AdbWrapper {
    private final String mAdbOsLocation;
    private final ITaskMonitor mMonitor;

    public AdbWrapper(String osSdkPath, ITaskMonitor monitor) {
        this.mMonitor = monitor;
        if (!osSdkPath.endsWith(File.separator)) {
            osSdkPath = osSdkPath + File.separator;
        }
        this.mAdbOsLocation = osSdkPath + SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + SdkConstants.FN_ADB;
    }

    private void display(String format, Object ... args) {
        this.mMonitor.log(format, args);
    }

    private void displayError(String format, Object ... args) {
        this.mMonitor.logError(format, args);
    }

    public synchronized boolean startAdb() {
        if (this.mAdbOsLocation == null) {
            this.displayError("Error: missing path to ADB.", new Object[0]);
            return false;
        }
        int status = -1;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(this.mAdbOsLocation, "start-server");
            Process proc = processBuilder.start();
            status = proc.waitFor();
        }
        catch (IOException ioe) {
            this.displayError("Unable to run 'adb': %1$s.", ioe.getMessage());
        }
        catch (InterruptedException ie) {
            this.displayError("Unable to run 'adb': %1$s.", ie.getMessage());
        }
        if (status != 0) {
            this.displayError(String.format("Starting ADB server failed (code %d).", status), new Object[0]);
            return false;
        }
        this.display("Starting ADB server succeeded.", new Object[0]);
        return true;
    }

    public synchronized boolean stopAdb() {
        if (this.mAdbOsLocation == null) {
            this.displayError("Error: missing path to ADB.", new Object[0]);
            return false;
        }
        int status = -1;
        try {
            String[] command = new String[]{this.mAdbOsLocation, "kill-server"};
            Process proc = Runtime.getRuntime().exec(command);
            status = proc.waitFor();
        }
        catch (IOException ioe) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (status != 0 && status != 1) {
            this.displayError(String.format("Stopping ADB server failed (code %d).", status), new Object[0]);
            return false;
        }
        this.display("Stopping ADB server succeeded.", new Object[0]);
        return true;
    }
}

