/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.List;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class AnnotationExprent
extends Exprent {
    public static final int ANNOTATION_NORMAL = 1;
    public static final int ANNOTATION_MARKER = 2;
    public static final int ANNOTATION_SINGLE_ELEMENT = 3;
    private String classname;
    private List<String> parnames;
    private List<Exprent> parvalues;

    public AnnotationExprent(String classname, List<String> parnames, List<Exprent> parvalues) {
        this.type = 13;
        this.classname = classname;
        this.parnames = parnames;
        this.parvalues = parvalues;
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        String new_line_separator = DecompilerContext.getNewLineSeparator();
        StringBuilder buffer = new StringBuilder();
        String indstr = InterpreterUtil.getIndentString(indent);
        buffer.append(indstr);
        buffer.append("@");
        buffer.append(DecompilerContext.getImportCollector().getShortName(ExprProcessor.buildJavaClassName(this.classname)));
        if (!this.parnames.isEmpty()) {
            buffer.append("(");
            if (this.parnames.size() == 1 && "value".equals(this.parnames.get(0))) {
                buffer.append(this.parvalues.get(0).toJava(indent + 1, tracer));
            } else {
                String indstr1 = InterpreterUtil.getIndentString(indent + 1);
                for (int i = 0; i < this.parnames.size(); ++i) {
                    buffer.append(new_line_separator).append(indstr1);
                    buffer.append(this.parnames.get(i));
                    buffer.append(" = ");
                    buffer.append(this.parvalues.get(i).toJava(indent + 2, tracer));
                    if (i >= this.parnames.size() - 1) continue;
                    buffer.append(",");
                }
                buffer.append(new_line_separator).append(indstr);
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    public int getAnnotationType() {
        if (this.parnames.isEmpty()) {
            return 2;
        }
        if (this.parnames.size() == 1 && "value".equals(this.parnames.get(0))) {
            return 3;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof AnnotationExprent)) {
            return false;
        }
        AnnotationExprent ann = (AnnotationExprent)o;
        return this.classname.equals(ann.classname) && InterpreterUtil.equalLists(this.parnames, ann.parnames) && InterpreterUtil.equalLists(this.parvalues, ann.parvalues);
    }

    public String getClassname() {
        return this.classname;
    }
}

