/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructAnnotationTypeAttribute
extends StructGeneralAttribute {
    private static final int ANNOTATION_TARGET_TYPE_GENERIC_CLASS = 0;
    private static final int ANNOTATION_TARGET_TYPE_GENERIC_METHOD = 1;
    private static final int ANNOTATION_TARGET_TYPE_EXTENDS_IMPLEMENTS = 16;
    private static final int ANNOTATION_TARGET_TYPE_GENERIC_CLASS_BOUND = 17;
    private static final int ANNOTATION_TARGET_TYPE_GENERIC_METHOD_BOUND = 18;
    private static final int ANNOTATION_TARGET_TYPE_FIELD = 19;
    private static final int ANNOTATION_TARGET_TYPE_RETURN = 20;
    private static final int ANNOTATION_TARGET_TYPE_RECEIVER = 21;
    private static final int ANNOTATION_TARGET_TYPE_FORMAL = 22;
    private static final int ANNOTATION_TARGET_TYPE_THROWS = 23;
    private static final int ANNOTATION_TARGET_TYPE_LOCAL_VARIABLE = 64;
    private static final int ANNOTATION_TARGET_TYPE_RESOURCE_VARIABLE = 65;
    private static final int ANNOTATION_TARGET_TYPE_EXCEPTION = 66;
    private static final int ANNOTATION_TARGET_TYPE_INSTANCEOF = 67;
    private static final int ANNOTATION_TARGET_TYPE_NEW = 68;
    private static final int ANNOTATION_TARGET_TYPE_DOUBLE_COLON_NEW = 69;
    private static final int ANNOTATION_TARGET_TYPE_DOUBLE_COLON_ID = 70;
    private static final int ANNOTATION_TARGET_TYPE_CAST = 71;
    private static final int ANNOTATION_TARGET_TYPE_INVOCATION_CONSTRUCTOR = 72;
    private static final int ANNOTATION_TARGET_TYPE_INVOCATION_METHOD = 73;
    private static final int ANNOTATION_TARGET_TYPE_GENERIC_DOUBLE_COLON_NEW = 74;
    private static final int ANNOTATION_TARGET_TYPE_GENERIC_DOUBLE_COLON_ID = 75;
    private static final int ANNOTATION_TARGET_UNION_TYPE_PARAMETER = 1;
    private static final int ANNOTATION_TARGET_UNION_SUPERTYPE = 2;
    private static final int ANNOTATION_TARGET_UNION_TYPE_PARAMETER_BOUND = 3;
    private static final int ANNOTATION_TARGET_UNION_EMPTY = 4;
    private static final int ANNOTATION_TARGET_UNION_FORMAL_PARAMETER = 5;
    private static final int ANNOTATION_TARGET_UNION_THROWS = 6;
    private static final int ANNOTATION_TARGET_UNION_LOCAL_VAR = 7;
    private static final int ANNOTATION_TARGET_UNION_CATCH = 8;
    private static final int ANNOTATION_TARGET_UNION_OFFSET = 9;
    private static final int ANNOTATION_TARGET_UNION_TYPE_ARGUMENT = 10;
    private List<AnnotationLocation> locations;
    private List<AnnotationExprent> annotations;

    @Override
    public void initContent(ConstantPool pool) throws IOException {
        DataInputFullStream data = this.stream();
        int len = data.readUnsignedByte();
        if (len > 0) {
            this.locations = new ArrayList<AnnotationLocation>(len);
            this.annotations = new ArrayList<AnnotationExprent>(len);
            for (int i = 0; i < len; ++i) {
                this.locations.add(StructAnnotationTypeAttribute.parseAnnotationLocation(data));
                this.annotations.add(StructAnnotationAttribute.parseAnnotation(data, pool));
            }
        } else {
            this.locations = Collections.emptyList();
            this.annotations = Collections.emptyList();
        }
    }

    private static AnnotationLocation parseAnnotationLocation(DataInputStream data) throws IOException {
        int i;
        AnnotationLocation ann_location = new AnnotationLocation();
        ann_location.target_type = data.readUnsignedByte();
        switch (ann_location.target_type) {
            case 0: 
            case 1: {
                ann_location.target_union = 1;
                break;
            }
            case 16: {
                ann_location.target_union = 2;
                break;
            }
            case 17: 
            case 18: {
                ann_location.target_union = 3;
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                ann_location.target_union = 4;
                break;
            }
            case 22: {
                ann_location.target_union = 5;
                break;
            }
            case 23: {
                ann_location.target_union = 6;
                break;
            }
            case 64: 
            case 65: {
                ann_location.target_union = 7;
                break;
            }
            case 66: {
                ann_location.target_union = 8;
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                ann_location.target_union = 9;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                ann_location.target_union = 10;
                break;
            }
            default: {
                throw new RuntimeException("Unknown target type in a type annotation!");
            }
        }
        switch (ann_location.target_union) {
            case 1: 
            case 5: {
                ann_location.data = new int[]{data.readUnsignedByte()};
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                ann_location.data = new int[]{data.readUnsignedShort()};
                break;
            }
            case 3: {
                ann_location.data = new int[]{data.readUnsignedByte(), data.readUnsignedByte()};
                break;
            }
            case 4: {
                break;
            }
            case 7: {
                int table_length = data.readUnsignedShort();
                ann_location.data = new int[table_length * 3 + 1];
                ann_location.data[0] = table_length;
                for (i = 0; i < table_length; ++i) {
                    ann_location.data[3 * i + 1] = data.readUnsignedShort();
                    ann_location.data[3 * i + 2] = data.readUnsignedShort();
                    ann_location.data[3 * i + 3] = data.readUnsignedShort();
                }
                break;
            }
            case 10: {
                ann_location.data = new int[]{data.readUnsignedShort(), data.readUnsignedByte()};
            }
        }
        int path_length = data.readUnsignedByte();
        ann_location.target_path_kind = new int[path_length];
        ann_location.target_argument_index = new int[path_length];
        for (i = 0; i < path_length; ++i) {
            ann_location.target_path_kind[i] = data.readUnsignedByte();
            ann_location.target_argument_index[i] = data.readUnsignedByte();
        }
        return ann_location;
    }

    private static class AnnotationLocation {
        public int target_type;
        public int target_union;
        public int[] data;
        public int[] target_path_kind;
        public int[] target_argument_index;

        private AnnotationLocation() {
        }
    }
}

