/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.i18n;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;

public abstract class I18nizeFormQuickFix
extends QuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.i18n.I18nizeFormQuickFix");

    public I18nizeFormQuickFix(GuiEditor editor, String name, RadComponent component) {
        super(editor, name, component);
    }

    @Override
    public void run() {
        ProjectFileIndex fileIndex;
        String packageName;
        StringDescriptor descriptor = this.getStringDescriptorValue();
        final Project project = this.myEditor.getProject();
        PsiFile psiFile = this.myEditor.getPsiFile();
        if (!JavaI18nizeQuickFixDialog.isAvailable((PsiFile)this.myEditor.getPsiFile())) {
            return;
        }
        String initialValue = StringUtil.escapeStringCharacters((String)descriptor.getValue());
        final JavaI18nizeQuickFixDialog dialog = new JavaI18nizeQuickFixDialog(project, psiFile, null, initialValue, null, false, false){

            protected String getDimensionServiceKey() {
                return "#com.intellij.codeInsight.i18n.I18nizeQuickFixDialog_Form";
            }
        };
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        if (!this.myEditor.ensureEditable()) {
            return;
        }
        final Collection propertiesFiles = dialog.getAllPropertiesFiles();
        PropertiesFile aPropertiesFile = null;
        for (PropertiesFile file : propertiesFiles) {
            if (!FileModificationService.getInstance().prepareFileForWrite(file.getContainingFile())) {
                return;
            }
            if (aPropertiesFile != null) continue;
            aPropertiesFile = file;
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JavaI18nUtil.createProperty((Project)project, (Collection)propertiesFiles, (String)dialog.getKey(), (String)dialog.getValue());
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }, CodeInsightBundle.message((String)"quickfix.i18n.command.name", (Object[])new Object[0]), (Object)project);
        for (PropertiesFile file : propertiesFiles) {
            FileDocumentManager.getInstance().saveDocument(PsiDocumentManager.getInstance((Project)project).getDocument(file.getContainingFile()));
        }
        if (aPropertiesFile != null && (packageName = (fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex()).getPackageNameByDirectory(aPropertiesFile.getVirtualFile().getParent())) != null) {
            String bundleName = packageName.length() > 0 ? packageName + "." + aPropertiesFile.getResourceBundle().getBaseName() : aPropertiesFile.getResourceBundle().getBaseName();
            bundleName = bundleName.replace('.', '/');
            try {
                this.setStringDescriptorValue(new StringDescriptor(bundleName, dialog.getKey()));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            this.myEditor.refreshAndSave(true);
        }
    }

    protected abstract StringDescriptor getStringDescriptorValue();

    protected abstract void setStringDescriptorValue(StringDescriptor var1) throws Exception;
}

