/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.TreeDiffProvider;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.util.containers.ComparatorDelegate;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsUserRegistry;
import git4idea.GitRevisionNumber;
import git4idea.GitRevisionSelector;
import git4idea.GitRootConverter;
import git4idea.GitUserRegistry;
import git4idea.GitUtil;
import git4idea.annotate.GitAnnotationProvider;
import git4idea.annotate.GitRepositoryForAnnotationsListener;
import git4idea.changes.GitCommittedChangeListProvider;
import git4idea.changes.GitOutgoingChangesProvider;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.checkin.GitCommitAndPushExecutor;
import git4idea.checkout.GitCheckoutProvider;
import git4idea.commands.Git;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitExecutableValidator;
import git4idea.config.GitSharedSettings;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsConfigurable;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.diff.GitDiffProvider;
import git4idea.diff.GitTreeDiffProvider;
import git4idea.history.GitHistoryProvider;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeProvider;
import git4idea.rollback.GitRollbackEnvironment;
import git4idea.roots.GitIntegrationEnabler;
import git4idea.status.GitChangeProvider;
import git4idea.ui.branch.GitBranchWidget;
import git4idea.update.GitUpdateEnvironment;
import git4idea.vfs.GitVFSListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitVcs
extends AbstractVcs<CommittedChangeList> {
    public static final String NAME = "Git";
    private static final Logger log;
    private static final VcsKey ourKey;
    private final ChangeProvider myChangeProvider;
    private final GitCheckinEnvironment myCheckinEnvironment;
    private final RollbackEnvironment myRollbackEnvironment;
    private final GitUpdateEnvironment myUpdateEnvironment;
    private final GitAnnotationProvider myAnnotationProvider;
    private final DiffProvider myDiffProvider;
    private final VcsHistoryProvider myHistoryProvider;
    @NotNull
    private final Git myGit;
    private final ProjectLevelVcsManager myVcsManager;
    private final GitVcsApplicationSettings myAppSettings;
    private final Configurable myConfigurable;
    private final RevisionSelector myRevSelector;
    private final GitCommittedChangeListProvider myCommittedChangeListProvider;
    private GitVFSListener myVFSListener;
    private final ReadWriteLock myCommandLock;
    private final TreeDiffProvider myTreeDiffProvider;
    private final GitCommitAndPushExecutor myCommitAndPushExecutor;
    private final GitExecutableValidator myExecutableValidator;
    private GitBranchWidget myBranchWidget;
    private GitVersion myVersion;
    private static final int MAX_CONSOLE_OUTPUT_SIZE = 10000;
    private GitRepositoryForAnnotationsListener myRepositoryForAnnotationsListener;
    private final VcsOutgoingChangesProvider<CommittedChangeList> myOutgoingChangesProvider;

    @Nullable
    public static GitVcs getInstance(Project project) {
        if (project == null || project.isDisposed()) {
            return null;
        }
        return (GitVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(NAME);
    }

    public GitVcs(@NotNull Project project, @NotNull Git git, @NotNull ProjectLevelVcsManager gitVcsManager, @NotNull GitAnnotationProvider gitAnnotationProvider, @NotNull GitDiffProvider gitDiffProvider, @NotNull GitHistoryProvider gitHistoryProvider, @NotNull GitRollbackEnvironment gitRollbackEnvironment, @NotNull GitVcsApplicationSettings gitSettings, @NotNull GitVcsSettings gitProjectSettings, @NotNull GitSharedSettings sharedSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitVcs", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/GitVcs", "<init>"));
        }
        if (gitVcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitVcsManager", "git4idea/GitVcs", "<init>"));
        }
        if (gitAnnotationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitAnnotationProvider", "git4idea/GitVcs", "<init>"));
        }
        if (gitDiffProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitDiffProvider", "git4idea/GitVcs", "<init>"));
        }
        if (gitHistoryProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitHistoryProvider", "git4idea/GitVcs", "<init>"));
        }
        if (gitRollbackEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitRollbackEnvironment", "git4idea/GitVcs", "<init>"));
        }
        if (gitSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitSettings", "git4idea/GitVcs", "<init>"));
        }
        if (gitProjectSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitProjectSettings", "git4idea/GitVcs", "<init>"));
        }
        if (sharedSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sharedSettings", "git4idea/GitVcs", "<init>"));
        }
        super(project, NAME);
        this.myCommandLock = new ReentrantReadWriteLock(true);
        this.myVersion = GitVersion.NULL;
        this.myGit = git;
        this.myVcsManager = gitVcsManager;
        this.myAppSettings = gitSettings;
        this.myChangeProvider = project.isDefault() ? null : (GitChangeProvider)ServiceManager.getService((Project)project, GitChangeProvider.class);
        this.myCheckinEnvironment = project.isDefault() ? null : (GitCheckinEnvironment)ServiceManager.getService((Project)project, GitCheckinEnvironment.class);
        this.myAnnotationProvider = gitAnnotationProvider;
        this.myDiffProvider = gitDiffProvider;
        this.myHistoryProvider = gitHistoryProvider;
        this.myRollbackEnvironment = gitRollbackEnvironment;
        this.myRevSelector = new GitRevisionSelector();
        this.myConfigurable = new GitVcsConfigurable(this.myProject, gitProjectSettings, sharedSettings);
        this.myUpdateEnvironment = new GitUpdateEnvironment(this.myProject, this, gitProjectSettings);
        this.myCommittedChangeListProvider = new GitCommittedChangeListProvider(this.myProject);
        this.myOutgoingChangesProvider = new GitOutgoingChangesProvider(this.myProject);
        this.myTreeDiffProvider = new GitTreeDiffProvider(this.myProject);
        this.myCommitAndPushExecutor = new GitCommitAndPushExecutor(this.myCheckinEnvironment);
        this.myExecutableValidator = new GitExecutableValidator(this.myProject);
    }

    public ReadWriteLock getCommandLock() {
        return this.myCommandLock;
    }

    public static void runInBackground(Task.Backgroundable task) {
        task.queue();
    }

    public CommittedChangesProvider getCommittedChangesProvider() {
        return this.myCommittedChangeListProvider;
    }

    public String getRevisionPattern() {
        return "[0-9a-fA-F]+";
    }

    @NotNull
    public CheckinEnvironment createCheckinEnvironment() {
        GitCheckinEnvironment gitCheckinEnvironment = this.myCheckinEnvironment;
        if (gitCheckinEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitVcs", "createCheckinEnvironment"));
        }
        return gitCheckinEnvironment;
    }

    @NotNull
    public MergeProvider getMergeProvider() {
        MergeProvider mergeProvider = GitMergeProvider.detect(this.myProject);
        if (mergeProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitVcs", "getMergeProvider"));
        }
        return mergeProvider;
    }

    @NotNull
    public RollbackEnvironment createRollbackEnvironment() {
        RollbackEnvironment rollbackEnvironment = this.myRollbackEnvironment;
        if (rollbackEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitVcs", "createRollbackEnvironment"));
        }
        return rollbackEnvironment;
    }

    @NotNull
    public VcsHistoryProvider getVcsHistoryProvider() {
        VcsHistoryProvider vcsHistoryProvider = this.myHistoryProvider;
        if (vcsHistoryProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitVcs", "getVcsHistoryProvider"));
        }
        return vcsHistoryProvider;
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.myHistoryProvider;
    }

    @NotNull
    public String getDisplayName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitVcs", "getDisplayName"));
        }
        return NAME;
    }

    @Nullable
    public UpdateEnvironment createUpdateEnvironment() {
        return this.myUpdateEnvironment;
    }

    @NotNull
    public GitAnnotationProvider getAnnotationProvider() {
        GitAnnotationProvider gitAnnotationProvider = this.myAnnotationProvider;
        if (gitAnnotationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitVcs", "getAnnotationProvider"));
        }
        return gitAnnotationProvider;
    }

    @NotNull
    public DiffProvider getDiffProvider() {
        DiffProvider diffProvider = this.myDiffProvider;
        if (diffProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitVcs", "getDiffProvider"));
        }
        return diffProvider;
    }

    @Nullable
    public RevisionSelector getRevisionSelector() {
        return this.myRevSelector;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(@Nullable String revision, @Nullable FilePath path) throws VcsException {
        if (revision == null || revision.length() == 0) {
            return null;
        }
        if (revision.length() > 40) {
            String dateString = revision.substring(0, revision.indexOf("["));
            String rev = revision.substring(revision.indexOf("[") + 1, 40);
            Date d = new Date(Date.parse(dateString));
            return new GitRevisionNumber(rev, d);
        }
        if (path != null) {
            try {
                VirtualFile root = GitUtil.getGitRoot(path);
                return GitRevisionNumber.resolve(this.myProject, root, revision);
            }
            catch (VcsException e) {
                log.info("Unexpected problem with resolving the git revision number: ", (Throwable)e);
                throw e;
            }
        }
        return new GitRevisionNumber(revision);
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(@Nullable String revision) throws VcsException {
        return this.parseRevisionNumber(revision, null);
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return dir.isDirectory() && GitUtil.gitRootOrNull(dir) != null;
    }

    protected void start() throws VcsException {
    }

    protected void shutdown() throws VcsException {
    }

    protected void activate() {
        this.checkExecutableAndVersion();
        if (this.myVFSListener == null) {
            this.myVFSListener = new GitVFSListener(this.myProject, this, this.myGit);
        }
        ServiceManager.getService((Project)this.myProject, VcsUserRegistry.class);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myBranchWidget = new GitBranchWidget(this.myProject);
            DvcsUtil.installStatusBarWidget((Project)this.myProject, (StatusBarWidget)this.myBranchWidget);
        }
        if (this.myRepositoryForAnnotationsListener == null) {
            this.myRepositoryForAnnotationsListener = new GitRepositoryForAnnotationsListener(this.myProject);
        }
        ((GitUserRegistry)ServiceManager.getService((Project)this.myProject, GitUserRegistry.class)).activate();
    }

    private void checkExecutableAndVersion() {
        boolean executableIsAlreadyCheckedAndFine = false;
        String pathToGit = this.myAppSettings.getPathToGit();
        if (!pathToGit.contains(File.separator)) {
            if (!this.myExecutableValidator.isExecutableValid()) {
                this.myAppSettings.setPathToGit(new GitExecutableDetector().detect());
            } else {
                executableIsAlreadyCheckedAndFine = true;
            }
        }
        if (executableIsAlreadyCheckedAndFine || this.myExecutableValidator.checkExecutableAndNotifyIfNeeded()) {
            this.checkVersion();
        }
    }

    protected void deactivate() {
        if (this.myVFSListener != null) {
            Disposer.dispose((Disposable)this.myVFSListener);
            this.myVFSListener = null;
        }
        if (this.myBranchWidget != null) {
            DvcsUtil.removeStatusBarWidget((Project)this.myProject, (StatusBarWidget)this.myBranchWidget);
            this.myBranchWidget = null;
        }
    }

    @NotNull
    public synchronized Configurable getConfigurable() {
        Configurable configurable = this.myConfigurable;
        if (configurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitVcs", "getConfigurable"));
        }
        return configurable;
    }

    @Nullable
    public ChangeProvider getChangeProvider() {
        return this.myChangeProvider;
    }

    public void showErrors(@NotNull List<VcsException> list, @NotNull String action) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "git4idea/GitVcs", "showErrors"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "git4idea/GitVcs", "showErrors"));
        }
        if (list.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n");
            buffer.append(GitBundle.message("error.list.title", action));
            for (VcsException exception : list) {
                buffer.append("\n");
                buffer.append(exception.getMessage());
            }
            final String msg = buffer.toString();
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)GitVcs.this.myProject, (String)msg, (String)GitBundle.getString("error.dialog.title"));
                }
            });
        }
    }

    public void showMessages(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "git4idea/GitVcs", "showMessages"));
        }
        if (message.length() == 0) {
            return;
        }
        this.showMessage(message, ConsoleViewContentType.NORMAL_OUTPUT.getAttributes());
    }

    private void showMessage(@NotNull String message, TextAttributes style) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "git4idea/GitVcs", "showMessage"));
        }
        if (message.length() > 10000) {
            message = message.substring(0, 10000);
        }
        this.myVcsManager.addMessageToConsoleWindow(message, style);
    }

    public void checkVersion() {
        block4: {
            String executable = this.myAppSettings.getPathToGit();
            try {
                this.myVersion = GitVersion.identifyVersion(executable);
                if (!this.myVersion.isSupported()) {
                    log.info("Unsupported Git version: " + this.myVersion);
                    String SETTINGS_LINK = "settings";
                    String UPDATE_LINK = "update";
                    String message = String.format("The <a href='settings'>configured</a> version of Git is not supported: %s.<br/> The minimal supported version is %s. Please <a href='update'>update</a>.", this.myVersion, GitVersion.MIN);
                    VcsNotifier.getInstance((Project)this.myProject).notifyError("Unsupported Git version", message, (NotificationListener)new NotificationListener.Adapter(){

                        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                            if (notification == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/GitVcs$2", "hyperlinkActivated"));
                            }
                            if (e == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/GitVcs$2", "hyperlinkActivated"));
                            }
                            if ("settings".equals(e.getDescription())) {
                                ShowSettingsUtil.getInstance().showSettingsDialog(GitVcs.this.myProject, GitVcs.this.getConfigurable().getDisplayName());
                            } else if ("update".equals(e.getDescription())) {
                                BrowserUtil.browse((String)"http://git-scm.com");
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                if (!this.getExecutableValidator().checkExecutableAndNotifyIfNeeded()) break block4;
                String reason = (e.getCause() != null ? e.getCause() : e).getMessage();
                String message = GitBundle.message("vcs.unable.to.run.git", executable, reason);
                if (!this.myProject.isDefault()) {
                    this.showMessage(message, ConsoleViewContentType.SYSTEM_OUTPUT.getAttributes());
                }
                VcsBalloonProblemNotifier.showOverVersionControlView((Project)this.myProject, (String)message, (MessageType)MessageType.ERROR);
            }
        }
    }

    @NotNull
    public GitVersion getVersion() {
        GitVersion gitVersion = this.myVersion;
        if (gitVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitVcs", "getVersion"));
        }
        return gitVersion;
    }

    public void showCommandLine(String cmdLine) {
        SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss.SSS");
        this.showMessage(f.format(new Date()) + ": " + cmdLine, ConsoleViewContentType.SYSTEM_OUTPUT.getAttributes());
    }

    public void showErrorMessages(String line) {
        this.showMessage(line, ConsoleViewContentType.ERROR_OUTPUT.getAttributes());
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    public <S> List<S> filterUniqueRoots(List<S> in, Convertor<S, VirtualFile> convertor) {
        Collections.sort(in, new ComparatorDelegate(convertor, (Comparator)FilePathComparator.getInstance()));
        block0: for (int i = 1; i < in.size(); ++i) {
            S sChild = in.get(i);
            VirtualFile child = (VirtualFile)convertor.convert(sChild);
            VirtualFile childRoot = GitUtil.gitRootOrNull(child);
            if (childRoot == null) continue;
            for (int j = i - 1; j >= 0; --j) {
                S sParent = in.get(j);
                VirtualFile parent = (VirtualFile)convertor.convert(sParent);
                if (!VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)child, (boolean)false) || !VfsUtilCore.isAncestor((VirtualFile)childRoot, (VirtualFile)parent, (boolean)false)) continue;
                in.remove(i);
                --i;
                continue block0;
            }
        }
        return in;
    }

    public AbstractVcs.RootsConvertor getCustomConvertor() {
        return GitRootConverter.INSTANCE;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public VcsType getType() {
        return VcsType.distributed;
    }

    protected VcsOutgoingChangesProvider<CommittedChangeList> getOutgoingProviderImpl() {
        return this.myOutgoingChangesProvider;
    }

    public RemoteDifferenceStrategy getRemoteDifferenceStrategy() {
        return RemoteDifferenceStrategy.ASK_TREE_PROVIDER;
    }

    protected TreeDiffProvider getTreeDiffProviderImpl() {
        return this.myTreeDiffProvider;
    }

    public List<CommitExecutor> getCommitExecutors() {
        return Collections.singletonList(this.myCommitAndPushExecutor);
    }

    @NotNull
    public GitExecutableValidator getExecutableValidator() {
        GitExecutableValidator gitExecutableValidator = this.myExecutableValidator;
        if (gitExecutableValidator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitVcs", "getExecutableValidator"));
        }
        return gitExecutableValidator;
    }

    public boolean fileListenerIsSynchronous() {
        return false;
    }

    public void enableIntegration() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                Collection roots = ((VcsRootDetector)ServiceManager.getService((Project)GitVcs.this.myProject, VcsRootDetector.class)).detect();
                new GitIntegrationEnabler(GitVcs.this, GitVcs.this.myGit).enable(roots);
            }
        });
    }

    public CheckoutProvider getCheckoutProvider() {
        return new GitCheckoutProvider((Git)ServiceManager.getService(Git.class));
    }

    static {
        NotificationsConfigurationImpl.remove((String[])new String[]{NAME});
        log = Logger.getInstance((String)GitVcs.class.getName());
        ourKey = GitVcs.createKey((String)NAME);
    }
}

