/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.welcome.FirstRunWizardMode;
import com.android.tools.idea.welcome.FirstRunWizardStep;
import com.android.tools.idea.welcome.WelcomeUIUtils;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkLocationStep
extends FirstRunWizardStep {
    private static final String MAC_JDKS_DIR = "/Library/Java/JavaVirtualMachines/";
    private static final String MAC_JDK_CONTENT_PATH = "/Contents/Home";
    private static final String WINDOWS_JDKS_DIR = "C:\\Program Files\\Java";
    private static final String LINUX_SDK_DIR = "/usr/lib/jvm";
    private static final String JDK_URL = "http://www.oracle.com/technetwork/java/javase/downloads/jdk7-downloads-1880260.html";
    private final ScopedStateStore.Key<String> myPathKey;
    @NotNull
    private final FirstRunWizardMode myMode;
    private JPanel myContents;
    private TextFieldWithBrowseButton myJdkPath;
    private JButton myDownloadPageLink;
    private JLabel myError;
    private JButton myDetectButton;
    private JLabel myDetectLabel;
    private boolean myUserInput;

    public JdkLocationStep(@NotNull ScopedStateStore.Key<String> pathKey, @NotNull FirstRunWizardMode mode) {
        if (pathKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathKey", "com/android/tools/idea/welcome/JdkLocationStep", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/welcome/JdkLocationStep", "<init>"));
        }
        super("Java Settings");
        this.myUserInput = false;
        this.myPathKey = pathKey;
        this.myMode = mode;
        this.$$$setupUI$$$();
        this.myDownloadPageLink.setText(JdkLocationStep.getLinkText());
        WelcomeUIUtils.makeButtonAHyperlink(this.myDownloadPageLink, JDK_URL);
        this.myDownloadPageLink.getParent().invalidate();
        this.setComponent(this.myContents);
        this.myError.setForeground((Color)JBColor.red);
        FileChooserDescriptor folderDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myJdkPath.addBrowseFolderListener("Select JDK Location", "Select compatible JDK location", null, folderDescriptor);
        this.myError.setText(null);
        this.myDetectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressManager.getInstance().run((Task)new DetectJdkTask());
            }
        });
    }

    private static String getLinkText() {
        if (SystemInfo.isMac) {
            return "Mac OS X x64";
        }
        if (SystemInfo.isLinux) {
            return SystemInfo.is32Bit ? "Linux x86" : "Linux x64";
        }
        if (SystemInfo.isWindows) {
            return SystemInfo.is32Bit ? "Windows x86" : "Windows x64";
        }
        return SystemInfo.OS_NAME;
    }

    private static boolean isJdk7(@NotNull File path) {
        JavaSdkVersion version;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/welcome/JdkLocationStep", "isJdk7"));
        }
        String jdkVersion = JavaSdk.getJdkVersion((String)path.getAbsolutePath());
        return jdkVersion == null || (version = JavaSdk.getInstance().getVersion(jdkVersion)) == null || version.isAtLeast(JavaSdkVersion.JDK_1_7);
    }

    @Nullable
    public static String validateJdkLocation(@Nullable File location) {
        if (location == null) {
            return "Path is empty";
        }
        if (!JdkUtil.checkForJdk((File)location)) {
            return "Path specified is not a valid JDK location";
        }
        if (!JdkLocationStep.isJdk7(location)) {
            return "JDK 7.0 or newer is required";
        }
        return null;
    }

    @NotNull
    private static Iterable<String> getCandidatePaths() {
        if (SystemInfo.isMac) {
            Iterable<String> iterable = JdkLocationStep.getMacCandidateJdks();
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getCandidatePaths"));
            }
            return iterable;
        }
        if (SystemInfo.isWindows) {
            Iterable<String> iterable = JdkLocationStep.getWindowsCandidateJdks();
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getCandidatePaths"));
            }
            return iterable;
        }
        if (SystemInfo.isLinux) {
            Iterable<String> iterable = JdkLocationStep.getLinuxCandidateJdks();
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getCandidatePaths"));
            }
            return iterable;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getCandidatePaths"));
        }
        return list;
    }

    @NotNull
    private static Iterable<String> getMacCandidateJdks() {
        Iterable<String> iterable = JdkLocationStep.getCandidatePaths(MAC_JDKS_DIR, MAC_JDK_CONTENT_PATH);
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getMacCandidateJdks"));
        }
        return iterable;
    }

    @NotNull
    private static Iterable<String> getWindowsCandidateJdks() {
        Iterable<String> iterable = JdkLocationStep.getCandidatePaths(WINDOWS_JDKS_DIR, "");
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getWindowsCandidateJdks"));
        }
        return iterable;
    }

    @NotNull
    private static Iterable<String> getLinuxCandidateJdks() {
        Iterable<String> iterable = JdkLocationStep.getCandidatePaths(LINUX_SDK_DIR, "");
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getLinuxCandidateJdks"));
        }
        return iterable;
    }

    private static Iterable<String> getCandidatePaths(String basedir, final String suffix) {
        final File location = new File(basedir);
        if (location.isDirectory()) {
            return Iterables.transform(Arrays.asList(location.list()), (Function)new Function<String, String>(){

                public String apply(@Nullable String dir) {
                    return new File(location, dir + suffix).getAbsolutePath();
                }
            });
        }
        return Collections.emptyList();
    }

    @Override
    public boolean validate() {
        String path = this.myState.get(this.myPathKey);
        if (!StringUtil.isEmpty((String)path)) {
            this.myUserInput = true;
        }
        File userInput = StringUtil.isEmptyOrSpaces((String)path) ? null : new File(path);
        String message = JdkLocationStep.validateJdkLocation(userInput);
        if (this.myUserInput) {
            this.setErrorHtml(message);
        }
        return StringUtil.isEmpty((String)message);
    }

    @Override
    public void init() {
        this.register(this.myPathKey, this.myJdkPath);
    }

    @Override
    public boolean isStepVisible() {
        return !this.myMode.hasValidJdkLocation();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myJdkPath;
    }

    @Override
    @NotNull
    public JLabel getMessageLabel() {
        JLabel jLabel = this.myError;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/JdkLocationStep", "getMessageLabel"));
        }
        return jLabel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JButton jButton;
        JLabel jLabel2;
        JButton jButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myContents = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("<html>Android Studio requires Java Development Kit (JDK) 7.0 or newer.</html>");
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 2, null, new Dimension(800, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Java Development Kit (JDK) version 7.0.");
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJdkPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("or download and install JDK for your operating system and architecture: ");
        Component component = jPanel2.add(jLabel5);
        this.myDownloadPageLink = jButton2 = new JButton();
        jButton2.setHorizontalAlignment(2);
        jButton2.setText("Button");
        Component component2 = jPanel2.add(jButton2);
        this.myDetectLabel = jLabel2 = new JLabel();
        jLabel2.setText(" and press ");
        Component component3 = jPanel2.add(jLabel2);
        this.myDetectButton = jButton = new JButton();
        jButton.setText("Detect");
        Component component4 = jPanel2.add(jButton);
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        this.myError = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(7, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Up to date JDK was not detected. Please select JDK location:");
        jPanel.add((Component)jLabel6, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContents;
    }

    private class DetectJdkTask
    extends Task.Modal {
        private final AtomicBoolean myCancelled;
        private String myPath;

        public DetectJdkTask() {
            super(null, "Detect JDK", true);
            this.myCancelled = new AtomicBoolean(false);
            this.myPath = null;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/JdkLocationStep$DetectJdkTask", "run"));
            }
            indicator.setIndeterminate(true);
            String topVersion = null;
            String chosenPath = null;
            for (String path : JdkLocationStep.getCandidatePaths()) {
                if (this.myCancelled.get()) {
                    return;
                }
                if (!StringUtil.isEmpty((String)JdkLocationStep.validateJdkLocation(new File(path)))) continue;
                String version = JavaSdk.getInstance().getVersionString(path);
                if (topVersion != null && version != null && topVersion.compareTo(version) >= 0) continue;
                topVersion = version;
                chosenPath = path;
            }
            this.myPath = chosenPath;
        }

        public void onSuccess() {
            if (this.myPath != null) {
                JdkLocationStep.this.myState.put(JdkLocationStep.this.myPathKey, this.myPath);
            }
            super.onSuccess();
        }

        public void onCancel() {
            this.myCancelled.set(true);
        }
    }
}

