/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.RadViewLayoutWithData;
import com.intellij.android.designer.model.ViewsMetaManager;
import com.intellij.android.designer.propertyTable.AttributeProperty;
import com.intellij.android.designer.propertyTable.AttributePropertyWithDefault;
import com.intellij.android.designer.propertyTable.CompoundDimensionProperty;
import com.intellij.android.designer.propertyTable.FlagProperty;
import com.intellij.android.designer.propertyTable.GravityProperty;
import com.intellij.android.designer.propertyTable.IdProperty;
import com.intellij.android.designer.propertyTable.PropertyWithNamespace;
import com.intellij.android.designer.propertyTable.StyleProperty;
import com.intellij.designer.model.MetaManager;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadLayout;
import com.intellij.designer.propertyTable.PropertyTable;
import com.intellij.openapi.module.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.uipreview.ProjectClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyParser {
    public static final String KEY = "PROPERTY_PARSER";
    private static final String[] DEFAULT_LAYOUT_PARAMS = new String[]{"ViewGroup_Layout"};
    private static final String LAYOUT_PREFIX = "layout_";
    private static final String LAYOUT_MARGIN_PREFIX = "layout_margin";
    private MetaManager myMetaManager;
    private AttributeDefinitions myDefinitions;
    private ProjectClassLoader myClassLoader;
    private Map<String, List<Property>> myCachedProperties;

    public PropertyParser(@NotNull RenderResult result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/android/designer/model/PropertyParser", "<init>"));
        }
        assert (result.getSession() != null);
        assert (result.getSession().getResult().isSuccess());
        RenderService renderService = result.getRenderService();
        assert (renderService != null);
        IAndroidTarget target = renderService.getConfiguration().getTarget();
        assert (target != null);
        Module module = renderService.getModule();
        this.myMetaManager = ViewsMetaManager.getInstance(module.getProject());
        this.myCachedProperties = this.myMetaManager.getCache((Object)target.hashString());
        if (this.myCachedProperties == null) {
            this.myCachedProperties = new HashMap<String, List<Property>>();
            this.myMetaManager.setCache((Object)target.hashString(), this.myCachedProperties);
        }
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(module);
        assert (androidPlatform != null);
        AndroidTargetData targetData = androidPlatform.getSdkData().getTargetData(target);
        this.myDefinitions = targetData.getAttrDefs(module.getProject());
        LayoutLibrary library = renderService.getLayoutLib();
        this.myClassLoader = new ProjectClassLoader(library.getClassLoader(), module, null, null);
    }

    public void load(RadViewComponent component) throws Exception {
        MetaModel model = component.getMetaModelForProperties();
        String target = model.getTarget();
        if (target == null) {
            ViewInfo info = component.getViewInfo();
            if (info == null) {
                component.setProperties(Collections.<Property>emptyList());
            } else {
                Class<?> componentClass = this.configureClass(this.myClassLoader.loadClass(info.getClassName()));
                component.setProperties(this.loadWidgetProperties(componentClass, model));
            }
        } else {
            component.setProperties(this.loadWidgetProperties(this.myClassLoader.loadClass(target), model));
        }
        RadComponent parent = component.getParent();
        if (parent != null) {
            String[] layoutParams = null;
            RadLayout layout = parent.getLayout();
            if (layout instanceof RadViewLayoutWithData) {
                layoutParams = ((RadViewLayoutWithData)layout).getLayoutParams();
            } else if (parent == parent.getRoot()) {
                layoutParams = DEFAULT_LAYOUT_PARAMS;
            }
            if (layoutParams != null) {
                String extendTarget;
                MetaModel[] models = new MetaModel[layoutParams.length];
                models[0] = parent.getMetaModelForProperties();
                for (int i = 1; i < layoutParams.length && models[i - 1] != null && (extendTarget = models[i - 1].getTarget()) != null; ++i) {
                    Class<?> superClass = this.myClassLoader.loadClass(extendTarget).getSuperclass();
                    if (superClass == null) continue;
                    superClass = this.configureClass(superClass);
                    models[i] = this.myMetaManager.getModelByTarget(superClass.getName());
                }
                List<Property> properties = this.loadLayoutProperties(layoutParams, 0, models);
                if (!properties.isEmpty()) {
                    properties = new ArrayList<Property>(properties);
                    properties.addAll(component.getProperties());
                    component.setProperties(properties);
                }
            }
        }
    }

    private List<Property> loadWidgetProperties(Class<?> componentClass, @Nullable MetaModel model) throws Exception {
        String component = componentClass.getSimpleName();
        List<Property> properties = this.myCachedProperties.get(component);
        if (properties == null) {
            Class<?> superComponentClass;
            StyleableDefinition definitions;
            properties = new ArrayList<Property>();
            this.myCachedProperties.put(component, properties);
            if ("View".equals(component)) {
                properties.add(new StyleProperty());
            }
            if ((definitions = this.myDefinitions.getStyleableByName(component)) != null) {
                boolean padding = false;
                for (AttributeDefinition definition : definitions.getAttributes()) {
                    String name = definition.getName();
                    Set<AttributeFormat> formats = definition.getFormats();
                    if ("padding".equals(name) && "View".equals(component)) {
                        padding = true;
                    }
                    PropertyWithNamespace property = formats.contains((Object)AttributeFormat.Flag) ? new FlagProperty(name, definition) : ("id".equals(name) && "View".equals(component) ? new IdProperty(name, definition) : new AttributeProperty(name, definition));
                    if (model != null) {
                        model.decorate((Property)property, name);
                    }
                    properties.add(property);
                }
                if (padding) {
                    CompoundDimensionProperty paddingProperty = new CompoundDimensionProperty("padding");
                    PropertyParser.moveProperties(properties, paddingProperty, "padding", "all", "paddingLeft", "left", "paddingTop", "top", "paddingRight", "right", "paddingBottom", "bottom");
                    if (model != null) {
                        paddingProperty.decorate(model);
                    }
                    properties.add(paddingProperty);
                }
            }
            if ((superComponentClass = componentClass.getSuperclass()) != null) {
                superComponentClass = this.configureClass(superComponentClass);
                MetaModel superModel = this.myMetaManager.getModelByTarget(superComponentClass.getName());
                if (model != null && superModel != null && model.getInplaceProperties().isEmpty()) {
                    model.setInplaceProperties(superModel.getInplaceProperties());
                }
                List<Property> superProperties = this.loadWidgetProperties(superComponentClass, superModel);
                for (Property superProperty : superProperties) {
                    if (PropertyTable.findProperty(properties, (Property)superProperty) != -1) continue;
                    if (model == null) {
                        properties.add(superProperty);
                        continue;
                    }
                    properties.add(model.decorateWithOverride(superProperty));
                }
            }
            if (!properties.isEmpty()) {
                Collections.sort(properties, new Comparator<Property>(){

                    @Override
                    public int compare(Property p1, Property p2) {
                        return p1.getName().compareTo(p2.getName());
                    }
                });
                if (model != null) {
                    for (String topName : model.getTopProperties()) {
                        PropertyTable.moveProperty(properties, (String)topName, properties, (int)0);
                    }
                }
                PropertyTable.moveProperty(properties, (String)"style", properties, (int)0);
            }
        }
        return properties;
    }

    private Class<?> configureClass(Class<?> viewClass) throws Exception {
        if (viewClass.getName().equals("com.android.layoutlib.bridge.MockView")) {
            return this.myClassLoader.loadClass("android.view.View");
        }
        return viewClass;
    }

    private List<Property> loadLayoutProperties(String[] components, int index, MetaModel[] models) throws Exception {
        String component = components[index];
        MetaModel model = models[index];
        List<Property> properties = this.myCachedProperties.get(component);
        if (properties == null) {
            Class layout;
            properties = new ArrayList<Property>();
            this.myCachedProperties.put(component, properties);
            StyleableDefinition definitions = this.myDefinitions.getStyleableByName(component);
            if (definitions != null) {
                boolean margin = false;
                for (AttributeDefinition definition : definitions.getAttributes()) {
                    String name = definition.getName();
                    boolean important = true;
                    Set<AttributeFormat> formats = definition.getFormats();
                    if (name.startsWith(LAYOUT_MARGIN_PREFIX)) {
                        name = name.substring(LAYOUT_PREFIX.length());
                        important = false;
                    } else if (name.startsWith(LAYOUT_PREFIX)) {
                        name = "layout:" + name.substring(LAYOUT_PREFIX.length());
                    }
                    if ("margin".equals(name) && "ViewGroup_MarginLayout".equals(component)) {
                        margin = true;
                    }
                    PropertyWithNamespace property = "layout:width".equals(name) || "layout:height".equals(name) ? new AttributePropertyWithDefault(name, definition, "wrap_content") : (formats.contains((Object)AttributeFormat.Flag) ? ("layout:gravity".equals(name) ? new GravityProperty(name, definition) : new FlagProperty(name, definition)) : new AttributeProperty(name, definition));
                    if (model != null) {
                        model.decorate((Property)property, name);
                    }
                    property.setImportant(important);
                    properties.add(property);
                }
                if (margin) {
                    CompoundDimensionProperty marginProperty = new CompoundDimensionProperty("layout:margin");
                    PropertyParser.moveProperties(properties, marginProperty, "margin", "all", "marginLeft", "left", "marginTop", "top", "marginRight", "right", "marginBottom", "bottom", "marginStart", "start", "marginEnd", "end");
                    if (model != null) {
                        marginProperty.decorate(model);
                    }
                    marginProperty.setImportant(true);
                    properties.add(marginProperty);
                }
            }
            if (++index < components.length) {
                for (Property property : this.loadLayoutProperties(components, index, models)) {
                    if (PropertyTable.findProperty(properties, (Property)property) != -1) continue;
                    if (model == null) {
                        properties.add(property);
                        continue;
                    }
                    property = model.decorateWithOverride(property);
                    properties.add(property);
                }
            }
            if (!properties.isEmpty()) {
                Collections.sort(properties, new Comparator<Property>(){

                    @Override
                    public int compare(Property p1, Property p2) {
                        return p1.getName().compareTo(p2.getName());
                    }
                });
                PropertyTable.moveProperty(properties, (String)"layout:margin", properties, (int)0);
                PropertyTable.moveProperty(properties, (String)"layout:gravity", properties, (int)0);
                PropertyTable.moveProperty(properties, (String)"layout:height", properties, (int)0);
                PropertyTable.moveProperty(properties, (String)"layout:width", properties, (int)0);
            }
            if (model != null && (layout = model.getLayout()) != null) {
                ((RadLayout)layout.newInstance()).configureProperties(properties);
            }
        }
        return properties;
    }

    public static void moveProperties(List<Property> source, Property destination, String ... names) {
        List children = destination.getChildren(null);
        for (int i = 0; i < names.length; i += 2) {
            Property property = PropertyTable.extractProperty(source, (String)names[i]);
            if (property == null) continue;
            children.add(property.createForNewPresentation(destination, names[i + 1]));
        }
    }

    public boolean isAssignableFrom(MetaModel base, MetaModel test) {
        try {
            Class<?> baseClass = this.myClassLoader.loadClass(base.getTarget());
            Class<?> testClass = this.myClassLoader.loadClass(test.getTarget());
            return baseClass.isAssignableFrom(testClass);
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

