/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution.cmd;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.util.TextFieldCompletionProvider;
import groovyjarjarcommonscli.Option;
import groovyjarjarcommonscli.Options;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.cmd.ParametersListLexer;

public abstract class CommandLineCompletionProvider
extends TextFieldCompletionProvider {
    private final Options myOptions;

    public CommandLineCompletionProvider(Options options) {
        super(true);
        this.myOptions = options;
    }

    @NotNull
    protected String getPrefix(@NotNull String currentTextPrefix) {
        if (currentTextPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentTextPrefix", "org/jetbrains/idea/maven/execution/cmd/CommandLineCompletionProvider", "getPrefix"));
        }
        ParametersListLexer lexer = new ParametersListLexer(currentTextPrefix);
        while (lexer.nextToken()) {
            if (lexer.getTokenEnd() != currentTextPrefix.length()) continue;
            String string = lexer.getCurrentToken();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/cmd/CommandLineCompletionProvider", "getPrefix"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/cmd/CommandLineCompletionProvider", "getPrefix"));
        }
        return "";
    }

    protected LookupElement createLookupElement(@NotNull Option option, @NotNull String text) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "org/jetbrains/idea/maven/execution/cmd/CommandLineCompletionProvider", "createLookupElement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/idea/maven/execution/cmd/CommandLineCompletionProvider", "createLookupElement"));
        }
        LookupElementBuilder res = LookupElementBuilder.create((String)text);
        if (option.getDescription() != null) {
            return TailTypeDecorator.withTail((LookupElement)res.withTypeText(option.getDescription(), true), (TailType)TailType.INSERT_SPACE);
        }
        return res;
    }

    protected abstract void addArgumentVariants(@NotNull CompletionResultSet var1);

    protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/idea/maven/execution/cmd/CommandLineCompletionProvider", "addCompletionVariants"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/idea/maven/execution/cmd/CommandLineCompletionProvider", "addCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/execution/cmd/CommandLineCompletionProvider", "addCompletionVariants"));
        }
        ParametersListLexer lexer = new ParametersListLexer(text);
        int argCount = 0;
        while (lexer.nextToken() && offset >= lexer.getTokenStart()) {
            Option option2;
            if (offset <= lexer.getTokenEnd()) {
                if (argCount == 0) {
                    if (prefix.startsWith("--")) {
                        for (Option option2 : this.myOptions.getOptions()) {
                            if (option2.getLongOpt() == null) continue;
                            result.addElement(this.createLookupElement(option2, "--" + option2.getLongOpt()));
                        }
                    } else if (prefix.startsWith("-")) {
                        for (Option option2 : this.myOptions.getOptions()) {
                            if (option2.getOpt() == null) continue;
                            result.addElement(this.createLookupElement(option2, "-" + option2.getOpt()));
                        }
                    } else {
                        this.addArgumentVariants(result);
                    }
                }
                return;
            }
            if (argCount > 0) {
                --argCount;
                continue;
            }
            String token = lexer.getCurrentToken();
            if (!token.startsWith("-") || (option2 = this.myOptions.getOption(token)) == null) continue;
            int optionArgCount = option2.getArgs();
            if (optionArgCount == -2) {
                argCount = Integer.MAX_VALUE;
                continue;
            }
            if (optionArgCount == -1) continue;
            argCount = optionArgCount;
        }
        if (argCount > 0) {
            return;
        }
        this.addArgumentVariants(result);
    }
}

