/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.aapt;

import com.android.tools.idea.gradle.output.GradleMessage;
import com.android.tools.idea.gradle.output.parser.OutputLineReader;
import com.android.tools.idea.gradle.output.parser.ParsingFailedException;
import com.android.tools.idea.gradle.output.parser.PatternAwareOutputParser;
import com.android.tools.idea.gradle.output.parser.aapt.ReadOnlyDocument;
import com.android.utils.SdkUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.SoftValueHashMap;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractAaptOutputParser
implements PatternAwareOutputParser {
    private static final Logger LOG = Logger.getInstance(AbstractAaptOutputParser.class);
    public static File ourRootDir;
    private static final Pattern PROPERTY_NAME_AND_VALUE;
    private static final Pattern REPEATED_RESOURCE;
    private static final String ORIGINALLY_DEFINED_HERE = "Originally defined here.";
    private static final Pattern NO_RESOURCE_FOUND;
    private static final Pattern REQUIRED_ATTRIBUTE;
    private static final String START_MARKER = "<!-- From: ";
    private static final String END_MARKER = " -->";
    @NotNull
    private static final SoftValueHashMap<String, ReadOnlyDocument> ourDocumentsByPathCache;

    @Nullable
    final Matcher getNextLineMatcher(@NotNull OutputLineReader reader, @NotNull Pattern pattern) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "getNextLineMatcher"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "getNextLineMatcher"));
        }
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        Matcher m = pattern.matcher(line);
        return m.matches() ? m : null;
    }

    @NotNull
    GradleMessage createMessage(@NotNull GradleMessage.Kind kind, @NotNull String text, @Nullable String sourcePath, @Nullable String lineNumberAsText) throws ParsingFailedException {
        Position errorPosition;
        Pair<File, Integer> source;
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "createMessage"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "createMessage"));
        }
        File file = null;
        if (sourcePath != null && !(file = new File(sourcePath)).isFile()) {
            throw new ParsingFailedException();
        }
        int lineNumber = -1;
        if (lineNumberAsText != null) {
            try {
                lineNumber = Integer.parseInt(lineNumberAsText);
            }
            catch (NumberFormatException e) {
                throw new ParsingFailedException();
            }
        }
        int column = -1;
        if (sourcePath != null && (source = this.findSourcePosition(file, lineNumber, text)) != null) {
            file = (File)source.getFirst();
            sourcePath = file.getPath();
            if (source.getSecond() != null) {
                lineNumber = (Integer)source.getSecond();
            }
        }
        if (file != null && lineNumber != -1 && (errorPosition = AbstractAaptOutputParser.findMessagePositionInFile(file, text, lineNumber)) != null) {
            lineNumber = errorPosition.myLineNumber;
            column = errorPosition.myColumn;
        }
        GradleMessage gradleMessage = new GradleMessage(kind, text, sourcePath, lineNumber, column);
        if (gradleMessage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "createMessage"));
        }
        return gradleMessage;
    }

    @Nullable
    private static Position findMessagePositionInFile(@NotNull File file, @NotNull String msgText, int locationLine) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "findMessagePositionInFile"));
        }
        if (msgText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msgText", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "findMessagePositionInFile"));
        }
        Matcher matcher = PROPERTY_NAME_AND_VALUE.matcher(msgText);
        if (matcher.find()) {
            String name = matcher.group(1);
            String value = matcher.group(2);
            if (!value.isEmpty()) {
                return AbstractAaptOutputParser.findText(file, name, value, locationLine);
            }
            Position position1 = AbstractAaptOutputParser.findText(file, name, "\"\"", locationLine);
            Position position2 = AbstractAaptOutputParser.findText(file, name, "''", locationLine);
            if (position1 == null) {
                if (position2 == null) {
                    return AbstractAaptOutputParser.findText(file, name, null, locationLine);
                }
                return position2;
            }
            if (position2 == null) {
                return position1;
            }
            if (position1.myOffset < position2.myOffset) {
                return position1;
            }
            return position2;
        }
        matcher = REPEATED_RESOURCE.matcher(msgText);
        if (matcher.find()) {
            String property = matcher.group(2);
            return AbstractAaptOutputParser.findText(file, property, null, locationLine);
        }
        matcher = NO_RESOURCE_FOUND.matcher(msgText);
        if (matcher.find()) {
            String property = matcher.group(1);
            return AbstractAaptOutputParser.findText(file, property, null, locationLine);
        }
        matcher = REQUIRED_ATTRIBUTE.matcher(msgText);
        if (matcher.find()) {
            String elementName = matcher.group(2);
            return AbstractAaptOutputParser.findText(file, '<' + elementName, null, locationLine);
        }
        if (msgText.endsWith(ORIGINALLY_DEFINED_HERE)) {
            return AbstractAaptOutputParser.findLineStart(file, locationLine);
        }
        return null;
    }

    @Nullable
    private static Position findText(@NotNull File file, @NotNull String first, @Nullable String second, int locationLine) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "findText"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "findText"));
        }
        ReadOnlyDocument document = AbstractAaptOutputParser.getDocument(file);
        if (document == null) {
            return null;
        }
        int offset = document.lineOffset(locationLine);
        if ((long)offset == -1L) {
            return null;
        }
        int resultOffset = document.findText(first, offset);
        if ((long)resultOffset == -1L) {
            return null;
        }
        if (second != null && (long)(resultOffset = document.findText(second, resultOffset + first.length())) == -1L) {
            return null;
        }
        int lineNumber = document.lineNumber(resultOffset);
        int lineOffset = document.lineOffset(lineNumber);
        return new Position(lineNumber, resultOffset - lineOffset + 1, resultOffset);
    }

    @Nullable
    private static Position findLineStart(@NotNull File file, int locationLine) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "findLineStart"));
        }
        ReadOnlyDocument document = AbstractAaptOutputParser.getDocument(file);
        if (document == null) {
            return null;
        }
        int lineOffset = document.lineOffset(locationLine);
        if ((long)lineOffset == -1L) {
            return null;
        }
        int nextLineOffset = document.lineOffset(locationLine + 1);
        if (nextLineOffset == -1) {
            nextLineOffset = document.length();
        }
        int resultOffset = -1;
        for (int i = lineOffset; i < nextLineOffset; ++i) {
            char c = document.charAt(i);
            if (Character.isWhitespace(c)) continue;
            resultOffset = i;
            break;
        }
        if ((long)resultOffset == -1L) {
            return null;
        }
        return new Position(locationLine, resultOffset - lineOffset + 1, resultOffset);
    }

    @Nullable
    private static ReadOnlyDocument getDocument(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "getDocument"));
        }
        String filePath = file.getAbsolutePath();
        ReadOnlyDocument document = (ReadOnlyDocument)ourDocumentsByPathCache.get((Object)filePath);
        if (document == null || document.isStale()) {
            try {
                if (!file.exists()) {
                    if (ourRootDir != null && ourRootDir.isAbsolute() && !file.isAbsolute()) {
                        file = new File(ourRootDir, file.getPath());
                        return AbstractAaptOutputParser.getDocument(file);
                    }
                    return null;
                }
                document = new ReadOnlyDocument(file);
                ourDocumentsByPathCache.put((Object)filePath, (Object)document);
            }
            catch (IOException e) {
                String format = "Unexpected error occurred while reading file '%s'";
                LOG.warn(String.format(format, file.getAbsolutePath()), (Throwable)e);
                return null;
            }
        }
        return document;
    }

    @Nullable
    protected Pair<File, Integer> findSourcePosition(@NotNull File file, int locationLine, String message) {
        File sourceFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "findSourcePosition"));
        }
        if (!file.getPath().endsWith(".xml")) {
            return null;
        }
        ReadOnlyDocument document = AbstractAaptOutputParser.getDocument(file);
        if (document == null) {
            return null;
        }
        String fileName = file.getName();
        boolean isManifest = fileName.equals("AndroidManifest.xml");
        boolean isValueFile = fileName.equals("values.xml");
        int searchStart = isValueFile || isManifest ? document.lineOffset(locationLine) : document.length();
        if ((long)searchStart == -1L) {
            return null;
        }
        int start = document.findTextBackwards(START_MARKER, searchStart);
        assert (start < searchStart);
        if (start == -1 && isManifest && searchStart < document.length() && (long)(searchStart = document.length()) != -1L) {
            start = document.findTextBackwards(START_MARKER, searchStart);
            assert (start < searchStart);
        }
        if (start == -1) {
            return null;
        }
        int end = document.findText(END_MARKER, start += START_MARKER.length());
        if (end == -1) {
            return null;
        }
        String sourcePath = document.subsequence(start, end);
        if (sourcePath.startsWith("file:")) {
            String originalPath = sourcePath;
            sourceFile = new File(sourcePath = AbstractAaptOutputParser.urlToPath(sourcePath));
            if (!sourceFile.exists()) {
                try {
                    sourceFile = SdkUtils.urlToFile((String)originalPath);
                }
                catch (MalformedURLException e) {
                    LOG.warn("Invalid file URL: " + originalPath);
                }
            }
        } else {
            sourceFile = new File(sourcePath);
        }
        if (isValueFile) {
            locationLine = -1;
            Position position = AbstractAaptOutputParser.findMessagePositionInFile(sourceFile, message, 1);
            if (position != null) {
                locationLine = position.myLineNumber;
            }
        }
        return Pair.create((Object)sourceFile, (Object)locationLine);
    }

    @NotNull
    private static String urlToPath(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "urlToPath"));
        }
        if (url.startsWith("file:")) {
            String prefix = url.startsWith("file://") ? "file://" : "file:";
            String string = url.substring(prefix.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "urlToPath"));
            }
            return string;
        }
        String string = url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "urlToPath"));
        }
        return string;
    }

    public static int findResourceLine(@NotNull File file, @NotNull String key) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "findResourceLine"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "findResourceLine"));
        }
        int slash = key.indexOf(47);
        if (slash == -1) {
            assert (false) : slash;
            return -1;
        }
        String type = key.substring(0, slash);
        String name = key.substring(slash + 1);
        return AbstractAaptOutputParser.findValueDeclaration(file, type, name);
    }

    public static int findValueDeclaration(@NotNull File file, @NotNull String type, @NotNull String name) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "findValueDeclaration"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "findValueDeclaration"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/output/parser/aapt/AbstractAaptOutputParser", "findValueDeclaration"));
        }
        if (!file.exists()) {
            return -1;
        }
        ReadOnlyDocument document = AbstractAaptOutputParser.getDocument(file);
        if (document == null) {
            return -1;
        }
        int index = document.findText(name, 0);
        if (index == -1) {
            return -1;
        }
        if (document.findText(name, index + name.length()) == -1) {
            return document.lineNumber(index);
        }
        int nameIndex = document.findText("name=\"" + name + "\"", 0);
        if (nameIndex != -1) {
            return document.lineNumber(nameIndex);
        }
        int lineNumber = AbstractAaptOutputParser.findValueDeclarationViaParse(type, name, document);
        if (lineNumber != -1) {
            return lineNumber;
        }
        assert (index != -1);
        return document.lineNumber(index);
    }

    private static int findValueDeclarationViaParse(final String type, final String name, ReadOnlyDocument document) {
        int column;
        int lineNumber;
        final int[] certain = new int[]{-1, 0};
        final int[] possible = new int[]{-1, 0};
        final AtomicReference<Integer> line = new AtomicReference<Integer>(-1);
        DefaultHandler handler = new DefaultHandler(){
            private int myDepth;
            private Locator myLocator;

            @Override
            public void setDocumentLocator(Locator locator) {
                this.myLocator = locator;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                ++this.myDepth;
                if (this.myDepth == 2 && name.equals(attributes.getValue("name"))) {
                    int lineNumber = this.myLocator.getLineNumber();
                    int column = this.myLocator.getColumnNumber();
                    if (qName.equals(type) || "item".equals(qName) && type.equals(attributes.getValue("type"))) {
                        line.set(lineNumber);
                        certain[0] = lineNumber;
                        certain[1] = column;
                    } else if ((Integer)line.get() < 0) {
                        line.set(-lineNumber);
                        possible[0] = lineNumber;
                        possible[1] = column;
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                --this.myDepth;
            }
        };
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource(new StringReader(document.getContents())), handler);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (certain[0] != -1) {
            lineNumber = certain[0];
            column = certain[1];
        } else {
            lineNumber = possible[0];
            column = possible[1];
        }
        if (lineNumber != -1) {
            int offset = document.lineOffset(lineNumber) + column;
            if ((offset = document.findTextBackwards(name, offset)) != -1) {
                lineNumber = document.lineNumber(offset);
            }
            return lineNumber;
        }
        return -1;
    }

    static {
        PROPERTY_NAME_AND_VALUE = Pattern.compile("\\(at '(.+)' with value '(.*)'\\)");
        REPEATED_RESOURCE = Pattern.compile("Resource entry (.+) already has bag item (.+)\\.");
        NO_RESOURCE_FOUND = Pattern.compile("No resource found that matches the given name: attr '(.+)'\\.");
        REQUIRED_ATTRIBUTE = Pattern.compile("A '(.+)' attribute is required for <(.+)>");
        ourDocumentsByPathCache = new SoftValueHashMap();
    }

    private static class Position {
        final int myLineNumber;
        final int myColumn;
        final int myOffset;

        Position(int lineNumber, int column, int offset) {
            this.myLineNumber = lineNumber;
            this.myColumn = column;
            this.myOffset = offset;
        }
    }
}

