/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local.saxon;

import com.icl.saxon.Bindery;
import com.icl.saxon.Binding;
import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.ObjectValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.TextFragmentValue;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.Navigator;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.GeneralOutputter;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.ExpressionContext;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLGeneralVariable;
import com.icl.saxon.style.XSLParam;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.intellij.plugins.xsltDebugger.rt.engine.local.VariableComparator;
import org.intellij.plugins.xsltDebugger.rt.engine.local.VariableImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon.AbstractSaxonFrame;
import org.w3c.dom.Node;

class SaxonFrameImpl
extends AbstractSaxonFrame<Debugger.StyleFrame, StyleElement>
implements Debugger.StyleFrame {
    private static Field fGeneralUseAllowed;
    private final Context myContext;
    private final int myFrameId;

    SaxonFrameImpl(Debugger.StyleFrame prev, Context context, StyleElement element) {
        super(prev, element);
        this.myContext = context;
        this.myFrameId = context.getBindery().getFrameId();
    }

    public String getInstruction() {
        return ((StyleElement)this.myElement).getDisplayName();
    }

    public List<Debugger.Variable> getVariables() {
        assert (this.isValid());
        ArrayList<Debugger.Variable> variables = new ArrayList<Debugger.Variable>();
        Enumeration[] variableNames = ((StyleElement)this.myElement).getVariableNames();
        this.addVariables((StyleElement)this.myElement, variables, variableNames[0], true);
        this.addVariables((StyleElement)this.myElement, variables, variableNames[1], false);
        Collections.sort(variables, VariableComparator.INSTANCE);
        return variables;
    }

    public Value eval(String expr) throws Debugger.EvaluationException {
        assert (this.isValid());
        try {
            MyDummyElement dummy = new MyDummyElement((StyleElement)this.myElement);
            Expression expression = Expression.make((String)expr, (StaticContext)dummy.getStaticContext());
            return this.convertValue(expression.evaluate(this.myContext));
        }
        catch (XPathException e) {
            throw new Debugger.EvaluationException(e.getMessage());
        }
    }

    private Value convertValue(com.icl.saxon.expr.Value v) throws XPathException {
        return MyValue.create(v, this.myContext);
    }

    void addVariables(StyleElement element, ArrayList<Debugger.Variable> variables, Enumeration enumeration, boolean isGlobal) {
        Context context = this.myContext;
        StaticContext ctx = context.getStaticContext();
        NamePool pool = element.getNamePool();
        Bindery bindery = context.getBindery();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            try {
                String[] parts = name.split("\\^");
                String realname = parts[1];
                int fingerprint = ctx != null ? ctx.getFingerprint(realname, false) : pool.getFingerprint(parts[0], realname);
                Binding binding = element.getVariableBinding(fingerprint);
                Debugger.Variable.Kind kind = binding instanceof XSLParam ? Debugger.Variable.Kind.PARAMETER : Debugger.Variable.Kind.VARIABLE;
                com.icl.saxon.expr.Value value = bindery.getValue(binding, this.myFrameId);
                if (binding instanceof XSLGeneralVariable) {
                    XSLGeneralVariable v = (XSLGeneralVariable)binding;
                    String id = v.getSystemId();
                    variables.add(new VariableImpl(realname, this.convertValue(value), isGlobal, kind, id != null ? id.replaceAll(" ", "%20") : null, v.getLineNumber()));
                    continue;
                }
                variables.add(new VariableImpl(realname, this.convertValue(value), isGlobal, kind, null, -1));
            }
            catch (XPathException e) {
                e.printStackTrace();
            }
        }
    }

    private static void resetGeneralUseAllowed(FragmentValue value) {
        try {
            fGeneralUseAllowed.set(value, false);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            fGeneralUseAllowed = SingletonNodeSet.class.getDeclaredField("generalUseAllowed");
            fGeneralUseAllowed.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            fGeneralUseAllowed = null;
            System.err.println("Failed to get field com.icl.saxon.expr.SingletonNodeSet.generalUseAllowed - incompatible Saxon version?");
            e.printStackTrace();
        }
    }

    private static class MyDummyElement
    extends StyleElement {
        private final StyleElement myElement;

        public MyDummyElement(StyleElement element) {
            this.myElement = element;
            this.substituteFor(element);
        }

        public void prepareAttributes() throws TransformerConfigurationException {
        }

        public void process(Context context) throws TransformerException {
        }

        public StaticContext getStaticContext() {
            return new ExpressionContext((StyleElement)this);
        }

        public Node getPreviousSibling() {
            return this.myElement.getPreviousSibling();
        }
    }

    private static class MyValue
    implements Value {
        private final Object myValue;
        private final Value.Type myType;

        public MyValue(Object value, String type) {
            this.myValue = value;
            this.myType = new Value.ObjectType(type);
        }

        public MyValue(Object value, int type) {
            this.myValue = value;
            this.myType = MyValue.mapType(type);
        }

        public Object getValue() {
            return this.myValue;
        }

        public Value.Type getType() {
            return this.myType;
        }

        private static Value.Type mapType(int type) {
            switch (type) {
                case 1: {
                    return Value.XPathType.BOOLEAN;
                }
                case 4: {
                    return Value.XPathType.NODESET;
                }
                case 2: {
                    return Value.XPathType.NUMBER;
                }
                case 3: {
                    return Value.XPathType.STRING;
                }
                case 6: {
                    return Value.XPathType.OBJECT;
                }
            }
            return Value.XPathType.UNKNOWN;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Value create(com.icl.saxon.expr.Value v, Context context) throws XPathException {
            if (v instanceof NodeSetValue) {
                if (v instanceof FragmentValue) {
                    FragmentValue value = (FragmentValue)v;
                    boolean b = value.isGeneralUseAllowed();
                    try {
                        if (!b) {
                            value.allowGeneralUse();
                        }
                        DocumentInfo node = value.getRootNode();
                        GeneralOutputter outputter = new GeneralOutputter(node.getNamePool());
                        StringWriter writer = new StringWriter();
                        Properties props = new Properties();
                        props.setProperty("omit-xml-declaration", "yes");
                        outputter.setOutputDestination(props, (Result)new StreamResult(writer));
                        node.copy((Outputter)outputter);
                        MyValue myValue = new MyValue((Object)writer.toString(), v.getDataType());
                        return myValue;
                    }
                    catch (TransformerException e) {
                        MyValue outputter = new MyValue((Object)v.asString(), v.getDataType());
                        return outputter;
                    }
                    finally {
                        if (!b && fGeneralUseAllowed != null) {
                            SaxonFrameImpl.resetGeneralUseAllowed(value);
                        }
                    }
                }
                if (v instanceof TextFragmentValue) {
                    return new MyValue((Object)v.asString(), 3);
                }
                ArrayList<Value.Node> list = new ArrayList<Value.Node>();
                NodeEnumeration nodeEnumeration = ((NodeSetValue)v).enumerate();
                while (nodeEnumeration.hasMoreElements()) {
                    NodeInfo node = nodeEnumeration.nextElement();
                    String path = Navigator.getPath((NodeInfo)node);
                    String id = node.getSystemId();
                    if (id != null) {
                        try {
                            list.add(new Value.Node(new URI(id.replaceAll(" ", "%20")).normalize().toASCIIString(), node.getLineNumber(), path, node.getStringValue()));
                        }
                        catch (URISyntaxException e) {
                            SaxonFrameImpl.debug(e);
                            list.add(new Value.Node(id, node.getLineNumber(), path, node.getStringValue()));
                        }
                        continue;
                    }
                    list.add(new Value.Node(null, -1, path, node.getStringValue()));
                }
                return new MyValue((Object)new Value.NodeSet(v.asString(), list), v.getDataType());
            }
            if (v instanceof ObjectValue) {
                Object o;
                return new MyValue(o, (o = ((ObjectValue)v).getObject()) != null ? o.getClass().getName() : "null");
            }
            if (v != null) {
                return new MyValue((Object)v.evaluateAsString(context), v.getDataType());
            }
            return new MyValue((Object)"", "<uninitialized>");
        }
    }
}

