/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.loader;

import java.io.File;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classloader.MutableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.service.ServiceLocator;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.connection.AbstractConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.ActionAwareConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.BuildActionRunnerBackedConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.CancellableConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.ConnectionVersion4BackedConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.InternalConnectionBackedConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.ModelBuilderBackedConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.NoToolingApiConnection;
import org.gradle.tooling.internal.consumer.connection.NonCancellableConsumerConnectionAdapter;
import org.gradle.tooling.internal.consumer.converters.ConsumerTargetTypeProvider;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.protocol.BuildActionRunner;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.internal.protocol.InternalBuildActionExecutor;
import org.gradle.tooling.internal.protocol.InternalCancellableConnection;
import org.gradle.tooling.internal.protocol.InternalConnection;
import org.gradle.tooling.internal.protocol.ModelBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultToolingImplementationLoader
implements ToolingImplementationLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultToolingImplementationLoader.class);
    private final ClassLoader classLoader;

    public DefaultToolingImplementationLoader() {
        this(DefaultToolingImplementationLoader.class.getClassLoader());
    }

    DefaultToolingImplementationLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ConsumerConnection create(Distribution distribution, ProgressLoggerFactory progressLoggerFactory, ConnectionParameters connectionParameters, BuildCancellationToken cancellationToken) {
        LOGGER.debug("Using tooling provider from {}", (Object)distribution.getDisplayName());
        ClassLoader classLoader = this.createImplementationClassLoader(distribution, progressLoggerFactory, connectionParameters.getGradleUserHomeDir(), cancellationToken);
        ServiceLocator serviceLocator = new ServiceLocator(new ClassLoader[]{classLoader});
        try {
            AbstractConsumerConnection adaptedConnection;
            ServiceLocator.ServiceFactory factory = serviceLocator.findFactory(ConnectionVersion4.class);
            if (factory == null) {
                return new NoToolingApiConnection(distribution);
            }
            ConnectionVersion4 connection = (ConnectionVersion4)factory.create();
            ProtocolToModelAdapter adapter = new ProtocolToModelAdapter(new ConsumerTargetTypeProvider());
            ModelMapping modelMapping = new ModelMapping();
            if (connection instanceof ModelBuilder && connection instanceof InternalCancellableConnection) {
                adaptedConnection = new CancellableConsumerConnection(connection, modelMapping, adapter);
            } else if (connection instanceof ModelBuilder && connection instanceof InternalBuildActionExecutor) {
                adaptedConnection = new ActionAwareConsumerConnection(connection, modelMapping, adapter);
            } else if (connection instanceof ModelBuilder) {
                adaptedConnection = new ModelBuilderBackedConsumerConnection(connection, modelMapping, adapter);
            } else if (connection instanceof BuildActionRunner) {
                adaptedConnection = new BuildActionRunnerBackedConsumerConnection(connection, modelMapping, adapter);
            } else if (connection instanceof InternalConnection) {
                adaptedConnection = new InternalConnectionBackedConsumerConnection(connection, modelMapping, adapter);
            } else {
                return new ConnectionVersion4BackedConsumerConnection(distribution, connection, adapter);
            }
            ((AbstractConsumerConnection)adaptedConnection).configure(connectionParameters);
            if (!adaptedConnection.getVersionDetails().supportsCancellation()) {
                return new NonCancellableConsumerConnectionAdapter(adaptedConnection);
            }
            return adaptedConnection;
        }
        catch (UnsupportedVersionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new GradleConnectionException(String.format("Could not create an instance of Tooling API implementation using the specified %s.", distribution.getDisplayName()), t);
        }
    }

    private ClassLoader createImplementationClassLoader(Distribution distribution, ProgressLoggerFactory progressLoggerFactory, File userHomeDir, BuildCancellationToken cancellationToken) {
        ClassPath implementationClasspath = distribution.getToolingImplementationClasspath(progressLoggerFactory, userHomeDir, cancellationToken);
        LOGGER.debug("Using tooling provider classpath: {}", (Object)implementationClasspath);
        MultiParentClassLoader parentObfuscatingClassLoader = new MultiParentClassLoader(new ClassLoader[]{this.classLoader});
        FilteringClassLoader filteringClassLoader = new FilteringClassLoader((ClassLoader)parentObfuscatingClassLoader);
        filteringClassLoader.allowPackage("org.gradle.tooling.internal.protocol");
        return new MutableURLClassLoader((ClassLoader)filteringClassLoader, implementationClasspath.getAsURLArray());
    }
}

