/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgRepositorySelectorComponent;
import org.zmlx.hg4idea.util.HgUtil;

public class HgPushDialog
extends DialogWrapper {
    private final Project myProject;
    private JPanel contentPanel;
    private JCheckBox revisionCbx;
    private JTextField revisionTxt;
    private HgRepositorySelectorComponent hgRepositorySelectorComponent;
    private JCheckBox forceCheckBox;
    private JCheckBox branchCheckBox;
    private JComboBox branchComboBox;
    private EditorComboBox myRepositoryURL;
    private JCheckBox newBranchCheckBox;
    private JComboBox myBookmarkComboBox;
    private JCheckBox myBookmarkCheckBox;
    private String myCurrentRepositoryUrl;

    public HgPushDialog(Project project, Collection<HgRepository> repos, @Nullable HgRepository selectedRepo) {
        super(project, false);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.hgRepositorySelectorComponent.setTitle("Select repository to push from");
        this.hgRepositorySelectorComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HgPushDialog.this.updateRepository();
            }
        });
        UpdatingListener updatingListener = new UpdatingListener();
        this.revisionCbx.addChangeListener(updatingListener);
        this.branchCheckBox.addChangeListener(updatingListener);
        this.myBookmarkCheckBox.addChangeListener(updatingListener);
        this.revisionTxt.getDocument().addDocumentListener(updatingListener);
        new ComboboxSpeedSearch(this.branchComboBox);
        new ComboboxSpeedSearch(this.myBookmarkComboBox);
        this.setTitle(HgVcsMessages.message("hg4idea.push.dialog.title", new Object[0]));
        this.setOKButtonText("Push");
        this.init();
        this.setRoots(repos, selectedRepo);
    }

    private void setRoots(@NotNull Collection<HgRepository> repos, @Nullable HgRepository selectedRepo) {
        if (repos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repos", "org/zmlx/hg4idea/ui/HgPushDialog", "setRoots"));
        }
        this.hgRepositorySelectorComponent.setRoots(repos);
        this.hgRepositorySelectorComponent.setSelectedRoot(selectedRepo);
        this.updateRepository();
    }

    public void createUIComponents() {
        this.myRepositoryURL = new EditorComboBox("");
        this.myRepositoryURL.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                HgPushDialog.this.myCurrentRepositoryUrl = HgPushDialog.this.myRepositoryURL.getText();
                HgPushDialog.this.setOKActionEnabled(!StringUtil.isEmptyOrSpaces((String)HgPushDialog.this.myRepositoryURL.getText()));
            }
        });
    }

    private void addPathsFromHgrc(VirtualFile repo) {
        Collection<String> paths = HgUtil.getRepositoryPaths(this.myProject, repo);
        for (String path : paths) {
            this.myRepositoryURL.prependItem(path);
        }
    }

    @NotNull
    public HgRepository getRepository() {
        HgRepository hgRepository = this.hgRepositorySelectorComponent.getRepository();
        if (hgRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/ui/HgPushDialog", "getRepository"));
        }
        return hgRepository;
    }

    @NotNull
    public String getTarget() {
        String string = this.myCurrentRepositoryUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/ui/HgPushDialog", "getTarget"));
        }
        return string;
    }

    @Nullable
    public String getRevision() {
        return this.revisionCbx.isSelected() ? this.revisionTxt.getText() : null;
    }

    @Nullable
    public String getBranch() {
        return this.branchCheckBox.isSelected() ? (String)this.branchComboBox.getSelectedItem() : null;
    }

    @Nullable
    public String getBookmarkName() {
        return this.myBookmarkCheckBox.isSelected() ? (String)this.myBookmarkComboBox.getSelectedItem() : null;
    }

    public boolean isForce() {
        return this.forceCheckBox.isSelected();
    }

    public boolean isNewBranch() {
        return this.newBranchCheckBox.isSelected();
    }

    protected JComponent createCenterPanel() {
        return this.contentPanel;
    }

    protected String getHelpId() {
        return "reference.mercurial.push.dialog";
    }

    public void updateRepository() {
        HgRepository repo = this.hgRepositorySelectorComponent.getRepository();
        String defaultPath = HgUtil.getRepositoryDefaultPushPath(repo);
        this.addPathsFromHgrc(repo.getRoot());
        if (defaultPath != null) {
            this.updateRepositoryUrlText(HgUtil.removePasswordIfNeeded(defaultPath));
            this.myCurrentRepositoryUrl = defaultPath;
        }
        this.updateComboBoxes(repo);
    }

    private void updateComboBoxes(HgRepository repo) {
        Set<String> branches = repo.getOpenedBranches();
        List<String> bookmarkNames = HgUtil.getNamesWithoutHashes(repo.getBookmarks());
        this.branchComboBox.setModel(new DefaultComboBoxModel<Object>(branches.toArray()));
        this.branchComboBox.setSelectedItem(repo.getCurrentBranch());
        this.myBookmarkComboBox.setModel(new DefaultComboBoxModel<Object>(bookmarkNames.toArray()));
    }

    private void updateRepositoryUrlText(String defaultPath) {
        if (defaultPath != null) {
            this.myRepositoryURL.setSelectedItem((Object)defaultPath);
            this.update();
        }
    }

    private void update() {
        this.setOKActionEnabled(this.validateOptions());
        this.revisionTxt.setEnabled(this.revisionCbx.isSelected());
        this.branchComboBox.setEnabled(this.branchCheckBox.isSelected());
        this.myBookmarkComboBox.setEnabled(this.myBookmarkCheckBox.isSelected());
    }

    private boolean validateOptions() {
        return !(StringUtil.isEmptyOrSpaces((String)this.myCurrentRepositoryUrl) || this.revisionCbx.isSelected() && StringUtil.isEmptyOrSpaces((String)this.revisionTxt.getText()) || this.branchCheckBox.isSelected() && this.branchComboBox.getSelectedItem() == null);
    }

    protected String getDimensionServiceKey() {
        return HgPushDialog.class.getName();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HgRepositorySelectorComponent hgRepositorySelectorComponent;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JComboBox jComboBox;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JComboBox jComboBox2;
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.contentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 2, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 0, new Dimension(-1, 100), null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Options", (int)0, (int)0, null, null));
        this.revisionTxt = jTextField = new JTextField();
        jTextField.setText("tip");
        ((Component)jTextField).setEnabled(false);
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(2, 1, 1, 2, 0, 3, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 0, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Branch Options", 0, 0, null, null));
        this.branchComboBox = jComboBox2 = new JComboBox();
        jPanel4.add(jComboBox2, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 4, null, null, null));
        this.branchCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("org/zmlx/hg4idea/HgVcsMessages").getString("hg4idea.push.branch"));
        jPanel4.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.newBranchCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("org/zmlx/hg4idea/HgVcsMessages").getString("hg4idea.push.asNewBranch"));
        jCheckBox4.setHorizontalAlignment(0);
        jCheckBox4.setHorizontalTextPosition(11);
        ((Component)jCheckBox4).setEnabled(true);
        jPanel4.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myBookmarkComboBox = jComboBox = new JComboBox();
        jComboBox.setEditable(false);
        jPanel4.add(jComboBox, new GridConstraints(2, 1, 1, 2, 8, 1, 2, 4, null, null, null));
        this.myBookmarkCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("org/zmlx/hg4idea/HgVcsMessages").getString("hg4idea.push.bookmark"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.revisionCbx = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Revision:");
        jCheckBox2.setMnemonic('R');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.forceCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/zmlx/hg4idea/HgVcsMessages").getString("hg4idea.push.force"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.hgRepositorySelectorComponent = hgRepositorySelectorComponent = new HgRepositorySelectorComponent();
        JComponent jComponent = hgRepositorySelectorComponent.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("&Destination Repository URL");
        jPanel2.add((Component)titledSeparator, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        EditorComboBox editorComboBox = this.myRepositoryURL;
        editorComboBox.setEditable(true);
        jPanel2.add((Component)editorComboBox, new GridConstraints(2, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class UpdatingListener
    implements ChangeListener,
    javax.swing.event.DocumentListener {
        private UpdatingListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            HgPushDialog.this.update();
        }

        @Override
        public void insertUpdate(javax.swing.event.DocumentEvent e) {
            HgPushDialog.this.update();
        }

        @Override
        public void removeUpdate(javax.swing.event.DocumentEvent e) {
            HgPushDialog.this.update();
        }

        @Override
        public void changedUpdate(javax.swing.event.DocumentEvent e) {
            HgPushDialog.this.update();
        }
    }
}

