/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlSuppressionProvider
implements InspectionSuppressor {
    public static final ExtensionPointName<XmlSuppressionProvider> EP_NAME = new ExtensionPointName("com.intellij.xml.xmlSuppressionProvider");

    public static boolean isSuppressed(@NotNull PsiElement element, @NotNull String inspectionId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/XmlSuppressionProvider", "isSuppressed"));
        }
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/codeInspection/XmlSuppressionProvider", "isSuppressed"));
        }
        for (XmlSuppressionProvider provider : (XmlSuppressionProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider.isProviderAvailable(element.getContainingFile()) || !provider.isSuppressedFor(element, inspectionId)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isProviderAvailable(@NotNull PsiFile var1);

    @Override
    public abstract boolean isSuppressedFor(@NotNull PsiElement var1, @NotNull String var2);

    public abstract void suppressForFile(@NotNull PsiElement var1, @NotNull String var2);

    public abstract void suppressForTag(@NotNull PsiElement var1, @NotNull String var2);

    @Override
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, String toolShortName) {
        return XmlSuppressableInspectionTool.getSuppressFixes(toolShortName, this);
    }
}

