/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashSet;
import java.util.Set;

public class VcsFileListenerContextHelper {
    private final Set<FilePath> myDeletedContext = new HashSet<FilePath>();
    private final Set<VirtualFile> myAddContext = new HashSet<VirtualFile>();

    VcsFileListenerContextHelper(Project project) {
    }

    public static VcsFileListenerContextHelper getInstance(Project project) {
        return ServiceManager.getService(project, VcsFileListenerContextHelper.class);
    }

    public void ignoreDeleted(FilePath filePath) {
        this.myDeletedContext.add(filePath);
    }

    public boolean isDeletionIgnored(FilePath filePath) {
        return this.myDeletedContext.contains(filePath);
    }

    public void ignoreAdded(VirtualFile virtualFile) {
        this.myAddContext.add(virtualFile);
    }

    public boolean isAdditionIgnored(VirtualFile virtualFile) {
        return this.myAddContext.contains(virtualFile);
    }

    public void possiblySwitchActivation(boolean isActive) {
    }

    public void clearContext() {
        this.myAddContext.clear();
        this.myDeletedContext.clear();
    }
}

