/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.meta.PsiPresentableMetaData;
import javax.swing.Icon;

public class ComputableIcon {
    private Icon myIcon;
    private Computable<Icon> myEvaluator;
    private boolean myEvaluated;

    public ComputableIcon(Computable<Icon> evaluator) {
        this.myEvaluator = evaluator;
    }

    public Icon getIcon() {
        if (!this.myEvaluated) {
            this.myIcon = (Icon)this.myEvaluator.compute();
            this.myEvaluator = null;
            this.myEvaluated = true;
        }
        return this.myIcon;
    }

    public static ComputableIcon create(final Icon icon) {
        return new ComputableIcon(new Computable<Icon>(){

            public Icon compute() {
                return icon;
            }
        });
    }

    public static ComputableIcon create(final ItemPresentation presentation, final boolean isOpen) {
        return new ComputableIcon(new Computable<Icon>(){

            public Icon compute() {
                return presentation.getIcon(isOpen);
            }
        });
    }

    public static ComputableIcon create(final PsiPresentableMetaData data) {
        return new ComputableIcon(new Computable<Icon>(){

            public Icon compute() {
                return data.getIcon();
            }
        });
    }

    public static ComputableIcon create(final VirtualFile file) {
        return new ComputableIcon(new Computable<Icon>(){

            public Icon compute() {
                return VirtualFilePresentation.getIcon(file);
            }
        });
    }
}

