/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.tabs.impl.JBEditorTabsPainter;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;

public class DefaultEditorTabsPainter
implements JBEditorTabsPainter {
    private static final int ACTIVE_TAB_SHADOW_HEIGHT = 3;

    @Override
    public void doPaintInactive(Graphics2D g2d, Rectangle effectiveBounds, int x, int y, int w, int h, Color tabColor, int row, int column, boolean vertical) {
        if (tabColor != null) {
            g2d.setPaint(UIUtil.getGradientPaint((float)x, (float)y, (Color)Gray._200, (float)x, (float)(y + effectiveBounds.height), (Color)Gray._130));
            g2d.fillRect(x, y, w, h);
            g2d.setColor(ColorUtil.toAlpha((Color)tabColor, (int)150));
            g2d.fillRect(x, y, w, h);
        } else {
            g2d.setPaint(UIUtil.getGradientPaint((float)x, (float)y, (Color)Gray._255.withAlpha(180), (float)x, (float)(y + effectiveBounds.height), (Color)Gray._255.withAlpha(100)));
            g2d.fillRect(x, y, w, h);
        }
        if (row == 0) {
            g2d.setColor(Gray._200.withAlpha(200));
        } else {
            g2d.setColor(Gray._255.withAlpha(100));
        }
        g2d.drawLine(x, y, x + w - 1, y);
        if (!vertical) {
            DefaultEditorTabsPainter.drawShadow(g2d, x, w, y + h);
        }
    }

    private static void drawShadow(Graphics2D g, int x, int w, int shadowBottom) {
        int shadowTop = shadowBottom - 3;
        g.setPaint(UIUtil.getGradientPaint((float)x, (float)shadowTop, (Color)Gray.TRANSPARENT, (float)x, (float)shadowBottom, (Color)new Color(0, 0, 0, 30)));
        g.fillRect(x, shadowTop, w, 3);
    }

    @Override
    public void doPaintBackground(Graphics2D g, Rectangle clip, boolean vertical, Rectangle rectangle) {
        g.setColor(UIUtil.getPanelBackground());
        g.fill(clip);
        g.setColor(new Color(0, 0, 0, 80));
        g.fill(clip);
        int x = rectangle.x;
        int y = rectangle.y;
        g.setPaint(UIUtil.getGradientPaint((float)x, (float)y, (Color)new Color(255, 255, 255, 160), (float)x, (float)(rectangle.y + rectangle.height), (Color)new Color(255, 255, 255, 120)));
        g.fillRect(x, rectangle.y, rectangle.width, rectangle.height + (vertical ? 1 : 0));
        if (!vertical) {
            g.setColor((Color)Gray._210);
            g.drawLine(x, rectangle.y, x + rectangle.width, rectangle.y);
            DefaultEditorTabsPainter.drawShadow(g, rectangle.x, rectangle.width, rectangle.y + rectangle.height);
        }
    }

    private static Color multiplyColor(Color c) {
        return new Color(c.getRed() * c.getRed() / 255, c.getGreen() * c.getGreen() / 255, c.getBlue() * c.getBlue() / 255);
    }

    @Override
    public void paintSelectionAndBorder(Graphics2D g2d, Rectangle rect, JBTabsImpl.ShapeInfo selectedShape, Insets insets, Color tabColor, boolean horizontalTabs) {
        Insets i = selectedShape.path.transformInsets(insets);
        int _x = rect.x;
        int _y = rect.y;
        int _height = rect.height;
        if (!horizontalTabs) {
            g2d.setColor(new Color(0, 0, 0, 45));
            g2d.draw(selectedShape.labelPath.transformLine(i.left, selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4), selectedShape.path.getMaxX(), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4)));
            g2d.setColor(new Color(0, 0, 0, 15));
            g2d.draw(selectedShape.labelPath.transformLine(i.left, selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(5), selectedShape.path.getMaxX(), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(5)));
        }
        if (tabColor != null) {
            g2d.setColor(DefaultEditorTabsPainter.multiplyColor(tabColor));
            g2d.fill(selectedShape.fillPath.getShape());
            g2d.setPaint(UIUtil.getGradientPaint((float)_x, (float)_y, (Color)Gray._255.withAlpha(150), (float)_x, (float)(_y + _height), (Color)Gray._255.withAlpha(0)));
        } else {
            g2d.setPaint(UIUtil.getGradientPaint((float)_x, (float)_y, (Color)Gray._255, (float)_x, (float)(_y + _height), (Color)Gray._230));
        }
        g2d.fill(selectedShape.fillPath.getShape());
        g2d.setColor(Gray._255.withAlpha(180));
        g2d.draw(selectedShape.fillPath.getShape());
        g2d.draw(selectedShape.labelPath.transformLine(selectedShape.labelPath.getMaxX() - selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getY() + selectedShape.labelPath.deltaY(1), selectedShape.labelPath.getMaxX() - selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4)));
        if (!horizontalTabs) {
            g2d.setColor(Gray._0.withAlpha(30));
            g2d.draw(selectedShape.labelPath.transformLine(selectedShape.labelPath.getMaxX() + selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getY() + selectedShape.labelPath.deltaY(1), selectedShape.labelPath.getMaxX() + selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4)));
            g2d.draw(selectedShape.labelPath.transformLine(selectedShape.labelPath.getX() - selectedShape.labelPath.deltaX(horizontalTabs ? 2 : 1), selectedShape.labelPath.getY() + selectedShape.labelPath.deltaY(1), selectedShape.labelPath.getX() - selectedShape.labelPath.deltaX(horizontalTabs ? 2 : 1), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4)));
        }
        g2d.setColor(new Color(0, 0, 0, 50));
        g2d.draw(selectedShape.labelPath.transformLine(i.left, selectedShape.labelPath.getMaxY(), selectedShape.path.getMaxX(), selectedShape.labelPath.getMaxY()));
    }

    @Override
    public Color getBackgroundColor() {
        return Gray._142;
    }
}

