/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.HTTPMethod;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.net.ssl.HostnameVerifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RequestBuilder {
    private static final boolean ourWrapClassLoader = SystemInfo.isJavaVersionAtLeast((String)"1.7") && !SystemProperties.getBooleanProperty((String)"idea.parallel.class.loader", (boolean)false);
    final String myUrl;
    int myConnectTimeout;
    int myTimeout;
    int myRedirectLimit;
    boolean myGzip;
    boolean myForceHttps;
    HostnameVerifier myHostnameVerifier;
    String myUserAgent;
    String myAccept;
    HTTPMethod myMethod;

    RequestBuilder(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/RequestBuilder", "<init>"));
        }
        this.myConnectTimeout = HttpConfigurable.CONNECTION_TIMEOUT;
        this.myTimeout = HttpConfigurable.READ_TIMEOUT;
        this.myRedirectLimit = HttpConfigurable.REDIRECT_LIMIT;
        this.myGzip = true;
        this.myUrl = url;
    }

    @NotNull
    public RequestBuilder connectTimeout(int value) {
        this.myConnectTimeout = value;
        RequestBuilder requestBuilder = this;
        if (requestBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/RequestBuilder", "connectTimeout"));
        }
        return requestBuilder;
    }

    @NotNull
    public RequestBuilder readTimeout(int value) {
        this.myTimeout = value;
        RequestBuilder requestBuilder = this;
        if (requestBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/RequestBuilder", "readTimeout"));
        }
        return requestBuilder;
    }

    @NotNull
    public RequestBuilder redirectLimit(int redirectLimit) {
        this.myRedirectLimit = redirectLimit;
        RequestBuilder requestBuilder = this;
        if (requestBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/RequestBuilder", "redirectLimit"));
        }
        return requestBuilder;
    }

    @NotNull
    public RequestBuilder gzip(boolean value) {
        this.myGzip = value;
        RequestBuilder requestBuilder = this;
        if (requestBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/RequestBuilder", "gzip"));
        }
        return requestBuilder;
    }

    @NotNull
    public RequestBuilder forceHttps(boolean forceHttps) {
        this.myForceHttps = forceHttps;
        RequestBuilder requestBuilder = this;
        if (requestBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/RequestBuilder", "forceHttps"));
        }
        return requestBuilder;
    }

    @NotNull
    public RequestBuilder hostNameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
        this.myHostnameVerifier = hostnameVerifier;
        RequestBuilder requestBuilder = this;
        if (requestBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/RequestBuilder", "hostNameVerifier"));
        }
        return requestBuilder;
    }

    @NotNull
    public RequestBuilder userAgent(@Nullable String userAgent) {
        this.myUserAgent = userAgent;
        RequestBuilder requestBuilder = this;
        if (requestBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/RequestBuilder", "userAgent"));
        }
        return requestBuilder;
    }

    @NotNull
    public RequestBuilder productNameAsUserAgent() {
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isDisposed()) {
            RequestBuilder requestBuilder = this.userAgent(ApplicationInfo.getInstance().getVersionName());
            if (requestBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/RequestBuilder", "productNameAsUserAgent"));
            }
            return requestBuilder;
        }
        RequestBuilder requestBuilder = this.userAgent("IntelliJ");
        if (requestBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/RequestBuilder", "productNameAsUserAgent"));
        }
        return requestBuilder;
    }

    @NotNull
    public RequestBuilder accept(@Nullable String mimeType) {
        this.myAccept = mimeType;
        RequestBuilder requestBuilder = this;
        if (requestBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/RequestBuilder", "accept"));
        }
        return requestBuilder;
    }

    public <T> T connect(@NotNull HttpRequests.RequestProcessor<T> processor) throws IOException {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/io/RequestBuilder", "connect"));
        }
        if (ourWrapClassLoader) {
            return HttpRequests.wrapAndProcess(this, processor);
        }
        return HttpRequests.process(this, processor);
    }

    public <T> T connect(@NotNull HttpRequests.RequestProcessor<T> processor, T errorValue, @Nullable Logger logger) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/io/RequestBuilder", "connect"));
        }
        try {
            return this.connect(processor);
        }
        catch (Throwable e) {
            if (logger != null) {
                logger.warn(e);
            }
            return errorValue;
        }
    }

    public void saveToFile(final @NotNull File file, final @Nullable ProgressIndicator indicator) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/RequestBuilder", "saveToFile"));
        }
        this.connect(new HttpRequests.RequestProcessor<Void>(){

            @Override
            public Void process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/io/RequestBuilder$1", "process"));
                }
                request.saveToFile(file, indicator);
                return null;
            }
        });
    }

    @NotNull
    public byte[] readBytes(final @Nullable ProgressIndicator indicator) throws IOException {
        byte[] byArray = this.connect(new HttpRequests.RequestProcessor<byte[]>(){

            @Override
            public byte[] process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/io/RequestBuilder$2", "process"));
                }
                return request.readBytes(indicator);
            }
        });
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/RequestBuilder", "readBytes"));
        }
        return byArray;
    }

    @NotNull
    public String readString(final @Nullable ProgressIndicator indicator) throws IOException {
        String string = this.connect(new HttpRequests.RequestProcessor<String>(){

            @Override
            public String process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/io/RequestBuilder$3", "process"));
                }
                int contentLength = request.getConnection().getContentLength();
                BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(contentLength > 0 ? contentLength : 16384);
                NetUtils.copyStreamContent(indicator, request.getInputStream(), (OutputStream)out, contentLength);
                return new String(out.getInternalBuffer(), 0, out.size(), HttpRequests.getCharset(request));
            }
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/RequestBuilder", "readString"));
        }
        return string;
    }
}

