/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs;

import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectProcedure;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;

public class DefinitionMap {
    private final TIntObjectHashMap<TIntHashSet> myMap = new TIntObjectHashMap();

    public void registerDef(Instruction varInsn, int varId) {
        TIntHashSet defs = (TIntHashSet)this.myMap.get(varId);
        if (defs == null) {
            defs = new TIntHashSet();
            this.myMap.put(varId, (Object)defs);
        } else {
            defs.clear();
        }
        defs.add(varInsn.num());
    }

    public void merge(DefinitionMap map2) {
        map2.myMap.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntHashSet>(){

            public boolean execute(int num, TIntHashSet defs) {
                TIntHashSet defs2 = (TIntHashSet)DefinitionMap.this.myMap.get(num);
                if (defs2 == null) {
                    defs2 = new TIntHashSet(defs.toArray());
                    DefinitionMap.this.myMap.put(num, (Object)defs2);
                } else {
                    defs2.addAll(defs.toArray());
                }
                return true;
            }
        });
    }

    public boolean eq(final DefinitionMap m2) {
        if (this.myMap.size() != m2.myMap.size()) {
            return false;
        }
        return this.myMap.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntHashSet>(){

            public boolean execute(int num, TIntHashSet defs1) {
                TIntHashSet defs2 = (TIntHashSet)m2.myMap.get(num);
                return defs2 != null && defs2.equals((Object)defs1);
            }
        });
    }

    public void copyFrom(DefinitionMap map, int fromIndex, int toIndex) {
        TIntHashSet defs = (TIntHashSet)map.myMap.get(fromIndex);
        if (defs == null) {
            defs = new TIntHashSet();
        }
        this.myMap.put(toIndex, (Object)defs);
    }

    @Nullable
    public int[] getDefinitions(int varId) {
        TIntHashSet set = (TIntHashSet)this.myMap.get(varId);
        return set == null ? null : set.toArray();
    }

    public void forEachValue(TObjectProcedure<TIntHashSet> procedure) {
        this.myMap.forEachValue(procedure);
    }
}

