/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.SourceLineCounterUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class PackageAnnotator {
    private static final Logger LOG = Logger.getInstance((String)("#" + PackageAnnotator.class.getName()));
    private final PsiPackage myPackage;
    private final Project myProject;
    private final PsiManager myManager;
    private final CoverageDataManager myCoverageManager;

    public PackageAnnotator(PsiPackage aPackage) {
        this.myPackage = aPackage;
        this.myProject = this.myPackage.getProject();
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.myCoverageManager = CoverageDataManager.getInstance(this.myProject);
    }

    public void annotate(CoverageSuitesBundle suite, Annotator annotator) {
        PackageCoverageInfo info;
        ProjectData data = suite.getCoverageData();
        if (data == null) {
            return;
        }
        String qualifiedName = this.myPackage.getQualifiedName();
        boolean filtered = false;
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            if (!((JavaCoverageSuite)coverageSuite).isPackageFiltered(qualifiedName)) continue;
            filtered = true;
            break;
        }
        if (!filtered) {
            return;
        }
        GlobalSearchScope scope = suite.getSearchScope(this.myProject);
        Module[] modules = this.myCoverageManager.doInReadActionIfProjectOpen(new Computable<Module[]>(){

            public Module[] compute() {
                return ModuleManager.getInstance((Project)PackageAnnotator.this.myProject).getModules();
            }
        });
        if (modules == null) {
            return;
        }
        HashMap packageCoverageMap = new HashMap();
        HashMap flattenPackageCoverageMap = new HashMap();
        for (final Module module : modules) {
            File outputRoot;
            VirtualFile testPackageRoot;
            File outputRoot2;
            if (!scope.isSearchInModuleContent(module)) continue;
            String rootPackageVMName = qualifiedName.replaceAll("\\.", "/");
            VirtualFile output = this.myCoverageManager.doInReadActionIfProjectOpen(new Computable<VirtualFile>(){

                @Nullable
                public VirtualFile compute() {
                    return CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
                }
            });
            if (output != null && (outputRoot2 = PackageAnnotator.findRelativeFile(rootPackageVMName, output)).exists()) {
                this.collectCoverageInformation(outputRoot2, (Map<String, PackageCoverageInfo>)packageCoverageMap, (Map<String, PackageCoverageInfo>)flattenPackageCoverageMap, data, rootPackageVMName, annotator, module, suite.isTrackTestFolders(), false);
            }
            if (!suite.isTrackTestFolders() || (testPackageRoot = this.myCoverageManager.doInReadActionIfProjectOpen(new Computable<VirtualFile>(){

                @Nullable
                public VirtualFile compute() {
                    return CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPathForTests();
                }
            })) == null || !(outputRoot = PackageAnnotator.findRelativeFile(rootPackageVMName, testPackageRoot)).exists()) continue;
            this.collectCoverageInformation(outputRoot, (Map<String, PackageCoverageInfo>)packageCoverageMap, (Map<String, PackageCoverageInfo>)flattenPackageCoverageMap, data, rootPackageVMName, annotator, module, suite.isTrackTestFolders(), true);
        }
        for (Map.Entry entry : packageCoverageMap.entrySet()) {
            String packageFQName = ((String)entry.getKey()).replaceAll("/", ".");
            info = (PackageCoverageInfo)entry.getValue();
            annotator.annotatePackage(packageFQName, info);
        }
        for (Map.Entry entry : flattenPackageCoverageMap.entrySet()) {
            String packageFQName = ((String)entry.getKey()).replaceAll("/", ".");
            info = (PackageCoverageInfo)entry.getValue();
            annotator.annotatePackage(packageFQName, info, true);
        }
    }

    private static File findRelativeFile(String rootPackageVMName, VirtualFile output) {
        File outputRoot = VfsUtilCore.virtualToIoFile((VirtualFile)output);
        outputRoot = rootPackageVMName.length() > 0 ? new File(outputRoot, FileUtil.toSystemDependentName((String)rootPackageVMName)) : outputRoot;
        return outputRoot;
    }

    public void annotateFilteredClass(PsiClass psiClass, CoverageSuitesBundle bundle, Annotator annotator) {
        ProjectData data = bundle.getCoverageData();
        if (data == null) {
            return;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiClass);
        if (module != null) {
            VirtualFile outputPath;
            boolean isInTests = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().isInTestSourceContent(psiClass.getContainingFile().getVirtualFile());
            CompilerModuleExtension moduleExtension = CompilerModuleExtension.getInstance((Module)module);
            VirtualFile virtualFile = outputPath = isInTests ? moduleExtension.getCompilerOutputPathForTests() : moduleExtension.getCompilerOutputPath();
            if (outputPath != null) {
                String qualifiedName = psiClass.getQualifiedName();
                if (qualifiedName == null) {
                    return;
                }
                String packageVMName = StringUtil.getPackageName((String)qualifiedName).replace('.', '/');
                File packageRoot = PackageAnnotator.findRelativeFile(packageVMName, outputPath);
                if (packageRoot != null && packageRoot.exists()) {
                    HashMap toplevelClassCoverage = new HashMap();
                    File[] files = packageRoot.listFiles();
                    if (files != null) {
                        for (File child : files) {
                            if (!PackageAnnotator.isClassFile(child)) continue;
                            String childName = PackageAnnotator.getClassName(child);
                            String classFqVMName = packageVMName.length() > 0 ? packageVMName + "/" + childName : childName;
                            String toplevelClassSrcFQName = PackageAnnotator.getSourceToplevelFQName(classFqVMName);
                            if (!toplevelClassSrcFQName.equals(qualifiedName)) continue;
                            this.collectClassCoverageInformation(child, new PackageCoverageInfo(), data, (Map<String, ClassCoverageInfo>)toplevelClassCoverage, classFqVMName.replace("/", "."), toplevelClassSrcFQName);
                        }
                    }
                    for (ClassCoverageInfo coverageInfo : toplevelClassCoverage.values()) {
                        annotator.annotateClass(qualifiedName, coverageInfo);
                    }
                }
            }
        }
    }

    @Nullable
    private DirCoverageInfo[] collectCoverageInformation(File packageOutputRoot, Map<String, PackageCoverageInfo> packageCoverageMap, Map<String, PackageCoverageInfo> flattenPackageCoverageMap, ProjectData projectInfo, String packageVMName, Annotator annotator, final Module module, boolean trackTestFolders, boolean isTestHierarchy) {
        ClassCoverageInfo coverageInfo;
        ContentEntry[] contentEntries;
        ArrayList<DirCoverageInfo> dirs = new ArrayList<DirCoverageInfo>();
        for (ContentEntry contentEntry : contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            for (SourceFolder folder : contentEntry.getSourceFolders((JpsModuleSourceRootType)(isTestHierarchy ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE))) {
                VirtualFile file = folder.getFile();
                if (file == null) continue;
                String prefix = folder.getPackagePrefix().replaceAll("\\.", "/");
                VirtualFile relativeSrcRoot = file.findFileByRelativePath(StringUtil.trimStart((String)packageVMName, (String)prefix));
                dirs.add(new DirCoverageInfo(relativeSrcRoot));
            }
        }
        File[] children = packageOutputRoot.listFiles();
        if (children == null) {
            return null;
        }
        HashMap toplevelClassCoverage = new HashMap();
        block2: for (File child : children) {
            VirtualFile[] containingFile;
            String childName;
            if (child.isDirectory()) {
                childName = child.getName();
                String childPackageVMName = packageVMName.length() > 0 ? packageVMName + "/" + childName : childName;
                DirCoverageInfo[] childCoverageInfo = this.collectCoverageInformation(child, packageCoverageMap, flattenPackageCoverageMap, projectInfo, childPackageVMName, annotator, module, trackTestFolders, isTestHierarchy);
                if (childCoverageInfo == null) continue;
                for (int i = 0; i < childCoverageInfo.length; ++i) {
                    DirCoverageInfo coverageInfo2 = childCoverageInfo[i];
                    DirCoverageInfo parentDir = (DirCoverageInfo)dirs.get(i);
                    parentDir.totalClassCount += coverageInfo2.totalClassCount;
                    parentDir.coveredClassCount += coverageInfo2.coveredClassCount;
                    parentDir.totalLineCount += coverageInfo2.totalLineCount;
                    parentDir.coveredLineCount += coverageInfo2.coveredLineCount;
                    parentDir.totalMethodCount += coverageInfo2.totalMethodCount;
                    parentDir.coveredMethodCount += coverageInfo2.coveredMethodCount;
                }
                continue;
            }
            if (!PackageAnnotator.isClassFile(child)) continue;
            childName = PackageAnnotator.getClassName(child);
            String classFqVMName = packageVMName.length() > 0 ? packageVMName + "/" + childName : childName;
            final String toplevelClassSrcFQName = PackageAnnotator.getSourceToplevelFQName(classFqVMName);
            Boolean isInSource = this.myCoverageManager.doInReadActionIfProjectOpen(new Computable<Boolean>(containingFile = new VirtualFile[1], trackTestFolders){
                final /* synthetic */ VirtualFile[] val$containingFile;
                final /* synthetic */ boolean val$trackTestFolders;
                {
                    this.val$containingFile = virtualFileArray;
                    this.val$trackTestFolders = bl;
                }

                public Boolean compute() {
                    PsiClass aClass = JavaPsiFacade.getInstance((Project)PackageAnnotator.this.myManager.getProject()).findClass(toplevelClassSrcFQName, GlobalSearchScope.moduleScope((Module)module));
                    if (aClass == null || !aClass.isValid()) {
                        return Boolean.FALSE;
                    }
                    this.val$containingFile[0] = aClass.getContainingFile().getVirtualFile();
                    if (this.val$containingFile[0] == null) {
                        LOG.info("No virtual file found for: " + aClass);
                        return null;
                    }
                    ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
                    return fileIndex.isUnderSourceRootOfType(this.val$containingFile[0], JavaModuleSourceRootTypes.SOURCES) && (this.val$trackTestFolders || !fileIndex.isInTestSourceContent(this.val$containingFile[0]));
                }
            });
            if (isInSource == null || !isInSource.booleanValue()) continue;
            for (DirCoverageInfo dirCoverageInfo : dirs) {
                if (dirCoverageInfo.sourceRoot == null || !VfsUtil.isAncestor((VirtualFile)dirCoverageInfo.sourceRoot, (VirtualFile)containingFile[0], (boolean)false)) continue;
                this.collectClassCoverageInformation(child, dirCoverageInfo, projectInfo, (Map<String, ClassCoverageInfo>)toplevelClassCoverage, classFqVMName.replace("/", "."), toplevelClassSrcFQName);
                continue block2;
            }
        }
        for (Map.Entry entry : toplevelClassCoverage.entrySet()) {
            String toplevelClassName = (String)entry.getKey();
            coverageInfo = (ClassCoverageInfo)entry.getValue();
            annotator.annotateClass(toplevelClassName, coverageInfo);
        }
        PackageCoverageInfo flattenPackageCoverageInfo = PackageAnnotator.getOrCreateCoverageInfo(flattenPackageCoverageMap, packageVMName);
        for (Map.Entry entry : toplevelClassCoverage.entrySet()) {
            coverageInfo = (ClassCoverageInfo)entry.getValue();
            flattenPackageCoverageInfo.coveredClassCount += coverageInfo.coveredClassCount;
            flattenPackageCoverageInfo.totalClassCount += coverageInfo.totalClassCount;
            flattenPackageCoverageInfo.coveredLineCount += coverageInfo.fullyCoveredLineCount + coverageInfo.partiallyCoveredLineCount;
            flattenPackageCoverageInfo.totalLineCount += coverageInfo.totalLineCount;
            flattenPackageCoverageInfo.coveredMethodCount += coverageInfo.coveredMethodCount;
            flattenPackageCoverageInfo.totalMethodCount += coverageInfo.totalMethodCount;
        }
        PackageCoverageInfo packageCoverageInfo = PackageAnnotator.getOrCreateCoverageInfo(packageCoverageMap, packageVMName);
        for (DirCoverageInfo dir : dirs) {
            packageCoverageInfo.totalClassCount += dir.totalClassCount;
            packageCoverageInfo.totalLineCount += dir.totalLineCount;
            packageCoverageInfo.coveredClassCount += dir.coveredClassCount;
            packageCoverageInfo.coveredLineCount += dir.coveredLineCount;
            packageCoverageInfo.coveredMethodCount += dir.coveredMethodCount;
            packageCoverageInfo.totalMethodCount += dir.totalMethodCount;
            if (isTestHierarchy) {
                annotator.annotateTestDirectory(dir.sourceRoot, dir, module);
                continue;
            }
            annotator.annotateSourceDirectory(dir.sourceRoot, dir, module);
        }
        return dirs.toArray(new DirCoverageInfo[dirs.size()]);
    }

    private static boolean isClassFile(File classFile) {
        return classFile.getName().endsWith(".class");
    }

    private static String getClassName(File classFile) {
        return StringUtil.trimEnd((String)classFile.getName(), (String)".class");
    }

    private static PackageCoverageInfo getOrCreateCoverageInfo(Map<String, PackageCoverageInfo> packageCoverageMap, String packageVMName) {
        PackageCoverageInfo coverageInfo = packageCoverageMap.get(packageVMName);
        if (coverageInfo == null) {
            coverageInfo = new PackageCoverageInfo();
            packageCoverageMap.put(packageVMName, coverageInfo);
        }
        return coverageInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void collectClassCoverageInformation(File classFile, PackageCoverageInfo packageCoverageInfo, ProjectData projectInfo, Map<String, ClassCoverageInfo> toplevelClassCoverage, String className, String toplevelClassSrcFQName) {
        ClassCoverageInfo toplevelClassCoverageInfo = new ClassCoverageInfo();
        ClassData classData = projectInfo.getClassData(className);
        if (classData != null && classData.getLines() != null) {
            Object[] lines;
            for (Object l : lines = classData.getLines()) {
                if (!(l instanceof LineData)) continue;
                LineData lineData = (LineData)l;
                if (lineData.getStatus() == 2) {
                    ++toplevelClassCoverageInfo.fullyCoveredLineCount;
                } else if (lineData.getStatus() == 1) {
                    ++toplevelClassCoverageInfo.partiallyCoveredLineCount;
                }
                ++toplevelClassCoverageInfo.totalLineCount;
                ++packageCoverageInfo.totalLineCount;
            }
            boolean touchedClass = false;
            Collection methodSigs = classData.getMethodSigs();
            for (Object nameAndSig : methodSigs) {
                int covered = classData.getStatus((String)nameAndSig);
                if (covered == 0) continue;
                ++toplevelClassCoverageInfo.coveredMethodCount;
                touchedClass = true;
            }
            if (methodSigs.isEmpty()) return;
            if (touchedClass) {
                ++packageCoverageInfo.coveredClassCount;
            }
            toplevelClassCoverageInfo.totalMethodCount += methodSigs.size();
            ++packageCoverageInfo.totalClassCount;
            packageCoverageInfo.coveredLineCount += toplevelClassCoverageInfo.fullyCoveredLineCount;
            packageCoverageInfo.coveredLineCount += toplevelClassCoverageInfo.partiallyCoveredLineCount;
            packageCoverageInfo.coveredMethodCount += toplevelClassCoverageInfo.coveredMethodCount;
            packageCoverageInfo.totalMethodCount += toplevelClassCoverageInfo.totalMethodCount;
        } else if (!this.collectNonCoveredClassInfo(classFile, toplevelClassCoverageInfo, packageCoverageInfo)) {
            return;
        }
        ClassCoverageInfo classCoverageInfo = PackageAnnotator.getOrCreateClassCoverageInfo(toplevelClassCoverage, toplevelClassSrcFQName);
        classCoverageInfo.totalLineCount += toplevelClassCoverageInfo.totalLineCount;
        classCoverageInfo.fullyCoveredLineCount += toplevelClassCoverageInfo.fullyCoveredLineCount;
        classCoverageInfo.partiallyCoveredLineCount += toplevelClassCoverageInfo.partiallyCoveredLineCount;
        classCoverageInfo.totalMethodCount += toplevelClassCoverageInfo.totalMethodCount;
        classCoverageInfo.coveredMethodCount += toplevelClassCoverageInfo.coveredMethodCount;
        if (toplevelClassCoverageInfo.coveredMethodCount <= 0) return;
        ++classCoverageInfo.coveredClassCount;
    }

    private static ClassCoverageInfo getOrCreateClassCoverageInfo(Map<String, ClassCoverageInfo> toplevelClassCoverage, String sourceToplevelFQName) {
        ClassCoverageInfo toplevelClassCoverageInfo = toplevelClassCoverage.get(sourceToplevelFQName);
        if (toplevelClassCoverageInfo == null) {
            toplevelClassCoverageInfo = new ClassCoverageInfo();
            toplevelClassCoverage.put(sourceToplevelFQName, toplevelClassCoverageInfo);
        } else {
            ++toplevelClassCoverageInfo.totalClassCount;
        }
        return toplevelClassCoverageInfo;
    }

    private static String getSourceToplevelFQName(String classFQVMName) {
        int index = classFQVMName.indexOf(36);
        if (index > 0) {
            classFQVMName = classFQVMName.substring(0, index);
        }
        if (classFQVMName.startsWith("/")) {
            classFQVMName = classFQVMName.substring(1);
        }
        return classFQVMName.replaceAll("/", ".");
    }

    private boolean collectNonCoveredClassInfo(final File classFile, ClassCoverageInfo classCoverageInfo, PackageCoverageInfo packageCoverageInfo) {
        byte[] content = this.myCoverageManager.doInReadActionIfProjectOpen(new Computable<byte[]>(){

            public byte[] compute() {
                try {
                    return FileUtil.loadFileBytes((File)classFile);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
        CoverageSuitesBundle coverageSuite = CoverageDataManager.getInstance(this.myProject).getCurrentSuitesBundle();
        if (coverageSuite == null) {
            return false;
        }
        return SourceLineCounterUtil.collectNonCoveredClassInfo(classCoverageInfo, packageCoverageInfo, content, coverageSuite.isTracingEnabled());
    }

    public static class DirCoverageInfo
    extends PackageCoverageInfo {
        public VirtualFile sourceRoot;

        public DirCoverageInfo(VirtualFile sourceRoot) {
            this.sourceRoot = sourceRoot;
        }
    }

    public static class PackageCoverageInfo {
        public int totalClassCount;
        public int coveredClassCount;
        public int totalLineCount;
        public int coveredLineCount;
        public int coveredMethodCount;
        public int totalMethodCount;
    }

    public static class ClassCoverageInfo {
        public int totalLineCount;
        public int fullyCoveredLineCount;
        public int partiallyCoveredLineCount;
        public int totalMethodCount;
        public int coveredMethodCount;
        public int totalClassCount = 1;
        public int coveredClassCount;
    }

    public static interface Annotator {
        public void annotateSourceDirectory(VirtualFile var1, PackageCoverageInfo var2, Module var3);

        public void annotateTestDirectory(VirtualFile var1, PackageCoverageInfo var2, Module var3);

        public void annotatePackage(String var1, PackageCoverageInfo var2);

        public void annotatePackage(String var1, PackageCoverageInfo var2, boolean var3);

        public void annotateClass(String var1, ClassCoverageInfo var2);
    }
}

