/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeplatform.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.internal.nativeplatform.filesystem.EmptyChmod;
import org.gradle.internal.nativeplatform.filesystem.FallbackStat;
import org.gradle.internal.nativeplatform.filesystem.FileModeAccessor;
import org.gradle.internal.nativeplatform.filesystem.FileModeMutator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsupportedFilePermissions
implements FileModeAccessor,
FileModeMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnsupportedFilePermissions.class);
    private final AtomicBoolean warned = new AtomicBoolean();
    private final FallbackStat stat = new FallbackStat();
    private final EmptyChmod chmod = new EmptyChmod();

    public int getUnixMode(File f) throws IOException {
        this.maybeWarn();
        return this.stat.getUnixMode(f);
    }

    public void chmod(File file, int mode) throws Exception {
        this.maybeWarn();
        this.chmod.chmod(file, mode);
    }

    private void maybeWarn() {
        if (this.warned.compareAndSet(false, true)) {
            LOGGER.warn("Support for reading or changing file permissions is only available on this platform using Java 7 or later.");
        }
    }
}

