/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.injection.Injectable;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.FileContentUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.references.InjectedReferencesContributor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectLanguageAction
implements IntentionAction {
    @NonNls
    private static final String INJECT_LANGUAGE_FAMILY = "Inject Language/Reference";
    public static final String LAST_INJECTED_LANGUAGE = "LAST_INJECTED_LANGUAGE";
    public static final Key<Processor<PsiLanguageInjectionHost>> FIX_KEY = Key.create((String)"inject fix key");

    public static List<Injectable> getAllInjectables() {
        Language[] languages = InjectedLanguage.getAvailableLanguages();
        ArrayList<Injectable> list = new ArrayList<Injectable>();
        for (Language language : languages) {
            list.add(Injectable.fromLanguage((Language)language));
        }
        list.addAll(Arrays.asList(ReferenceInjector.EXTENSION_POINT_NAME.getExtensions()));
        Collections.sort(list);
        return list;
    }

    @NotNull
    public String getText() {
        if (INJECT_LANGUAGE_FAMILY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "getText"));
        }
        return INJECT_LANGUAGE_FAMILY;
    }

    @NotNull
    public String getFamilyName() {
        if (INJECT_LANGUAGE_FAMILY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "getFamilyName"));
        }
        return INJECT_LANGUAGE_FAMILY;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "isAvailable"));
        }
        PsiLanguageInjectionHost host = InjectLanguageAction.findInjectionHost(editor, file);
        if (host == null) {
            return false;
        }
        List injectedPsi = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles((PsiElement)host);
        if (injectedPsi == null || injectedPsi.isEmpty()) {
            return !InjectedReferencesContributor.isInjected(file.findReferenceAt(editor.getCaretModel().getOffset()));
        }
        return false;
    }

    @Nullable
    protected static PsiLanguageInjectionHost findInjectionHost(Editor editor, PsiFile file) {
        if (editor instanceof EditorWindow) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), PsiLanguageInjectionHost.class, (boolean)false);
        if (host == null) {
            return null;
        }
        return host.isValidHost() ? host : null;
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "invoke"));
        }
        InjectLanguageAction.doChooseLanguageToInject(editor, new Processor<Injectable>(){

            public boolean process(final Injectable injectable) {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (!project.isDisposed()) {
                            InjectLanguageAction.invokeImpl(project, editor, file, injectable);
                        }
                    }
                });
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeImpl(Project project, Editor editor, PsiFile file, Injectable injectable) {
        PsiLanguageInjectionHost host = InjectLanguageAction.findInjectionHost(editor, file);
        if (host == null) {
            return;
        }
        if (InjectLanguageAction.defaultFunctionalityWorked(host, injectable.getId())) {
            return;
        }
        try {
            host.putUserData(FIX_KEY, null);
            Language language = injectable.toLanguage();
            for (LanguageInjectionSupport support : InjectorUtils.getActiveInjectionSupports()) {
                if (!support.isApplicableTo(host) || !support.addInjectionInPlace(language, host)) continue;
                return;
            }
            if (TemporaryPlacesRegistry.getInstance(project).getLanguageInjectionSupport().addInjectionInPlace(language, host)) {
                final Processor data = (Processor)host.getUserData(FIX_KEY);
                String text = StringUtil.escapeXml((String)language.getDisplayName()) + " was temporarily injected.";
                if (data != null) {
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)host);
                        TextRange range = host.getTextRange();
                        HintManager.getInstance().showQuestionHint(editor, text + "<br>Do you want to insert annotation? " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions")), range.getStartOffset(), range.getEndOffset(), new QuestionAction(){

                            public boolean execute() {
                                return data.process((Object)pointer.getElement());
                            }
                        });
                    }
                } else {
                    HintManager.getInstance().showInformationHint(editor, text);
                }
            }
        }
        finally {
            if (injectable.getLanguage() != null) {
                FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
            } else {
                ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker()).incCounter();
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }
        }
    }

    private static boolean defaultFunctionalityWorked(PsiLanguageInjectionHost host, String id) {
        return Configuration.getProjectInstance(host.getProject()).setHostInjectionEnabled(host, Collections.singleton(id), true);
    }

    private static boolean doChooseLanguageToInject(Editor editor, Processor<Injectable> onChosen) {
        List<Injectable> injectables = InjectLanguageAction.getAllInjectables();
        JBList list = new JBList(injectables);
        list.setCellRenderer(new ColoredListCellRendererWrapper<Injectable>(){

            protected void doCustomize(JList list, Injectable language, int index, boolean selected, boolean hasFocus) {
                this.setIcon(language.getIcon());
                this.append(language.getDisplayName());
                String description = language.getAdditionalDescription();
                if (description != null) {
                    this.append(description, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }
        });
        Dimension minSize = new JLabel(PlainTextLanguage.INSTANCE.getDisplayName(), EmptyIcon.ICON_16, 2).getMinimumSize();
        minSize.height *= 4;
        list.setMinimumSize(minSize);
        JBPopup popup = new PopupChooserBuilder((JList)list).setItemChoosenCallback(new Runnable((JList)list, onChosen){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Processor val$onChosen;
            {
                this.val$list = jList;
                this.val$onChosen = processor;
            }

            @Override
            public void run() {
                Injectable value = (Injectable)this.val$list.getSelectedValue();
                if (value != null) {
                    this.val$onChosen.process((Object)value);
                    PropertiesComponent.getInstance().setValue(InjectLanguageAction.LAST_INJECTED_LANGUAGE, value.getId());
                }
            }
        }).setFilteringEnabled((Function)new Function<Object, String>(){

            public String fun(Object language) {
                return ((Injectable)language).getDisplayName();
            }
        }).setMinSize(minSize).createPopup();
        final String lastInjected = PropertiesComponent.getInstance().getValue(LAST_INJECTED_LANGUAGE);
        if (lastInjected != null) {
            Injectable injectable = (Injectable)ContainerUtil.find(injectables, (Condition)new Condition<Injectable>(){

                public boolean value(Injectable injectable) {
                    return lastInjected.equals(injectable.getId());
                }
            });
            list.setSelectedValue(injectable, true);
        }
        popup.showInBestPositionFor(editor);
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

