/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import org.gradle.api.PolymorphicDomainObjectContainer;
import org.gradle.model.collection.NamedItemCollectionBuilder;
import org.gradle.model.collection.NamedItemCollectionBuilderModelView;
import org.gradle.model.collection.internal.DefaultNamedItemCollectionBuilder;
import org.gradle.model.entity.internal.NamedEntityInstantiator;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelBinding;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelRuleRegistrar;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolymorphicDomainObjectContainerModelAdapter<I, C extends PolymorphicDomainObjectContainer<I>>
implements ModelAdapter {
    private final C container;
    private final ModelType<C> containerType;
    private final Class<I> itemType;

    public PolymorphicDomainObjectContainerModelAdapter(C container, ModelType<C> containerType, Class<I> itemType) {
        this.container = container;
        this.containerType = containerType;
        this.itemType = itemType;
    }

    public <T> ModelView<? extends T> asWritable(ModelBinding<T> binding, ModelRuleDescriptor sourceDescriptor, Inputs inputs, ModelRuleRegistrar modelRuleRegistrar) {
        ModelType bindingType = binding.getReference().getType();
        if (bindingType.isAssignableFrom(this.containerType)) {
            ModelView cast = InstanceModelView.of(this.containerType, this.container);
            return cast;
        }
        if (bindingType.getRawClass().equals(NamedItemCollectionBuilder.class)) {
            ModelType bindingItemType = (ModelType)bindingType.getTypeVariables().get(0);
            if (bindingItemType.getRawClass().isAssignableFrom(this.itemType)) {
                return this.toView(binding, sourceDescriptor, inputs, modelRuleRegistrar, this.itemType);
            }
            if (this.itemType.isAssignableFrom(bindingItemType.getRawClass())) {
                Class<I> subType = bindingItemType.getRawClass().asSubclass(this.itemType);
                return this.toSubModelView(binding, sourceDescriptor, inputs, modelRuleRegistrar, subType);
            }
            return null;
        }
        return null;
    }

    private <T, S extends I> ModelView<? extends T> toSubModelView(ModelBinding<T> binding, ModelRuleDescriptor sourceDescriptor, Inputs inputs, ModelRuleRegistrar modelRuleRegistrar, Class<S> subType) {
        return this.toView(binding, sourceDescriptor, inputs, modelRuleRegistrar, subType);
    }

    private <T, S extends I> ModelView<? extends T> toView(ModelBinding<T> binding, ModelRuleDescriptor sourceDescriptor, Inputs inputs, ModelRuleRegistrar modelRuleRegistrar, Class<S> itemType) {
        NamedItemCollectionBuilderModelView view;
        DefaultNamedItemCollectionBuilder builder = new DefaultNamedItemCollectionBuilder(binding.getPath(), new Instantiator<S>(itemType, this.container), sourceDescriptor, inputs, modelRuleRegistrar);
        ModelType viewType = new ModelType.Builder<NamedItemCollectionBuilder<S>>(){}.where(new ModelType.Parameter<S>(){}, ModelType.of(itemType)).build();
        NamedItemCollectionBuilderModelView cast = view = new NamedItemCollectionBuilderModelView(viewType, (NamedItemCollectionBuilder)builder, binding.getPath(), sourceDescriptor);
        return cast;
    }

    public <T> ModelView<? extends T> asReadOnly(ModelType<T> type) {
        if (type.isAssignableFrom(this.containerType)) {
            ModelView cast = InstanceModelView.of(this.containerType, this.container);
            return cast;
        }
        return null;
    }

    public ModelPromise asPromise() {
        return new ModelPromise(){

            public <T> boolean asWritable(ModelType<T> type) {
                return type.isAssignableFrom(PolymorphicDomainObjectContainerModelAdapter.this.containerType) || this.isContainerView(type);
            }

            private <T> boolean isContainerView(ModelType<T> type) {
                if (type.getRawClass().equals(NamedItemCollectionBuilder.class)) {
                    ModelType targetItemType = (ModelType)type.getTypeVariables().get(0);
                    return targetItemType.getRawClass().isAssignableFrom(PolymorphicDomainObjectContainerModelAdapter.this.itemType) || PolymorphicDomainObjectContainerModelAdapter.this.itemType.isAssignableFrom(targetItemType.getRawClass());
                }
                return false;
            }

            public <T> boolean asReadOnly(ModelType<T> type) {
                return type.isAssignableFrom(PolymorphicDomainObjectContainerModelAdapter.this.containerType);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Instantiator<I>
    implements NamedEntityInstantiator<I> {
        private final Class<I> defaultType;
        private final ModelType<I> itemType;
        private final PolymorphicDomainObjectContainer<? super I> container;

        Instantiator(Class<I> defaultType, PolymorphicDomainObjectContainer<? super I> container) {
            this.defaultType = defaultType;
            this.itemType = ModelType.of(defaultType);
            this.container = container;
        }

        public ModelType<I> getType() {
            return this.itemType;
        }

        public I create(String name) {
            return this.container.create(name, this.defaultType);
        }

        public <S extends I> S create(String name, Class<S> type) {
            return this.container.create(name, type);
        }
    }
}

