/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.google.common.base.Objects;
import com.intellij.dvcs.repo.Repository;
import com.intellij.vcs.log.Hash;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgNameWithHashInfo;

public class HgRepoInfo {
    @NotNull
    private String myCurrentBranch;
    @Nullable
    private final String myTipRevision;
    @Nullable
    private final String myCurrentRevision;
    @NotNull
    private final Repository.State myState;
    @Nullable
    private String myCurrentBookmark;
    @NotNull
    private Map<String, Set<Hash>> myBranches;
    @NotNull
    private Set<HgNameWithHashInfo> myBookmarks;
    @NotNull
    private Set<HgNameWithHashInfo> myTags;
    @NotNull
    private Set<HgNameWithHashInfo> myLocalTags;
    @NotNull
    Set<HgNameWithHashInfo> mySubrepos;

    public HgRepoInfo(@NotNull String currentBranch, @Nullable String currentRevision, @Nullable String currentTipRevision, @NotNull Repository.State state, @NotNull Map<String, Set<Hash>> branches, @NotNull Collection<HgNameWithHashInfo> bookmarks, @Nullable String currentBookmark, @NotNull Collection<HgNameWithHashInfo> tags, @NotNull Collection<HgNameWithHashInfo> localTags, @NotNull Collection<HgNameWithHashInfo> subrepos) {
        if (currentBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentBranch", "org/zmlx/hg4idea/repo/HgRepoInfo", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/zmlx/hg4idea/repo/HgRepoInfo", "<init>"));
        }
        if (branches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branches", "org/zmlx/hg4idea/repo/HgRepoInfo", "<init>"));
        }
        if (bookmarks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bookmarks", "org/zmlx/hg4idea/repo/HgRepoInfo", "<init>"));
        }
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "org/zmlx/hg4idea/repo/HgRepoInfo", "<init>"));
        }
        if (localTags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localTags", "org/zmlx/hg4idea/repo/HgRepoInfo", "<init>"));
        }
        if (subrepos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subrepos", "org/zmlx/hg4idea/repo/HgRepoInfo", "<init>"));
        }
        this.myCurrentBranch = "default";
        this.myCurrentBookmark = null;
        this.myBranches = Collections.emptyMap();
        this.myBookmarks = Collections.emptySet();
        this.myTags = Collections.emptySet();
        this.myLocalTags = Collections.emptySet();
        this.mySubrepos = Collections.emptySet();
        this.myCurrentBranch = currentBranch;
        this.myCurrentRevision = currentRevision;
        this.myTipRevision = currentTipRevision;
        this.myState = state;
        this.myBranches = branches;
        this.myBookmarks = new LinkedHashSet<HgNameWithHashInfo>(bookmarks);
        this.myCurrentBookmark = currentBookmark;
        this.myTags = new LinkedHashSet<HgNameWithHashInfo>(tags);
        this.myLocalTags = new LinkedHashSet<HgNameWithHashInfo>(localTags);
        this.mySubrepos = new HashSet<HgNameWithHashInfo>(subrepos);
    }

    @NotNull
    public String getCurrentBranch() {
        String string = this.myCurrentBranch;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepoInfo", "getCurrentBranch"));
        }
        return string;
    }

    @NotNull
    public Map<String, Set<Hash>> getBranches() {
        Map<String, Set<Hash>> map = this.myBranches;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepoInfo", "getBranches"));
        }
        return map;
    }

    @NotNull
    public Collection<HgNameWithHashInfo> getBookmarks() {
        Set<HgNameWithHashInfo> set = this.myBookmarks;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepoInfo", "getBookmarks"));
        }
        return set;
    }

    @NotNull
    public Collection<HgNameWithHashInfo> getTags() {
        Set<HgNameWithHashInfo> set = this.myTags;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepoInfo", "getTags"));
        }
        return set;
    }

    @NotNull
    public Collection<HgNameWithHashInfo> getLocalTags() {
        Set<HgNameWithHashInfo> set = this.myLocalTags;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepoInfo", "getLocalTags"));
        }
        return set;
    }

    @Nullable
    public String getTipRevision() {
        return this.myTipRevision;
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myCurrentRevision;
    }

    @Nullable
    public String getCurrentBookmark() {
        return this.myCurrentBookmark;
    }

    @NotNull
    public Repository.State getState() {
        Repository.State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepoInfo", "getState"));
        }
        return state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgRepoInfo info = (HgRepoInfo)o;
        if (this.myState != info.myState) {
            return false;
        }
        if (this.myTipRevision != null ? !this.myTipRevision.equals(info.myTipRevision) : info.myTipRevision != null) {
            return false;
        }
        if (this.myCurrentRevision != null ? !this.myCurrentRevision.equals(info.myCurrentRevision) : info.myCurrentRevision != null) {
            return false;
        }
        if (!this.myCurrentBranch.equals(info.myCurrentBranch)) {
            return false;
        }
        if (this.myCurrentBookmark != null ? !this.myCurrentBookmark.equals(info.myCurrentBookmark) : info.myCurrentBookmark != null) {
            return false;
        }
        if (!((Object)this.myBranches).equals(info.myBranches)) {
            return false;
        }
        if (!((Object)this.myBookmarks).equals(info.myBookmarks)) {
            return false;
        }
        if (!((Object)this.myTags).equals(info.myTags)) {
            return false;
        }
        if (!((Object)this.myLocalTags).equals(info.myLocalTags)) {
            return false;
        }
        return ((Object)this.mySubrepos).equals(info.mySubrepos);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myCurrentBranch, this.myCurrentRevision, this.myTipRevision, this.myCurrentBookmark, this.myState, this.myBranches, this.myBookmarks, this.myTags, this.myLocalTags, this.mySubrepos});
    }

    @NotNull
    public String toString() {
        String string = String.format("HgRepository{myCurrentBranch=%s, myCurrentRevision='%s', myState=%s}", this.myCurrentBranch, this.myCurrentRevision, this.myState);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepoInfo", "toString"));
        }
        return string;
    }

    public boolean hasSubrepos() {
        return !this.mySubrepos.isEmpty();
    }

    @NotNull
    public Collection<HgNameWithHashInfo> getSubrepos() {
        Set<HgNameWithHashInfo> set = this.mySubrepos;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepoInfo", "getSubrepos"));
        }
        return set;
    }
}

