/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.repo.ExternalRepository;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;

public class UpgradeAppenginePluginVersionHyperlink
extends NotificationHyperlink {
    private static final String DEFAULT_APPENGINE_PLUGIN_VERSION = "1.9.17";
    public static final String APPENGINE_PLUGIN_GROUP_ID = "com.google.appengine";
    public static final String APPENGINE_PLUGIN_ARTIFACT_ID = "gradle-appengine-plugin";
    public static final String APPENGINE_PLUGIN_DEFINITION_START = "com.google.appengine:gradle-appengine-plugin:";
    public static final GradleCoordinate REFERENCE_APPENGINE_COORDINATE = GradleCoordinate.parseCoordinateString((String)"com.google.appengine:gradle-appengine-plugin:1.9.17");
    @NotNull
    private final VirtualFile myConfigToCorrect;

    public UpgradeAppenginePluginVersionHyperlink(@NotNull VirtualFile configToCorrect) {
        if (configToCorrect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configToCorrect", "com/android/tools/idea/gradle/service/notification/hyperlink/UpgradeAppenginePluginVersionHyperlink", "<init>"));
        }
        super("gradle.plugin.appengine.version.upgrade", AndroidBundle.message("android.gradle.link.appengine.outdated", new Object[0]));
        this.myConfigToCorrect = configToCorrect;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/UpgradeAppenginePluginVersionHyperlink", "execute"));
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        final Document document = fileDocumentManager.getDocument(this.myConfigToCorrect);
        if (document == null) {
            return;
        }
        final TextRange range = GradleUtil.forPluginDefinition(document.getText(), APPENGINE_PLUGIN_DEFINITION_START, new Function<Pair<String, GroovyLexer>, TextRange>(){

            public TextRange fun(Pair<String, GroovyLexer> pair) {
                GroovyLexer lexer = (GroovyLexer)pair.getSecond();
                return TextRange.create((int)(lexer.getTokenStart() + 1 + UpgradeAppenginePluginVersionHyperlink.APPENGINE_PLUGIN_DEFINITION_START.length()), (int)(lexer.getTokenEnd() - 1));
            }
        });
        if (range == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

            @Override
            public void run() {
                ExternalRepository repository = (ExternalRepository)ServiceManager.getService(ExternalRepository.class);
                FullRevision latest = repository.getLatest(UpgradeAppenginePluginVersionHyperlink.APPENGINE_PLUGIN_GROUP_ID, UpgradeAppenginePluginVersionHyperlink.APPENGINE_PLUGIN_ARTIFACT_ID);
                String versionToUse = latest == null ? UpgradeAppenginePluginVersionHyperlink.DEFAULT_APPENGINE_PLUGIN_VERSION : latest.toString();
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)versionToUse);
            }
        });
        GradleProjectImporter.getInstance().requestProjectSync(project, null);
    }
}

