/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.HintHint;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.PlatformIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.intellij.plugins.xpathView.Config;
import org.intellij.plugins.xpathView.XPathAction;
import org.intellij.plugins.xpathView.XPathAppComponent;
import org.intellij.plugins.xpathView.XPathExpressionGenerator;
import org.intellij.plugins.xpathView.support.XPathSupport;
import org.intellij.plugins.xpathView.util.HighlighterUtil;

public class ShowXPathAction
extends XPathAction {
    @Override
    public void update(AnActionEvent event) {
        super.update(event);
        Presentation presentation = event.getPresentation();
        if (ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()) && presentation.getText().startsWith("Show ")) {
            String text = presentation.getText().substring("Show ".length());
            presentation.setText(Character.toUpperCase(text.charAt(0)) + text.substring(1));
        }
    }

    @Override
    protected boolean isEnabledAt(XmlFile xmlFile, int offset) {
        PsiElement element = xmlFile.findElementAt(offset);
        if (!(element instanceof XmlElement) && !(element instanceof PsiWhiteSpace)) {
            return false;
        }
        PsiElement node = XPathExpressionGenerator.transformToValidShowPathNode(element);
        return node != null;
    }

    public void actionPerformed(AnActionEvent e) {
        final Editor editor = (Editor)LangDataKeys.EDITOR.getData(e.getDataContext());
        if (editor == null) {
            return;
        }
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        PsiDocumentManager docmgr = PsiDocumentManager.getInstance((Project)project);
        Document document = editor.getDocument();
        docmgr.commitDocument(document);
        PsiFile psiFile = docmgr.getPsiFile(document);
        if (!(psiFile instanceof XmlFile)) {
            return;
        }
        PsiElement element = psiFile.findElementAt(editor.getCaretModel().getOffset());
        if (!(element instanceof XmlElement) && !(element instanceof PsiWhiteSpace)) {
            XPathAppComponent.showEditorHint("No suitable context for an XPath-expression selected.", editor);
            return;
        }
        PsiElement node = XPathExpressionGenerator.transformToValidShowPathNode(element);
        if (node == null) {
            XPathAppComponent.showEditorHint("No suitable context for an XPath-expression selected.", editor);
            return;
        }
        Config cfg = this.myComponent.getConfig();
        final RangeHighlighter h = HighlighterUtil.highlightNode(editor, node, cfg.getContextAttributes(), cfg);
        final String path = XPathSupport.getInstance().getUniquePath((XmlElement)node, null);
        JTextField label = new JTextField(path);
        label.setPreferredSize(new Dimension(label.getPreferredSize().width + new JLabel((String)"M").getPreferredSize().width, label.getPreferredSize().height));
        label.setOpaque(false);
        label.setEditable(false);
        label.setBorder(null);
        label.setHorizontalAlignment(0);
        label.setCursor(Cursor.getPredefinedCursor(2));
        NonOpaquePanel p = new NonOpaquePanel((LayoutManager)new BorderLayout());
        JLabel l = new JLabel("XPath:");
        p.add((Component)l, "West");
        p.add((Component)label, "Center");
        InplaceButton copy = new InplaceButton(ActionsBundle.message((String)"action.EditorCopy.text", (Object[])new Object[0]), PlatformIcons.COPY_ICON, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(path));
            }
        });
        p.add((Component)copy, "East");
        LightweightHint hint = new LightweightHint((JComponent)p){

            public void hide() {
                super.hide();
                HighlighterUtil.removeHighlighter(editor, h);
            }
        };
        Point point = editor.visualPositionToXY(editor.getCaretModel().getVisualPosition());
        point.y += editor.getLineHeight() / 2;
        HintHint hintHint = new HintHint(editor, point).setAwtTooltip(true).setContentActive(true).setExplicitClose(true).setShowImmediately(true);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, point, 2, 0, false, hintHint);
    }
}

