/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionChecker
implements Serializable {
    @NotNull
    private final Type myConditionCheckType;
    @NotNull
    private final String myClassName;
    @NotNull
    private final String myMethodName;
    @NotNull
    private final List<String> myParameterClassList;
    private final int myCheckedParameterIndex;
    private final String myFullName;

    private ConditionChecker(@NotNull String className, @NotNull String methodName, @NotNull List<String> parameterClassList, int checkedParameterIndex, @NotNull Type type, @NotNull String fullName) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/codeInsight/ConditionChecker", "<init>"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/codeInsight/ConditionChecker", "<init>"));
        }
        if (parameterClassList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterClassList", "com/intellij/codeInsight/ConditionChecker", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ConditionChecker", "<init>"));
        }
        if (fullName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullName", "com/intellij/codeInsight/ConditionChecker", "<init>"));
        }
        ConditionChecker.checkState(!className.isEmpty(), "Class Name is blank");
        ConditionChecker.checkState(!methodName.isEmpty(), "Method Name is blank");
        ConditionChecker.checkState(!parameterClassList.isEmpty(), "Parameter Class List is empty");
        ConditionChecker.checkState(checkedParameterIndex >= 0, "CheckedParameterIndex must be greater than or equal to zero");
        ConditionChecker.checkState(parameterClassList.size() >= checkedParameterIndex, "CheckedParameterIndex is greater than Parameter Class List's size");
        ConditionChecker.checkState(!fullName.isEmpty(), "Method Name is blank");
        this.myConditionCheckType = type;
        this.myClassName = className;
        this.myMethodName = methodName;
        this.myParameterClassList = parameterClassList;
        this.myCheckedParameterIndex = checkedParameterIndex;
        this.myFullName = fullName;
    }

    private static void checkState(boolean condition, String errorMsg) {
        if (!condition) {
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public static String getFullyQualifiedName(PsiParameter psiParameter) {
        PsiTypeElement typeElement = psiParameter.getTypeElement();
        if (typeElement == null) {
            throw new RuntimeException("Parameter has null typeElement " + psiParameter.getName());
        }
        PsiType psiType = typeElement.getType();
        return psiType.getCanonicalText();
    }

    public boolean matchesPsiMethod(PsiMethod psiMethod) {
        if (!this.myMethodName.equals(psiMethod.getName())) {
            return false;
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        if (!this.myClassName.equals(qualifiedName)) {
            return false;
        }
        PsiParameterList psiParameterList = psiMethod.getParameterList();
        if (this.myParameterClassList.size() != psiParameterList.getParameters().length) {
            return false;
        }
        for (int i = 0; i < psiParameterList.getParameters().length; ++i) {
            PsiParameter psiParameter = psiParameterList.getParameters()[i];
            PsiTypeElement psiTypeElement = psiParameter.getTypeElement();
            if (psiTypeElement == null) {
                return false;
            }
            PsiType psiType = psiTypeElement.getType();
            String parameterCanonicalText = psiType.getCanonicalText();
            String myParameterCanonicalText = this.myParameterClassList.get(i);
            if (myParameterCanonicalText.equals(parameterCanonicalText)) continue;
            return false;
        }
        return true;
    }

    public boolean matchesPsiMethod(PsiMethod psiMethod, int paramIndex) {
        return this.matchesPsiMethod(psiMethod) && paramIndex == this.myCheckedParameterIndex;
    }

    public boolean overlaps(ConditionChecker otherChecker) {
        return this.myClassName.equals(otherChecker.myClassName) && this.myMethodName.equals(otherChecker.myMethodName) && ((Object)this.myParameterClassList).equals(otherChecker.myParameterClassList) && this.myCheckedParameterIndex == otherChecker.myCheckedParameterIndex;
    }

    @NotNull
    public Type getConditionCheckType() {
        Type type = this.myConditionCheckType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ConditionChecker", "getConditionCheckType"));
        }
        return type;
    }

    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ConditionChecker", "getClassName"));
        }
        return string;
    }

    @NotNull
    public String getMethodName() {
        String string = this.myMethodName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ConditionChecker", "getMethodName"));
        }
        return string;
    }

    public int getCheckedParameterIndex() {
        return this.myCheckedParameterIndex;
    }

    public String getFullName() {
        return this.myFullName;
    }

    public String toString() {
        return this.myFullName;
    }

    public static class FromPsiBuilder
    extends Builder {
        private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.ConditionCheck.FromPsiBuilder");
        @NotNull
        private final PsiMethod psiMethod;
        @NotNull
        private final PsiParameter psiParameter;
        @NotNull
        private final Type type;

        public FromPsiBuilder(@NotNull PsiMethod psiMethod, @NotNull PsiParameter psiParameter, @NotNull Type type) {
            if (psiMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInsight/ConditionChecker$FromPsiBuilder", "<init>"));
            }
            if (psiParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiParameter", "com/intellij/codeInsight/ConditionChecker$FromPsiBuilder", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ConditionChecker$FromPsiBuilder", "<init>"));
            }
            this.psiMethod = psiMethod;
            this.psiParameter = psiParameter;
            this.type = type;
        }

        private static void validatePsiMethodHasContainingClass(PsiMethod psiMethod) {
            PsiClass psiElement = psiMethod.getContainingClass();
            if (!(psiElement instanceof PsiClass)) {
                throw new IllegalArgumentException("PsiMethod " + psiMethod + " can not have a null containing class.");
            }
        }

        private static void validatePsiMethodReturnTypeForNonAsserts(PsiMethod psiMethod, Type type) {
            PsiType returnType = psiMethod.getReturnType();
            if (FromPsiBuilder.isAssert(type)) {
                return;
            }
            if (returnType == null) {
                throw new IllegalArgumentException("PsiMethod " + psiMethod + " has a null return type PsiType.");
            }
            if (returnType != PsiType.BOOLEAN && !returnType.getCanonicalText().equals(Boolean.class.toString())) {
                throw new IllegalArgumentException("PsiMethod " + psiMethod + " must have a null return type PsiType of boolean or Boolean.");
            }
        }

        private static void validatePsiParameterExistsInPsiMethod(PsiMethod psiMethod, PsiParameter psiParameter) {
            PsiParameter[] parameters;
            boolean parameterFound = false;
            for (PsiParameter parameter : parameters = psiMethod.getParameterList().getParameters()) {
                if (!psiParameter.equals(parameter)) continue;
                parameterFound = true;
                break;
            }
            if (!parameterFound) {
                throw new IllegalArgumentException("PsiMethod " + psiMethod + " must have parameter " + ConditionChecker.getFullyQualifiedName(psiParameter));
            }
        }

        private static boolean isAssert(Type type) {
            return type == Type.ASSERT_IS_NULL_METHOD || type == Type.ASSERT_IS_NOT_NULL_METHOD || type == Type.ASSERT_TRUE_METHOD || type == Type.ASSERT_FALSE_METHOD;
        }

        private static String initClassNameFromPsiMethod(PsiMethod psiMethod) {
            PsiClass psiElement = psiMethod.getContainingClass();
            PsiClass psiClass = psiElement;
            if (psiClass == null) {
                throw new IllegalStateException("PsiClass is null");
            }
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName == null || qualifiedName.isEmpty()) {
                throw new IllegalStateException("Qualified Name is Blank");
            }
            return qualifiedName;
        }

        private static String initMethodNameFromPsiMethod(PsiMethod psiMethod) {
            return psiMethod.getName();
        }

        private static List<String> initParameterClassListFromPsiMethod(PsiMethod psiMethod) {
            PsiParameter[] parameters;
            ArrayList<String> parameterClasses = new ArrayList<String>();
            for (PsiParameter param : parameters = psiMethod.getParameterList().getParameters()) {
                PsiTypeElement typeElement = param.getTypeElement();
                if (typeElement == null) {
                    throw new RuntimeException("Parameter has null typeElement " + param.getName());
                }
                PsiType psiType = typeElement.getType();
                parameterClasses.add(psiType.getCanonicalText());
            }
            return parameterClasses;
        }

        private static List<String> initParameterNameListFromPsiMethod(PsiMethod psiMethod) {
            PsiParameter[] parameters;
            ArrayList<String> parameterNames = new ArrayList<String>();
            for (PsiParameter param : parameters = psiMethod.getParameterList().getParameters()) {
                parameterNames.add(param.getName());
            }
            return parameterNames;
        }

        private static int initCheckedParameterIndex(PsiMethod psiMethod, PsiParameter psiParameterToFind) {
            PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter param = parameters[i];
                if (!param.equals(psiParameterToFind)) continue;
                return i;
            }
            throw new IllegalStateException();
        }

        private void validateConstructorArgs(PsiMethod psiMethod, PsiParameter psiParameter) {
            FromPsiBuilder.validatePsiMethodHasContainingClass(psiMethod);
            FromPsiBuilder.validatePsiMethodReturnTypeForNonAsserts(psiMethod, this.type);
            FromPsiBuilder.validatePsiParameterExistsInPsiMethod(psiMethod, psiParameter);
        }

        @Nullable
        public ConditionChecker build() {
            try {
                this.validateConstructorArgs(this.psiMethod, this.psiParameter);
                String className = FromPsiBuilder.initClassNameFromPsiMethod(this.psiMethod);
                String methodName = FromPsiBuilder.initMethodNameFromPsiMethod(this.psiMethod);
                List<String> parameterClassList = FromPsiBuilder.initParameterClassListFromPsiMethod(this.psiMethod);
                List<String> parameterNameList = FromPsiBuilder.initParameterNameListFromPsiMethod(this.psiMethod);
                int checkedParameterIndex = FromPsiBuilder.initCheckedParameterIndex(this.psiMethod, this.psiParameter);
                String fullName = FromPsiBuilder.initFullName(className, methodName, parameterClassList, parameterNameList, checkedParameterIndex);
                return new ConditionChecker(className, methodName, parameterClassList, checkedParameterIndex, this.type, fullName);
            }
            catch (Exception e) {
                LOG.error("An Exception occurred while attempting to build ConditionCheck for PsiMethod '" + this.psiMethod + "' PsiParameter='" + this.psiParameter + "' " + "' and Type '" + (Object)((Object)this.type) + "'", (Throwable)e);
                return null;
            }
        }
    }

    static class FromConfigBuilder
    extends Builder {
        private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.ConditionCheck.FromConfigBuilder");
        @NotNull
        private final String serializedRepresentation;
        @NotNull
        private final Type type;

        FromConfigBuilder(@NotNull String serializedRepresentation, @NotNull Type type) {
            if (serializedRepresentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializedRepresentation", "com/intellij/codeInsight/ConditionChecker$FromConfigBuilder", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ConditionChecker$FromConfigBuilder", "<init>"));
            }
            this.serializedRepresentation = serializedRepresentation;
            this.type = type;
        }

        private String parseClassAndMethodName() {
            if (!this.serializedRepresentation.contains("(")) {
                throw new IllegalArgumentException("Name should contain a opening parenthesis.  " + this.serializedRepresentation);
            }
            if (!this.serializedRepresentation.contains(")")) {
                throw new IllegalArgumentException("Name should contain a closing parenthesis.  " + this.serializedRepresentation);
            }
            if (this.serializedRepresentation.indexOf("(", this.serializedRepresentation.indexOf("(") + 1) > -1) {
                throw new IllegalArgumentException("Name should only contain one opening parenthesis.  " + this.serializedRepresentation);
            }
            if (this.serializedRepresentation.indexOf(")", this.serializedRepresentation.indexOf(")") + 1) > -1) {
                throw new IllegalArgumentException("Name should only contain one closing parenthesis.  " + this.serializedRepresentation);
            }
            if (this.serializedRepresentation.indexOf(")") < this.serializedRepresentation.indexOf("(")) {
                throw new IllegalArgumentException("Opening parenthesis should precede closing parenthesis.  " + this.serializedRepresentation);
            }
            String classAndMethodName = this.serializedRepresentation.substring(0, this.serializedRepresentation.indexOf("("));
            if (!classAndMethodName.contains(".")) {
                throw new IllegalArgumentException("Name should contain a dot between the class name and method name (before the opening parenthesis).  " + this.serializedRepresentation);
            }
            return classAndMethodName;
        }

        @Nullable
        public ConditionChecker build() {
            try {
                String classAndMethodName = this.parseClassAndMethodName();
                String className = classAndMethodName.substring(0, classAndMethodName.lastIndexOf("."));
                String methodName = classAndMethodName.substring(classAndMethodName.lastIndexOf(".") + 1);
                String allParametersSubString = this.serializedRepresentation.substring(this.serializedRepresentation.indexOf("(") + 1, this.serializedRepresentation.lastIndexOf(")")).trim();
                if (allParametersSubString.isEmpty()) {
                    throw new IllegalArgumentException("Name should contain 1+ parameter (between opening and closing parenthesis).  " + this.serializedRepresentation);
                }
                if (allParametersSubString.contains("*") && allParametersSubString.indexOf("*") == allParametersSubString.lastIndexOf("*")) {
                    throw new IllegalArgumentException("Selected Parameter should be surrounded by asterisks.  " + this.serializedRepresentation);
                }
                ArrayList<String> parameterClasses = new ArrayList<String>();
                ArrayList<String> parameterNames = new ArrayList<String>();
                int checkParameterIndex = -1;
                int index = 0;
                for (String parameterClassAndName : allParametersSubString.split(",")) {
                    if ((parameterClassAndName = parameterClassAndName.trim()).startsWith("*") && parameterClassAndName.endsWith("*")) {
                        checkParameterIndex = index;
                        parameterClassAndName = parameterClassAndName.substring(1, parameterClassAndName.length() - 1);
                    }
                    String[] parameterClassAndNameSplit = parameterClassAndName.split(" ");
                    String parameterClass = parameterClassAndNameSplit[0];
                    String parameterName = parameterClassAndNameSplit[1];
                    parameterClasses.add(parameterClass);
                    parameterNames.add(parameterName);
                    ++index;
                }
                String fullName = FromConfigBuilder.initFullName(className, methodName, parameterClasses, parameterNames, checkParameterIndex);
                return new ConditionChecker(className, methodName, parameterClasses, checkParameterIndex, this.type, fullName);
            }
            catch (Exception e) {
                LOG.error("An Exception occurred while attempting to build ConditionCheck for Serialized String '" + this.serializedRepresentation + "' and Type '" + (Object)((Object)this.type) + "'", (Throwable)e);
                return null;
            }
        }
    }

    private static class Builder {
        private Builder() {
        }

        static String initFullName(String className, String methodName, List<String> parameterClasses, List<String> parameterNames, int checkedParameterIndex) {
            String s = className + "." + methodName + "(";
            int index = 0;
            for (String parameterClass : parameterClasses) {
                String parameterClassAndName = parameterClass + " " + parameterNames.get(index);
                if (index == checkedParameterIndex) {
                    parameterClassAndName = "*" + parameterClassAndName + "*";
                }
                s = s + parameterClassAndName + ", ";
                ++index;
            }
            s = s.substring(0, s.length() - 2);
            s = s + ")";
            return s;
        }
    }

    public static enum Type {
        IS_NULL_METHOD("IsNull Method"),
        IS_NOT_NULL_METHOD("IsNotNull Method"),
        ASSERT_IS_NULL_METHOD("Assert IsNull Method"),
        ASSERT_IS_NOT_NULL_METHOD("Assert IsNotNull Method"),
        ASSERT_TRUE_METHOD("Assert True Method"),
        ASSERT_FALSE_METHOD("Assert False Method");

        private final String myStringRepresentation;

        private Type(String stringRepresentation) {
            this.myStringRepresentation = stringRepresentation;
        }

        public String toString() {
            return this.myStringRepresentation;
        }
    }
}

