/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.EnterProcessor;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import org.jetbrains.annotations.Nullable;

public class LeaveCodeBlockEnterProcessor
implements EnterProcessor {
    private static final TokenSet CONTROL_FLOW_ELEMENT_TYPES = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.IF_STATEMENT, JavaElementType.WHILE_STATEMENT, JavaElementType.DO_WHILE_STATEMENT, JavaElementType.FOR_STATEMENT, JavaElementType.FOREACH_STATEMENT});

    @Override
    public boolean doEnter(Editor editor, PsiElement psiElement, boolean isModified) {
        int i;
        CharSequence text;
        PsiElement parent = psiElement.getParent();
        if (!(parent instanceof PsiCodeBlock)) {
            return false;
        }
        ASTNode node = psiElement.getNode();
        if (node != null && CONTROL_FLOW_ELEMENT_TYPES.contains(node.getElementType())) {
            return false;
        }
        boolean leaveCodeBlock = LeaveCodeBlockEnterProcessor.isControlFlowBreak(psiElement);
        if (!leaveCodeBlock) {
            return false;
        }
        int offset = parent.getTextRange().getEndOffset();
        if (offset < (text = editor.getDocument().getCharsSequence()).length() - 1 && (i = CharArrayUtil.shiftForward((CharSequence)text, (int)(offset + 1), (String)" \t")) < text.length() && text.charAt(i) == '\n') {
            editor.getCaretModel().moveToOffset(offset + 1);
            EditorActionManager actionManager = EditorActionManager.getInstance();
            EditorActionHandler actionHandler = actionManager.getActionHandler("EditorLineEnd");
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
            if (dataContext != null) {
                actionHandler.execute(editor, dataContext);
                return true;
            }
        }
        editor.getCaretModel().moveToOffset(offset);
        return false;
    }

    private static boolean isControlFlowBreak(@Nullable PsiElement element) {
        return element instanceof PsiReturnStatement || element instanceof PsiThrowStatement;
    }
}

